/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.gui.subGui;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.configurations.gui.AuctionConfig;
import fr.florianpal.fauction.enums.CancelReason;
import fr.florianpal.fauction.events.AuctionCancelEvent;
import fr.florianpal.fauction.gui.AbstractGuiWithAuctions;
import fr.florianpal.fauction.gui.subGui.AuctionConfirmGui;
import fr.florianpal.fauction.gui.visualization.InventoryVisualization;
import fr.florianpal.fauction.languages.MessageKeys;
import fr.florianpal.fauction.objects.Auction;
import fr.florianpal.fauction.objects.Category;
import fr.florianpal.fauction.utils.CurrencyUtil;
import fr.florianpal.fauction.utils.ItemUtil;
import fr.florianpal.fauction.utils.MessageUtil;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Barrel;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.plugin.Plugin;

public class AuctionsGui
extends AbstractGuiWithAuctions {
    private final AuctionConfig auctionConfig;

    public AuctionsGui(FAuction plugin, Player player, List<Auction> auctions, int page, Category category) {
        super(plugin, player, page, auctions, category, plugin.getConfigurationManager().getAuctionConfig());
        this.auctionConfig = plugin.getConfigurationManager().getAuctionConfig();
    }

    @Override
    protected void previousAction() {
        FAuction.newChain().asyncFirst(this.auctionCommandManager::getAuctions).syncLast(auctions -> {
            AuctionsGui gui = new AuctionsGui(this.plugin, this.player, (List<Auction>)auctions, this.page - 1, this.category);
            gui.initialize();
        }).execute();
    }

    @Override
    protected void nextAction() {
        FAuction.newChain().asyncFirst(this.auctionCommandManager::getAuctions).syncLast(auctions -> {
            AuctionsGui gui = new AuctionsGui(this.plugin, this.player, (List<Auction>)auctions, this.page + 1, this.category);
            gui.initialize();
        }).execute();
    }

    @Override
    protected void categoryAction(Category nextCategory) {
        FAuction.newChain().asyncFirst(this.auctionCommandManager::getAuctions).syncLast(auctions -> {
            AuctionsGui gui = new AuctionsGui(this.plugin, this.player, (List<Auction>)auctions, 1, nextCategory);
            gui.initialize();
        }).execute();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory() != this.inv || this.inv.getHolder() != this || this.player != e.getWhoClicked()) {
            return;
        }
        e.setCancelled(true);
        ItemStack clickedItem = e.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (this.guiClick(e)) {
            return;
        }
        if (this.spamManager.spamTest(this.player)) {
            return;
        }
        for (int index : this.auctionConfig.getBaseBlocks()) {
            if (index != e.getRawSlot()) continue;
            int nb0 = this.auctionConfig.getBaseBlocks().get(0);
            int nb = (e.getRawSlot() - nb0) / 9;
            Auction auction = (Auction)this.auctions.get(e.getRawSlot() - nb0 + (this.auctionConfig.getBaseBlocks().size() * this.page - this.auctionConfig.getBaseBlocks().size()) - nb * 2);
            if (e.isRightClick()) {
                FAuction.newChain().asyncFirst(() -> this.auctionCommandManager.auctionExist(auction.getId())).syncLast(a -> {
                    boolean isModCanCancel;
                    if (a == null) {
                        return;
                    }
                    boolean bl = isModCanCancel = e.isShiftClick() && this.player.hasPermission("fauction.mod.cancel");
                    if (!a.getPlayerUUID().equals(this.player.getUniqueId()) && !isModCanCancel) {
                        InventoryVisualization inventoryVisualization = null;
                        if (ItemUtil.isShulker(a.getItemStack())) {
                            BlockStateMeta blockStateMeta = (BlockStateMeta)a.getItemStack().getItemMeta();
                            ShulkerBox shulkerBox = (ShulkerBox)blockStateMeta.getBlockState();
                            inventoryVisualization = new InventoryVisualization(this.plugin, this.player, shulkerBox);
                        } else if (ItemUtil.isBarrel(a.getItemStack())) {
                            BlockStateMeta blockStateMeta = (BlockStateMeta)a.getItemStack().getItemMeta();
                            Barrel barrel = (Barrel)blockStateMeta.getBlockState();
                            inventoryVisualization = new InventoryVisualization(this.plugin, this.player, barrel);
                        }
                        if (inventoryVisualization != null) {
                            Bukkit.getPluginManager().registerEvents(inventoryVisualization, (Plugin)this.plugin);
                            inventoryVisualization.open();
                        }
                        return;
                    }
                    try {
                        this.auctionCommandManager.deleteAuction(a.getId());
                        if (!isModCanCancel) {
                            if (this.player.getInventory().firstEmpty() == -1) {
                                this.player.getWorld().dropItem(this.player.getLocation(), a.getItemStack());
                            } else {
                                this.player.getInventory().addItem(new ItemStack[]{a.getItemStack()});
                            }
                        }
                        if (isModCanCancel) {
                            this.plugin.getExpireCommandManager().addExpire((Auction)a);
                            this.plugin.getLogger().info("Modo delete from ah auction : " + a.getId() + ", Item : " + a.getItemStack().getItemMeta().getDisplayName() + " of " + a.getPlayerName() + ", by" + this.player.getName());
                            Bukkit.getPluginManager().callEvent((Event)new AuctionCancelEvent(this.player, (Auction)a, CancelReason.MODERATOR));
                        } else {
                            this.plugin.getLogger().info("Player delete from ah auction : " + a.getId() + ", Item : " + a.getItemStack().getItemMeta().getDisplayName() + " of " + a.getPlayerName() + ", by" + this.player.getName());
                            Bukkit.getPluginManager().callEvent((Event)new AuctionCancelEvent(this.player, (Auction)a, CancelReason.PLAYER));
                        }
                        this.auctions.remove(a);
                        MessageUtil.sendMessage(this.plugin, this.player, MessageKeys.REMOVE_AUCTION_SUCCESS, new String[0]);
                    }
                    catch (Exception exception) {
                        this.plugin.getLogger().severe(exception.toString());
                    }
                    this.player.closeInventory();
                    FAuction.newChain().asyncFirst(this.auctionCommandManager::getAuctions).syncLast(auctionsNew -> {
                        AuctionsGui gui = new AuctionsGui(this.plugin, this.player, (List<Auction>)auctionsNew, 1, this.category);
                        gui.initialize();
                    }).execute();
                }).execute();
                break;
            }
            if (!e.isLeftClick()) break;
            if (auction.getPlayerUUID().equals(this.player.getUniqueId())) {
                MessageUtil.sendMessage(this.plugin, this.player, MessageKeys.BUY_YOUR_ITEM, new String[0]);
                return;
            }
            if (!CurrencyUtil.haveCurrency(this.plugin, (OfflinePlayer)this.player, this.globalConfig.getCurrencyType(), auction.getPrice())) {
                MessageUtil.sendMessage(this.plugin, this.player, MessageKeys.NO_HAVE_MONEY, new String[0]);
                return;
            }
            AuctionConfirmGui auctionConfirmGui = new AuctionConfirmGui(this.plugin, this.player, this.page, auction);
            auctionConfirmGui.initialize();
            break;
        }
    }
}

