/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.gui.subGui;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.configurations.gui.AuctionConfirmGuiConfig;
import fr.florianpal.fauction.events.AuctionBuyEvent;
import fr.florianpal.fauction.gui.AbstractGuiWithAuctions;
import fr.florianpal.fauction.gui.subGui.AuctionsGui;
import fr.florianpal.fauction.languages.MessageKeys;
import fr.florianpal.fauction.objects.Auction;
import fr.florianpal.fauction.objects.Barrier;
import fr.florianpal.fauction.objects.Category;
import fr.florianpal.fauction.objects.Confirm;
import fr.florianpal.fauction.objects.Historic;
import fr.florianpal.fauction.utils.CurrencyUtil;
import fr.florianpal.fauction.utils.FormatUtil;
import fr.florianpal.fauction.utils.MessageUtil;
import fr.florianpal.fauction.utils.PlaceholderUtil;
import fr.florianpal.fauction.utils.PlayerHeadUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class AuctionConfirmGui
extends AbstractGuiWithAuctions {
    private final Auction auction;
    protected final AuctionConfirmGuiConfig auctionConfirmConfig;
    private final Map<Integer, Confirm> confirmList = new HashMap<Integer, Confirm>();

    AuctionConfirmGui(FAuction plugin, Player player, int page, Auction auction) {
        super(plugin, player, page, Collections.singletonList(auction), null, plugin.getConfigurationManager().getAuctionConfirmConfig());
        this.auction = auction;
        this.auctionConfirmConfig = plugin.getConfigurationManager().getAuctionConfirmConfig();
    }

    @Override
    public void initialize() {
        this.initGui(this.abstractGuiConfig.getNameGui(), this.abstractGuiConfig.getSize());
        this.initBarrier();
        for (Barrier barrier : this.auctionConfirmConfig.getBarrierBlocks()) {
            this.inv.setItem(barrier.getIndex(), this.getItemStack(barrier, false));
        }
        for (Integer index : this.auctionConfirmConfig.getBaseBlocks()) {
            this.inv.setItem(index.intValue(), this.createGuiItem(this.auction));
        }
        int id = 0;
        for (Confirm entry : this.auctionConfirmConfig.getConfirmBlocks()) {
            Confirm confirm = new Confirm(entry.getIndex(), this.auction, entry.getMaterial(), entry.isValue(), entry.getTexture(), entry.getCustomModelData());
            this.confirmList.put(entry.getIndex(), confirm);
            this.inv.setItem(entry.getIndex(), this.createGuiItem(confirm));
            if (++id < this.auctionConfirmConfig.getConfirmBlocks().size()) continue;
            break;
        }
        this.openInventory(this.player);
    }

    @Override
    public ItemStack createGuiItem(Auction auction) {
        ItemStack item = auction.getItemStack().clone();
        ItemMeta meta = item.getItemMeta();
        String title = this.auctionConfirmConfig.getAuctionTitle();
        title = item.getItemMeta().getDisplayName().equalsIgnoreCase("") ? title.replace("{ItemName}", item.getType().name().replace('_', ' ').toLowerCase()) : title.replace("{ItemName}", item.getItemMeta().getDisplayName());
        title = title.replace("{OwnerName}", auction.getPlayerName());
        title = title.replace("{Price}", this.df.format(auction.getPrice()));
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)auction.getPlayerUUID());
        if (offlinePlayer != null) {
            title = PlaceholderUtil.parsePlaceholder(this.plugin.isPlaceholderAPIEnabled(), offlinePlayer, title);
        }
        title = FormatUtil.format(title);
        ArrayList<String> listDescription = new ArrayList<String>();
        for (String desc : this.auctionConfirmConfig.getAuctionDescription()) {
            desc = item.getItemMeta().getDisplayName().equalsIgnoreCase("") ? desc.replace("{ItemName}", item.getType().name().replace('_', ' ').toLowerCase()) : desc.replace("{ItemName}", item.getItemMeta().getDisplayName());
            desc = desc.replace("{OwnerName}", auction.getPlayerName());
            if (auction instanceof Historic) {
                Historic historic = (Historic)auction;
                desc = desc.replace("{BuyerName}", historic.getPlayerBuyerName());
            }
            if (offlinePlayer != null) {
                desc = PlaceholderUtil.parsePlaceholder(this.plugin.isPlaceholderAPIEnabled(), offlinePlayer, desc);
            }
            desc = desc.replace("{Price}", this.df.format(auction.getPrice()));
            Date expireDate = new Date(auction.getDate().getTime() + (long)this.globalConfig.getTime() * 1000L);
            desc = desc.replace("{ExpireTime}", this.dateFormater.format(expireDate));
            Duration duration = Duration.between(new Date().toInstant(), new Date(auction.getDate().getTime() + (long)this.globalConfig.getTime() * 1000L).toInstant());
            if ((desc = desc.replace("{RemainingTime}", FormatUtil.durationFormat(this.globalConfig.getRemainingDateFormat(), duration))).contains("lore")) {
                if (item.getItemMeta().getLore() != null) {
                    listDescription.addAll(item.getItemMeta().getLore());
                    continue;
                }
                listDescription.add(desc.replace("{lore}", ""));
                continue;
            }
            desc = FormatUtil.format(desc);
            listDescription.add(desc);
        }
        if (meta != null) {
            if (this.auctionConfirmConfig.isReplaceTitle()) {
                meta.setDisplayName(title);
            }
            meta.setLore(listDescription);
            item.setItemMeta(meta);
        }
        return item;
    }

    @Override
    protected void previousAction() {
    }

    @Override
    protected void nextAction() {
    }

    @Override
    protected void categoryAction(Category nextCategory) {
    }

    private ItemStack createGuiItem(Confirm confirm) {
        ItemStack item = new ItemStack(confirm.getMaterial(), 1);
        ItemMeta meta = item.getItemMeta();
        String title = confirm.isValue() ? this.auctionConfirmConfig.getTitleTrue() : this.auctionConfirmConfig.getTitleFalse();
        ItemStack itemStack = confirm.getAuction().getItemStack().clone();
        title = FormatUtil.titleItemFormat(confirm.getAuction().getItemStack(), "{Item}", title);
        title = title.replace("{Price}", this.df.format(confirm.getAuction().getPrice()));
        title = title.replace("{OwnerName}", confirm.getAuction().getPlayerName());
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.auction.getPlayerUUID());
        if (offlinePlayer != null) {
            title = PlaceholderUtil.parsePlaceholder(this.plugin.isPlaceholderAPIEnabled(), offlinePlayer, title);
        }
        title = FormatUtil.format(title);
        ArrayList<String> listDescription = new ArrayList<String>();
        for (String desc : this.auctionConfirmConfig.getDescription()) {
            desc = desc.replace("{Price}", this.df.format(confirm.getAuction().getPrice()));
            desc = FormatUtil.titleItemFormat(confirm.getAuction().getItemStack(), "{Item}", desc);
            desc = desc.replace("{OwnerName}", confirm.getAuction().getPlayerName());
            if (offlinePlayer != null) {
                desc = PlaceholderUtil.parsePlaceholder(this.plugin.isPlaceholderAPIEnabled(), offlinePlayer, desc);
            }
            desc = FormatUtil.format(desc);
            listDescription.add(desc);
        }
        if (meta != null) {
            meta.setDisplayName(title);
            meta.setLore(listDescription);
            meta.setCustomModelData(Integer.valueOf(confirm.getCustomModelData()));
            item.setItemMeta(meta);
        }
        if (confirm.getMaterial() == Material.PLAYER_HEAD) {
            PlayerHeadUtil.addTexture(itemStack, confirm.getTexture());
            itemStack.setAmount(1);
        }
        return item;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory() != this.inv || this.inv.getHolder() != this || this.player != e.getWhoClicked()) {
            return;
        }
        e.setCancelled(true);
        ItemStack clickedItem = e.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (this.guiClick(e)) {
            return;
        }
        if (this.spamManager.spamTest(this.player)) {
            return;
        }
        for (Confirm entry : this.auctionConfirmConfig.getConfirmBlocks()) {
            if (entry.getIndex() != e.getRawSlot()) continue;
            Confirm confirm = this.confirmList.get(e.getRawSlot());
            if (!confirm.isValue()) {
                MessageUtil.sendMessage(this.plugin, this.player, MessageKeys.BUY_AUCTION_CANCELLED, new String[0]);
                FAuction.newChain().asyncFirst(this.auctionCommandManager::getAuctions).syncLast(auctions -> {
                    AuctionsGui gui = new AuctionsGui(this.plugin, this.player, (List<Auction>)auctions, 1, null);
                    gui.initialize();
                }).execute();
                return;
            }
            FAuction.newChain().asyncFirst(() -> this.auctionCommandManager.auctionExist(this.auction.getId())).syncLast(a -> {
                if (a == null) {
                    MessageUtil.sendMessage(this.plugin, this.player, MessageKeys.NO_AUCTION, new String[0]);
                    return;
                }
                FAuction.newChain().asyncFirst(() -> this.auctionCommandManager.auctionExist(this.auction.getId())).syncLast(auctionGood -> {
                    if (auctionGood == null) {
                        MessageUtil.sendMessage(this.plugin, this.player, MessageKeys.AUCTION_ALREADY_SELL, new String[0]);
                        return;
                    }
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)auctionGood.getPlayerUUID());
                    if (offlinePlayer == null) {
                        return;
                    }
                    if (!CurrencyUtil.haveCurrency(this.plugin, (OfflinePlayer)this.player, this.globalConfig.getCurrencyType(), auctionGood.getPrice())) {
                        MessageUtil.sendMessage(this.plugin, this.player, MessageKeys.NO_HAVE_MONEY, new String[0]);
                        return;
                    }
                    if (!CurrencyUtil.getCurrency(this.plugin, (OfflinePlayer)this.player, this.globalConfig.getCurrencyType(), auctionGood.getPrice())) {
                        return;
                    }
                    if (!CurrencyUtil.giveCurrency(this.plugin, offlinePlayer, this.globalConfig.getCurrencyType(), auctionGood.getPrice())) {
                        return;
                    }
                    MessageUtil.sendMessage(this.plugin, this.player, MessageKeys.BUY_AUCTION_SUCCESS, new String[0]);
                    if (offlinePlayer.isOnline()) {
                        MessageUtil.sendMessage(this.plugin, offlinePlayer.getPlayer(), MessageKeys.BUY_AUCTION_TARGET_SUCCESS, "{player}", this.player.getName(), "{item}", FormatUtil.titleItemFormat(auctionGood.getItemStack()), "{price}", String.valueOf(auctionGood.getPrice()));
                    }
                    this.auctionCommandManager.deleteAuction(auctionGood.getId());
                    this.historicCommandManager.addHistoric((Auction)a, this.player.getUniqueId(), this.player.getName());
                    if (this.player.getInventory().firstEmpty() == -1) {
                        this.player.getWorld().dropItem(this.player.getLocation(), auctionGood.getItemStack());
                    } else {
                        this.player.getInventory().addItem(new ItemStack[]{auctionGood.getItemStack()});
                    }
                    Bukkit.getPluginManager().callEvent((Event)new AuctionBuyEvent(this.player, (Auction)a));
                    if (this.plugin.getConfigurationManager().getGlobalConfig().isOnBuyCommandUse()) {
                        String command = this.getCommand((Auction)auctionGood);
                        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), command);
                    }
                    this.plugin.getLogger().info("Player : " + this.player.getName() + " buy " + auctionGood.getItemStack().getItemMeta().getDisplayName() + " at " + auctionGood.getPlayerName());
                    FAuction.newChain().asyncFirst(this.auctionCommandManager::getAuctions).syncLast(auctions -> {
                        AuctionsGui gui = new AuctionsGui(this.plugin, this.player, (List<Auction>)auctions, 1, null);
                        gui.initialize();
                    }).execute();
                }).execute();
            }).execute();
            break;
        }
    }

    @NotNull
    private String getCommand(Auction auctionGood) {
        String command = this.plugin.getConfigurationManager().getGlobalConfig().getOnBuyCommand();
        command = command.replace("{OwnerName}", auctionGood.getPlayerName());
        command = command.replace("{Amount}", String.valueOf(auctionGood.getItemStack().getAmount()));
        command = !auctionGood.getItemStack().getItemMeta().getDisplayName().equalsIgnoreCase("") ? command.replace("{ItemName}", auctionGood.getItemStack().getItemMeta().getDisplayName()) : command.replace("{ItemName}", auctionGood.getItemStack().getType().name().replace('_', ' ').toLowerCase());
        command = command.replace("{BuyerName}", this.player.getName());
        command = command.replace("{ItemPrice}", this.df.format(auctionGood.getPrice()));
        return command;
    }
}

