/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.gui;

import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.configurations.GlobalConfig;
import fr.florianpal.fauction.configurations.gui.AbstractGuiConfig;
import fr.florianpal.fauction.gui.subGui.AuctionsGui;
import fr.florianpal.fauction.gui.subGui.ExpireGui;
import fr.florianpal.fauction.gui.subGui.HistoricGui;
import fr.florianpal.fauction.gui.subGui.MainGui;
import fr.florianpal.fauction.gui.subGui.PlayerViewGui;
import fr.florianpal.fauction.managers.SpamManager;
import fr.florianpal.fauction.managers.commandmanagers.AuctionCommandManager;
import fr.florianpal.fauction.managers.commandmanagers.CommandManager;
import fr.florianpal.fauction.managers.commandmanagers.ExpireCommandManager;
import fr.florianpal.fauction.managers.commandmanagers.HistoricCommandManager;
import fr.florianpal.fauction.objects.Auction;
import fr.florianpal.fauction.objects.Barrier;
import fr.florianpal.fauction.objects.BarrierMenu;
import fr.florianpal.fauction.objects.BarrierWithCategory;
import fr.florianpal.fauction.utils.FormatUtil;
import fr.florianpal.fauction.utils.ListUtil;
import fr.florianpal.fauction.utils.PlaceholderUtil;
import fr.florianpal.fauction.utils.PlayerHeadUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AbstractGui
implements InventoryHolder,
Listener {
    protected Inventory inv;
    protected final FAuction plugin;
    protected Player player;
    protected int page;
    protected final GlobalConfig globalConfig;
    protected final CommandManager commandManager;
    protected final AuctionCommandManager auctionCommandManager;
    protected final ExpireCommandManager expireCommandManager;
    protected final HistoricCommandManager historicCommandManager;
    protected final SpamManager spamManager;
    protected AbstractGuiConfig abstractGuiConfig;
    protected DecimalFormat df;
    protected SimpleDateFormat dateFormater;

    protected AbstractGui(FAuction plugin, Player player, int page, AbstractGuiConfig abstractGuiConfig) {
        this.plugin = plugin;
        this.player = player;
        this.page = page;
        this.commandManager = plugin.getCommandManager();
        this.inv = null;
        this.globalConfig = plugin.getConfigurationManager().getGlobalConfig();
        this.auctionCommandManager = plugin.getAuctionCommandManager();
        this.expireCommandManager = plugin.getExpireCommandManager();
        this.historicCommandManager = plugin.getHistoricCommandManager();
        this.spamManager = plugin.getSpamManager();
        this.abstractGuiConfig = abstractGuiConfig;
        if (abstractGuiConfig == null) {
            plugin.getLogger().severe("Error when load custom menu. Cannot found config");
            return;
        }
        this.df = new DecimalFormat(plugin.getConfigurationManager().getGlobalConfig().getDecimalFormat());
        this.df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        this.dateFormater = new SimpleDateFormat(this.globalConfig.getDateFormat());
        Bukkit.getPluginManager().registerEvents((Listener)this, Bukkit.getPluginManager().getPlugins()[0]);
    }

    public void initialize() {
        this.initGui(this.abstractGuiConfig.getNameGui(), this.abstractGuiConfig.getSize());
        this.initBarrier();
        this.openInventory(this.player);
    }

    protected void initGui(String title, int size) {
        this.inv = this.abstractGuiConfig.getType() == InventoryType.CHEST ? Bukkit.createInventory((InventoryHolder)this, (int)size, (String)FormatUtil.format(title)) : Bukkit.createInventory((InventoryHolder)this, (InventoryType)this.abstractGuiConfig.getType(), (String)FormatUtil.format(title));
    }

    public void openInventory(Player p) {
        p.openInventory(this.inv);
    }

    protected void initBarrier() {
        for (Barrier barrier : this.abstractGuiConfig.getBarrierBlocks()) {
            this.inv.setItem(barrier.getIndex(), this.createGuiItem(this.getItemStack(barrier, false)));
        }
        for (Barrier barrier : this.abstractGuiConfig.getExpireBlocks()) {
            this.inv.setItem(barrier.getIndex(), this.createGuiItem(this.getItemStack(barrier, false)));
        }
        for (Barrier barrier : this.abstractGuiConfig.getPlayerBlocks()) {
            this.inv.setItem(barrier.getIndex(), this.createGuiItem(this.getItemStack(barrier, false)));
        }
        for (Barrier barrier : this.abstractGuiConfig.getAuctionGuiBlocks()) {
            this.inv.setItem(barrier.getIndex(), this.createGuiItem(this.getItemStack(barrier, false)));
        }
        for (Barrier barrier : this.abstractGuiConfig.getCloseBlocks()) {
            this.inv.setItem(barrier.getIndex(), this.createGuiItem(this.getItemStack(barrier, false)));
        }
        for (Barrier barrier : this.abstractGuiConfig.getHistoricBlocks()) {
            this.inv.setItem(barrier.getIndex(), this.createGuiItem(this.getItemStack(barrier, false)));
        }
        for (Barrier barrier : this.abstractGuiConfig.getMenuBlocks()) {
            this.inv.setItem(barrier.getIndex(), this.createGuiItem(this.getItemStack(barrier, false)));
        }
        for (Barrier barrier : this.abstractGuiConfig.getCommandBlocks()) {
            this.inv.setItem(barrier.getIndex(), this.createGuiItem(this.getItemStack(barrier, false)));
        }
    }

    public ItemStack createGuiItem(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null || meta.getDisplayName() == null || meta.getLore() == null) {
            return itemStack;
        }
        String name = FormatUtil.format(meta.getDisplayName());
        ArrayList<String> descriptions = new ArrayList<String>();
        for (String desc : meta.getLore()) {
            desc = FormatUtil.format(desc);
            descriptions.add(desc);
        }
        meta.setDisplayName(name);
        meta.setLore(descriptions);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public ItemStack getItemStack(Barrier barrier, boolean isRemplacement) {
        ItemStack itemStack;
        if (isRemplacement) {
            itemStack = this.getItemStack(barrier.getRemplacement(), false);
        } else {
            itemStack = new ItemStack(barrier.getMaterial(), 1);
            if (barrier.getMaterial() == Material.PLAYER_HEAD) {
                PlayerHeadUtil.addTexture(itemStack, barrier.getTexture());
                itemStack.setAmount(1);
            }
            ArrayList<String> descriptions = new ArrayList<String>();
            for (String desc : barrier.getDescription()) {
                desc = FormatUtil.format(desc);
                desc = PlaceholderUtil.parsePlaceholder(this.plugin.isPlaceholderAPIEnabled(), (OfflinePlayer)this.player, desc);
                descriptions.add(desc);
            }
            ItemMeta meta = itemStack.getItemMeta();
            if (meta != null) {
                String title = barrier.getTitle();
                title = PlaceholderUtil.parsePlaceholder(this.plugin.isPlaceholderAPIEnabled(), (OfflinePlayer)this.player, title);
                meta.setDisplayName(FormatUtil.format(title));
                meta.setLore(descriptions);
                meta.setCustomModelData(Integer.valueOf(barrier.getCustomModelData()));
                itemStack.setItemMeta(meta);
            }
        }
        return itemStack;
    }

    public boolean guiClick(InventoryClickEvent e) {
        Optional<BarrierWithCategory> auctionGuiBarrierOptional = this.abstractGuiConfig.getAuctionGuiBlocks().stream().filter(auctionGui -> e.getRawSlot() == auctionGui.getIndex()).findFirst();
        if (auctionGuiBarrierOptional.isPresent()) {
            FAuction.newChain().asyncFirst(this.auctionCommandManager::getAuctions).syncLast(auctions -> {
                AuctionsGui gui = new AuctionsGui(this.plugin, this.player, (List<Auction>)auctions, 1, ((BarrierWithCategory)auctionGuiBarrierOptional.get()).getCategory());
                gui.initialize();
            }).execute();
            return true;
        }
        Optional<BarrierWithCategory> expireGuiBarrierOptional = this.abstractGuiConfig.getExpireBlocks().stream().filter(expire -> e.getRawSlot() == expire.getIndex()).findFirst();
        if (expireGuiBarrierOptional.isPresent()) {
            FAuction.newChain().asyncFirst(() -> this.expireCommandManager.getExpires(this.player.getUniqueId())).syncLast(auctions -> {
                ExpireGui gui = new ExpireGui(this.plugin, this.player, (List<Auction>)auctions, 1, ((BarrierWithCategory)expireGuiBarrierOptional.get()).getCategory());
                gui.initialize();
            }).execute();
            return true;
        }
        boolean isClose = this.abstractGuiConfig.getCloseBlocks().stream().anyMatch(close -> e.getRawSlot() == close.getIndex());
        if (isClose) {
            this.player.closeInventory();
            return true;
        }
        Optional<Barrier> commandBarrierOptional = this.abstractGuiConfig.getCommandBlocks().stream().filter(close -> e.getRawSlot() == close.getIndex()).findFirst();
        if (commandBarrierOptional.isPresent()) {
            Bukkit.dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), (String)commandBarrierOptional.get().getValue());
            return true;
        }
        Optional<BarrierWithCategory> playerGuiBarrierOptional = this.abstractGuiConfig.getPlayerBlocks().stream().filter(p -> e.getRawSlot() == p.getIndex()).findFirst();
        if (playerGuiBarrierOptional.isPresent()) {
            FAuction.newChain().asyncFirst(() -> this.auctionCommandManager.getAuctions(this.player.getUniqueId())).syncLast(auctions -> {
                PlayerViewGui gui = new PlayerViewGui(this.plugin, this.player, (List<Auction>)auctions, 1, ((BarrierWithCategory)playerGuiBarrierOptional.get()).getCategory());
                gui.initialize();
            }).execute();
            return true;
        }
        Optional<BarrierWithCategory> historicGuiBarrierOptional = this.abstractGuiConfig.getHistoricBlocks().stream().filter(p -> e.getRawSlot() == p.getIndex()).findFirst();
        if (historicGuiBarrierOptional.isPresent()) {
            FAuction.newChain().asyncFirst(() -> this.historicCommandManager.getHistorics(this.player.getUniqueId())).syncLast(historics -> {
                HistoricGui gui = new HistoricGui(this.plugin, this.player, ListUtil.historicToAuction(historics), 1, ((BarrierWithCategory)historicGuiBarrierOptional.get()).getCategory());
                gui.initialize();
            }).execute();
            return true;
        }
        Optional<BarrierMenu> menuGuiBarrierOptional = this.abstractGuiConfig.getMenuBlocks().stream().filter(p -> e.getRawSlot() == p.getIndex()).findFirst();
        if (menuGuiBarrierOptional.isPresent()) {
            MainGui gui = new MainGui(this.plugin, menuGuiBarrierOptional.get().getId(), this.player, 1);
            gui.initialize();
            return true;
        }
        return false;
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

