/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.configurations.gui;

import dev.dejvokep.boostedyaml.YamlDocument;
import fr.florianpal.fauction.FAuction;
import fr.florianpal.fauction.configurations.gui.AbstractGuiConfig;
import fr.florianpal.fauction.enums.BlockType;
import fr.florianpal.fauction.objects.Barrier;
import fr.florianpal.fauction.objects.Confirm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;

public abstract class AbstractGuiWithAuctionsConfig
extends AbstractGuiConfig {
    protected List<Integer> baseBlocks = new ArrayList<Integer>();
    protected List<Barrier> previousBlocks = new ArrayList<Barrier>();
    protected List<Barrier> nextBlocks = new ArrayList<Barrier>();
    protected List<Barrier> categoriesBlocks = new ArrayList<Barrier>();
    protected List<Confirm> confirmBlocks = new ArrayList<Confirm>();
    protected String title = "";
    protected boolean replaceTitle = true;
    protected List<String> description = new ArrayList<String>();

    @Override
    public void load(FAuction plugin, YamlDocument config, String baseBlock) {
        super.load(plugin, config, baseBlock);
        this.previousBlocks = new ArrayList<Barrier>();
        this.nextBlocks = new ArrayList<Barrier>();
        this.baseBlocks = new ArrayList<Integer>();
        this.description = new ArrayList<String>();
        this.categoriesBlocks = new ArrayList<Barrier>();
        this.confirmBlocks = new ArrayList<Confirm>();
        for (Object indexObject : config.getSection("block").getKeys()) {
            Barrier barrier;
            String index = indexObject.toString();
            String currentUtility = config.getString("block." + index + ".utility");
            if (Arrays.stream(BlockType.values()).noneMatch(b -> b.equalsIgnoreCase(currentUtility) || currentUtility.equalsIgnoreCase(baseBlock))) {
                plugin.getLogger().severe("Error : unknown block type " + currentUtility);
                return;
            }
            if (BlockType.PREVIOUS.equalsIgnoreCase(currentUtility)) {
                barrier = new Barrier(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".material", Material.BARRIER.toString())), config.getString("block." + index + ".title"), config.getStringList("block." + index + ".description"), null, new Barrier(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".replacement.material", Material.BARRIER.toString())), config.getString("block." + index + ".replacement.title"), config.getStringList("block." + index + ".replacement.description"), null, config.getString("block." + index + ".replacement.texture", ""), config.getInt("block." + index + ".replacement.customModelData", (Integer)0)), config.getString("block." + index + ".texture", ""), config.getInt("block." + index + ".customModelData", (Integer)0));
                this.previousBlocks.add(barrier);
                continue;
            }
            if (BlockType.NEXT.equalsIgnoreCase(currentUtility)) {
                barrier = new Barrier(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".material", Material.BARRIER.toString())), config.getString("block." + index + ".title"), config.getStringList("block." + index + ".description"), null, new Barrier(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".replacement.material", Material.BARRIER.toString())), config.getString("block." + index + ".replacement.title"), config.getStringList("block." + index + ".replacement.description"), null, config.getString("block." + index + ".replacement.texture", ""), config.getInt("block." + index + ".replacement.customModelData", (Integer)0)), config.getString("block." + index + ".texture", ""), config.getInt("block." + index + ".customModelData", (Integer)0));
                this.nextBlocks.add(barrier);
                continue;
            }
            if (BlockType.CATEGORY.equalsIgnoreCase(currentUtility)) {
                barrier = new Barrier(Integer.parseInt(index), Material.getMaterial((String)config.getString("block." + index + ".material", Material.BARRIER.toString())), config.getString("block." + index + ".title"), config.getStringList("block." + index + ".description"), null, config.getString("block." + index + ".texture", ""), config.getInt("block." + index + ".customModelData", (Integer)0));
                this.categoriesBlocks.add(barrier);
                continue;
            }
            if (baseBlock.equalsIgnoreCase(currentUtility)) {
                this.baseBlocks.add(Integer.valueOf(index));
                continue;
            }
            if (!BlockType.CONFIRM.equalsIgnoreCase(currentUtility)) continue;
            this.confirmBlocks.add(new Confirm(Integer.parseInt(index), null, Material.getMaterial((String)config.getString("block." + index + ".material", Material.BARRIER.toString())), config.getBoolean("block." + index + ".value"), config.getString("block." + index + ".texture", ""), config.getInt("block." + index + ".customModelData", (Integer)0)));
        }
        this.title = config.getString("gui.title");
        this.replaceTitle = config.getBoolean("gui.replaceTitle", (Boolean)true);
        this.description.addAll(config.getStringList("gui.description"));
    }

    public List<Integer> getBaseBlocks() {
        return this.baseBlocks;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public List<Barrier> getPreviousBlocks() {
        return this.previousBlocks;
    }

    public List<Barrier> getNextBlocks() {
        return this.nextBlocks;
    }

    public boolean isReplaceTitle() {
        return this.replaceTitle;
    }

    public List<Barrier> getCategoriesBlocks() {
        return this.categoriesBlocks;
    }
}

