/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.configurations;

import dev.dejvokep.boostedyaml.YamlDocument;
import fr.florianpal.fauction.enums.CurrencyType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;

public class GlobalConfig {
    private String lang = "en";
    private String orderBy;
    private boolean onBuyCommandUse;
    private boolean securityForSpammingPacket;
    private String dateFormat;
    private String remainingDateFormat;
    private String onBuyCommand;
    private boolean limitationsUseMetaLuckperms = false;
    private Map<String, Integer> limitations = new HashMap<String, Integer>();
    private Map<Material, Double> minPrice = new HashMap<Material, Double>();
    private Map<Material, Double> maxPrice = new HashMap<Material, Double>();
    private List<Material> blacklistItem = new ArrayList<Material>();
    private boolean defaultMaxValueEnable = false;
    private boolean defaultMinValueEnable = false;
    private double defaultMinValue = 0.0;
    private double defaultMaxValue = 1.0E8;
    private int time;
    private int checkEvery;
    private int timeCurrency;
    private int checkEveryCurrency;
    private int updateCacheEvery;
    private boolean featureFlippingExpiration;
    private boolean featureFlippingCacheUpdate;
    private String decimalFormat;
    private String defaultGui;
    private CurrencyType currencyType;

    public void load(YamlDocument config) {
        this.lang = config.getString("lang");
        this.defaultGui = config.getString("defaultGui", "AUCTION");
        this.currencyType = CurrencyType.valueOf(config.getString("currencyUse", "VAULT"));
        this.decimalFormat = config.getString("decimalFormat", "0.00");
        this.featureFlippingExpiration = config.getBoolean("feature-flipping.item-expiration", (Boolean)true);
        this.featureFlippingCacheUpdate = config.getBoolean("feature-flipping.cache-update", (Boolean)true);
        this.orderBy = config.getString("orderBy");
        this.dateFormat = config.getString("dateFormat");
        this.remainingDateFormat = config.getString("remainingDateFormat");
        this.onBuyCommandUse = config.getBoolean("onBuy.sendCommand.use");
        this.onBuyCommand = config.getString("onBuy.sendCommand.command");
        this.securityForSpammingPacket = config.getBoolean("securityForSpammingPacket", (Boolean)true);
        this.time = config.getInt("expiration.time");
        this.checkEvery = config.getInt("expiration.checkEvery");
        this.updateCacheEvery = config.getInt("cacheUpdate", (Integer)72000);
        this.timeCurrency = config.getInt("currency.time");
        this.checkEveryCurrency = config.getInt("currency.checkEvery");
        this.minPrice = new HashMap<Material, Double>();
        this.maxPrice = new HashMap<Material, Double>();
        this.blacklistItem = new ArrayList<Material>();
        this.limitationsUseMetaLuckperms = config.getBoolean("limitations-use-meta-luckperms", (Boolean)false);
        this.limitations = new HashMap<String, Integer>();
        for (Object limitationGroup : config.getSection("limitations").getKeys()) {
            this.limitations.put(limitationGroup.toString(), config.getInt("limitations." + String.valueOf(limitationGroup)));
        }
        if (config.contains("min-price-default")) {
            this.defaultMinValueEnable = config.getBoolean("min-price-default.enable");
            this.defaultMinValue = config.getDouble("min-price-default.value");
        }
        if (config.contains("max-price-default")) {
            this.defaultMaxValueEnable = config.getBoolean("max-price-default.enable");
            this.defaultMaxValue = config.getDouble("max-price-default.value");
        }
        if (config.contains("min-price")) {
            this.minPrice = new HashMap<Material, Double>();
            for (Object material : config.getSection("min-price").getKeys()) {
                this.minPrice.put(Material.valueOf((String)material.toString()), config.getDouble("min-price." + String.valueOf(material)));
            }
        }
        if (config.contains("max-price")) {
            this.maxPrice = new HashMap<Material, Double>();
            for (Object material : config.getSection("max-price").getKeys()) {
                this.maxPrice.put(Material.valueOf((String)material.toString()), config.getDouble("max-price." + String.valueOf(material)));
            }
        }
        if (config.contains("item-blacklist")) {
            this.blacklistItem = config.getStringList("item-blacklist").stream().map(Material::valueOf).collect(Collectors.toList());
        }
    }

    public int getTime() {
        return this.time;
    }

    public int getCheckEvery() {
        return this.checkEvery;
    }

    public Map<String, Integer> getLimitations() {
        return this.limitations;
    }

    public boolean isOnBuyCommandUse() {
        return this.onBuyCommandUse;
    }

    public String getOnBuyCommand() {
        return this.onBuyCommand;
    }

    public Map<Material, Double> getMinPrice() {
        return this.minPrice;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getLang() {
        return this.lang;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public boolean isSecurityForSpammingPacket() {
        return this.securityForSpammingPacket;
    }

    public Map<Material, Double> getMaxPrice() {
        return this.maxPrice;
    }

    public boolean isDefaultMaxValueEnable() {
        return this.defaultMaxValueEnable;
    }

    public boolean isDefaultMinValueEnable() {
        return this.defaultMinValueEnable;
    }

    public double getDefaultMinValue() {
        return this.defaultMinValue;
    }

    public double getDefaultMaxValue() {
        return this.defaultMaxValue;
    }

    public List<Material> getBlacklistItem() {
        return this.blacklistItem;
    }

    public boolean isLimitationsUseMetaLuckperms() {
        return this.limitationsUseMetaLuckperms;
    }

    public int getUpdateCacheEvery() {
        return this.updateCacheEvery;
    }

    public String getRemainingDateFormat() {
        return this.remainingDateFormat;
    }

    public boolean isFeatureFlippingExpiration() {
        return this.featureFlippingExpiration;
    }

    public boolean isFeatureFlippingCacheUpdate() {
        return this.featureFlippingCacheUpdate;
    }

    public String getDecimalFormat() {
        return this.decimalFormat;
    }

    public String getDefaultGui() {
        return this.defaultGui;
    }

    public CurrencyType getCurrencyType() {
        return this.currencyType;
    }

    public int getTimeCurrency() {
        return this.timeCurrency;
    }

    public int getCheckEveryCurrency() {
        return this.checkEveryCurrency;
    }
}

