/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction.acf.lib.timings;

import fr.florianpal.fauction.acf.lib.timings.MCTiming;
import fr.florianpal.fauction.acf.lib.timings.TimingType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;

public class TimingManager {
    private static TimingType timingProvider;
    private static final Object LOCK;
    private final Plugin plugin;
    private final Map<String, MCTiming> timingCache = new HashMap<String, MCTiming>(0);

    private TimingManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public static TimingManager of(Plugin plugin) {
        return new TimingManager(plugin);
    }

    public MCTiming ofStart(String name) {
        return this.ofStart(name, null);
    }

    public MCTiming ofStart(String name, MCTiming parent) {
        return this.of(name, parent).startTiming();
    }

    public MCTiming of(String name) {
        return this.of(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCTiming of(String name, MCTiming parent) {
        if (timingProvider == null) {
            Object object = LOCK;
            synchronized (object) {
                if (timingProvider == null) {
                    try {
                        Class<?> clazz = Class.forName("co.aikar.timings.Timing");
                        Method startTiming = clazz.getMethod("startTiming", new Class[0]);
                        timingProvider = startTiming.getReturnType() != clazz ? TimingType.MINECRAFT_18 : TimingType.MINECRAFT;
                    }
                    catch (ClassNotFoundException | NoSuchMethodException ignored1) {
                        try {
                            Class.forName("org.spigotmc.CustomTimingsHandler");
                            timingProvider = TimingType.SPIGOT;
                        }
                        catch (ClassNotFoundException ignored2) {
                            timingProvider = TimingType.EMPTY;
                        }
                    }
                }
            }
        }
        if (timingProvider.useCache()) {
            MCTiming timing;
            Map<String, MCTiming> map = this.timingCache;
            synchronized (map) {
                String lowerKey = name.toLowerCase();
                timing = this.timingCache.get(lowerKey);
                if (timing == null) {
                    timing = timingProvider.newTiming(this.plugin, name, parent);
                    this.timingCache.put(lowerKey, timing);
                }
            }
            return timing;
        }
        return timingProvider.newTiming(this.plugin, name, parent);
    }

    static {
        LOCK = new Object();
    }
}

