/*
 * Decompiled with CFR 0.152.
 */
package fr.florianpal.fauction;

import co.aikar.taskchain.BukkitTaskChainFactory;
import co.aikar.taskchain.TaskChain;
import co.aikar.taskchain.TaskChainFactory;
import fr.florianpal.fauction.bstats.bukkit.Metrics;
import fr.florianpal.fauction.bstats.charts.AdvancedPie;
import fr.florianpal.fauction.commands.AuctionCommand;
import fr.florianpal.fauction.enums.SQLType;
import fr.florianpal.fauction.managers.ConfigurationManager;
import fr.florianpal.fauction.managers.DatabaseManager;
import fr.florianpal.fauction.managers.SpamManager;
import fr.florianpal.fauction.managers.TransfertManager;
import fr.florianpal.fauction.managers.VaultIntegrationManager;
import fr.florianpal.fauction.managers.commandmanagers.AuctionCommandManager;
import fr.florianpal.fauction.managers.commandmanagers.CommandManager;
import fr.florianpal.fauction.managers.commandmanagers.ExpireCommandManager;
import fr.florianpal.fauction.managers.commandmanagers.HistoricCommandManager;
import fr.florianpal.fauction.managers.commandmanagers.LimitationManager;
import fr.florianpal.fauction.managers.implementations.LuckPermsImplementation;
import fr.florianpal.fauction.placeholders.FPlaceholderExpansion;
import fr.florianpal.fauction.queries.AuctionQueries;
import fr.florianpal.fauction.queries.CurrencyPendingQueries;
import fr.florianpal.fauction.queries.ExpireQueries;
import fr.florianpal.fauction.queries.HistoricQueries;
import fr.florianpal.fauction.schedules.CacheSchedule;
import fr.florianpal.fauction.schedules.CurrencyScheduler;
import fr.florianpal.fauction.schedules.ExpireSchedule;
import fr.florianpal.fauction.utils.FileUtil;
import io.papermc.lib.PaperLib;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimeZone;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class FAuction
extends JavaPlugin {
    private static FAuction api;
    private static TaskChainFactory taskChainFactory;
    private ConfigurationManager configurationManager;
    private AuctionQueries auctionQueries;
    private ExpireQueries expireQueries;
    private HistoricQueries historicQueries;
    private CurrencyPendingQueries currencyPendingQueries;
    private CommandManager commandManager;
    private VaultIntegrationManager vaultIntegrationManager;
    private DatabaseManager databaseManager;
    private LimitationManager limitationManager;
    private AuctionCommandManager auctionCommandManager;
    private ExpireCommandManager expireCommandManager;
    private HistoricCommandManager historicCommandManager;
    private SpamManager spamManager;
    private TransfertManager transfertManager;
    private Metrics metrics;
    private LuckPermsImplementation luckPermsImplementation;
    private boolean placeholderAPIEnabled = false;

    public static <T> TaskChain<T> newChain() {
        return taskChainFactory.newChain();
    }

    public static TaskChainFactory getTaskChainFactory() {
        return taskChainFactory;
    }

    public void onEnable() {
        this.metrics = new Metrics(this, 24018);
        PaperLib.suggestPaper((Plugin)this);
        taskChainFactory = BukkitTaskChainFactory.create((Plugin)this);
        try {
            this.configurationManager = new ConfigurationManager(this, this.getFile());
            this.configurationManager.reload(this);
        }
        catch (RuntimeException e) {
            this.getLogger().severe(e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        if (this.configurationManager.getGlobalConfig().isLimitationsUseMetaLuckperms()) {
            this.luckPermsImplementation = new LuckPermsImplementation();
        }
        File languageFile = new File(this.getDataFolder(), "lang_" + this.configurationManager.getGlobalConfig().getLang() + ".yml");
        FileUtil.createDefaultConfiguration(this, this.getFile(), languageFile, "lang_" + this.configurationManager.getGlobalConfig().getLang() + ".yml");
        this.commandManager = new CommandManager(this);
        this.commandManager.registerDependency(ConfigurationManager.class, this.configurationManager);
        this.limitationManager = new LimitationManager(this);
        this.vaultIntegrationManager = new VaultIntegrationManager(this);
        try {
            this.databaseManager = new DatabaseManager(this);
        }
        catch (SQLException e) {
            this.getLogger().severe(e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        this.auctionQueries = new AuctionQueries(this);
        this.expireQueries = new ExpireQueries(this);
        this.historicQueries = new HistoricQueries(this);
        this.currencyPendingQueries = new CurrencyPendingQueries(this);
        this.databaseManager.addRepository(this.expireQueries);
        this.databaseManager.addRepository(this.auctionQueries);
        this.databaseManager.addRepository(this.historicQueries);
        this.databaseManager.addRepository(this.currencyPendingQueries);
        this.databaseManager.initializeTables();
        this.auctionCommandManager = new AuctionCommandManager(this);
        this.expireCommandManager = new ExpireCommandManager(this);
        this.historicCommandManager = new HistoricCommandManager(this);
        this.spamManager = new SpamManager(this);
        this.transfertManager = new TransfertManager(this);
        this.commandManager.registerCommand(new AuctionCommand(this));
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new FPlaceholderExpansion(this).register();
            this.placeholderAPIEnabled = true;
        }
        if (this.configurationManager.getGlobalConfig().isFeatureFlippingExpiration()) {
            Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new ExpireSchedule(this), (long)this.configurationManager.getGlobalConfig().getCheckEvery(), (long)this.configurationManager.getGlobalConfig().getCheckEvery());
        }
        if (this.configurationManager.getGlobalConfig().isFeatureFlippingCacheUpdate()) {
            Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new CacheSchedule(this), (long)this.configurationManager.getGlobalConfig().getUpdateCacheEvery(), (long)this.configurationManager.getGlobalConfig().getUpdateCacheEvery());
        }
        Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new CurrencyScheduler(this), (long)this.configurationManager.getGlobalConfig().getCheckEveryCurrency(), (long)this.configurationManager.getGlobalConfig().getCheckEveryCurrency());
        api = this;
        this.initChart();
    }

    public void onDisable() {
        if (this.configurationManager.getDatabase().getSqlType().equals((Object)SQLType.SQLite)) {
            this.auctionCommandManager.deleteAllOnlyOnDB();
            this.auctionCommandManager.saveAllAuctionInBddFromSQLiteCache();
        }
        this.databaseManager.close();
    }

    public static FAuction getApi() {
        return api;
    }

    private void initChart() {
        this.metrics.addCustomChart(new AdvancedPie("player_per_country", () -> {
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            ArrayList onlinePlayers = new ArrayList(Bukkit.getServer().getOnlinePlayers());
            int count = 0;
            for (Player player : onlinePlayers) {
                if (!player.isValid() || !player.isOnline()) continue;
                ++count;
            }
            valueMap.put(TimeZone.getDefault().getID(), count);
            return valueMap;
        }));
    }

    public void reloadConfiguration() {
        this.configurationManager.reload(this);
    }

    public void purgeAllData() {
        this.auctionCommandManager.deleteAll();
        this.expireCommandManager.deleteAll();
        this.historicCommandManager.deleteAll();
    }

    public void purgeAllExpire() {
        this.expireCommandManager.deleteAll();
    }

    public void purgeAllAuction() {
        this.auctionCommandManager.deleteAll();
    }

    public void purgeAllHistoric() {
        this.historicCommandManager.deleteAll();
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public AuctionQueries getAuctionQueries() {
        return this.auctionQueries;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public VaultIntegrationManager getVaultIntegrationManager() {
        return this.vaultIntegrationManager;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public AuctionCommandManager getAuctionCommandManager() {
        return this.auctionCommandManager;
    }

    public LimitationManager getLimitationManager() {
        return this.limitationManager;
    }

    public ExpireQueries getExpireQueries() {
        return this.expireQueries;
    }

    public ExpireCommandManager getExpireCommandManager() {
        return this.expireCommandManager;
    }

    public LuckPermsImplementation getLuckPermsImplementation() {
        return this.luckPermsImplementation;
    }

    public HistoricQueries getHistoricQueries() {
        return this.historicQueries;
    }

    public HistoricCommandManager getHistoricCommandManager() {
        return this.historicCommandManager;
    }

    public SpamManager getSpamManager() {
        return this.spamManager;
    }

    public TransfertManager getTransfertManager() {
        return this.transfertManager;
    }

    public boolean isPlaceholderAPIEnabled() {
        return this.placeholderAPIEnabled;
    }

    public void migrate(String migrateVersion) {
        switch (migrateVersion) {
            case "1.7.8": {
                this.historicQueries.addBuyDate();
            }
        }
    }

    public CurrencyPendingQueries getCurrencyPendingQueries() {
        return this.currencyPendingQueries;
    }
}

