/*
 * Decompiled with CFR 0.152.
 */
package com.sunstrike.vote;

import com.sunstrike.vote.VoteManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VoteCommand
implements CommandExecutor {
    private final VoteManager voteManager;

    public VoteCommand(VoteManager voteManager) {
        this.voteManager = voteManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int vote;
        if (args.length < 2) {
            sender.sendMessage(this.voteManager.getPlugin().getMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"vote_usage")));
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.voteManager.getPlugin().getMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"vote_only_players")));
            return false;
        }
        String voteName = args[0];
        try {
            vote = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.voteManager.getPlugin().getMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"vote_invalid_number")));
            return false;
        }
        Player player = (Player)sender;
        this.voteManager.castVote(voteName, player.getName(), vote);
        sender.sendMessage(this.voteManager.getPlugin().getMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"vote_casted")));
        return true;
    }
}

