/*
 * Decompiled with CFR 0.152.
 */
package com.sunstrike.vote;

import com.sunstrike.vote.VoteManager;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class AdminCommand
implements CommandExecutor {
    private final VoteManager voteManager;

    public AdminCommand(VoteManager voteManager) {
        this.voteManager = voteManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 2 && !label.equalsIgnoreCase("voteReload")) {
            sender.sendMessage(this.voteManager.getPlugin().getMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"admin_usage").replace("<\u043a\u043e\u043c\u0430\u043d\u0434\u0430>", label)));
            return false;
        }
        String action = args[0];
        String voteName = args.length > 1 ? args[1] : "";
        switch (action.toLowerCase()) {
            case "create": {
                this.voteManager.createVote(voteName);
                sender.sendMessage(this.voteManager.getPlugin().getMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"vote_created")));
                break;
            }
            case "remove": {
                this.voteManager.removeVote(voteName);
                sender.sendMessage(this.voteManager.getPlugin().getMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"vote_removed")));
                break;
            }
            case "results": {
                Map<String, Integer> results = this.voteManager.getResults(voteName);
                sender.sendMessage(this.voteManager.getPlugin().getMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"results_header") + voteName + ":"));
                results.forEach((player, vote) -> sender.sendMessage(player + ": " + vote));
                break;
            }
            case "broadcast": {
                Map<String, Integer> broadcastResults = this.voteManager.getResults(voteName);
                sender.getServer().broadcastMessage(this.voteManager.getPlugin().getMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"results_header") + voteName + ":"));
                broadcastResults.forEach((player, vote) -> sender.getServer().broadcastMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(player + ": " + vote))));
                break;
            }
            default: {
                sender.sendMessage(this.voteManager.getPlugin().getMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"unknown_action") + action));
                return false;
            }
        }
        return true;
    }
}

