/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.eztax.service;

import com.skyblockexp.eztax.config.TaxConfig;
import com.skyblockexp.eztax.service.StatsService;
import com.skyblockexp.eztax.service.TaxSink;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TaxEngine {
    private final TaxConfig config;
    private final StatsService statsService;
    private final Economy economy;
    private final Logger logger;

    public TaxEngine(TaxConfig config, StatsService statsService, Economy economy, Logger logger) {
        this.config = config;
        this.statsService = statsService;
        this.economy = economy;
        this.logger = logger;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public void recordTransactionTax(String playerName, double amount) {
        if (amount <= 0.0) {
            return;
        }
        this.statsService.recordTax(TaxSink.TRANSACTION, amount);
        this.debug(String.format(Locale.US, "Transaction tax recorded for %s: %.2f", playerName, amount));
    }

    public void recordTransactionTax(UUID playerId, double amount) {
        this.recordTransactionTax(playerId.toString(), amount);
    }

    public void applyWealthTax(OfflinePlayer player) {
        if (!this.config.isWealthTaxEnabled()) {
            return;
        }
        double balance = this.economy.getBalance(player);
        if (balance <= this.config.getWealthTaxThreshold()) {
            return;
        }
        double taxableAmount = balance - this.config.getWealthTaxThreshold();
        double tax = this.calculateProgressiveTax(taxableAmount, this.config.getWealthTaxBrackets(), this.config.getWealthTaxPercent(), "wealth-tax");
        if (tax <= 0.0) {
            return;
        }
        this.withdrawSafely(player, tax, TaxSink.WEALTH);
    }

    public void applyInactivityFee(OfflinePlayer player) {
        if (!this.config.isInactivityFeeEnabled()) {
            return;
        }
        double balance = this.economy.getBalance(player);
        if (balance <= 0.0) {
            return;
        }
        double fee = this.config.getInactivityPercentage() > 0.0 ? this.roundCurrency(balance * (this.config.getInactivityPercentage() / 100.0)) : this.config.getInactivityFlatFee();
        if (fee <= 0.0) {
            return;
        }
        this.withdrawSafely(player, fee, TaxSink.INACTIVITY);
    }

    public void applyDeathFee(Player player) {
        if (!this.config.isDeathFeeEnabled()) {
            return;
        }
        if (this.config.getDeathFeeDisabledWorlds().contains(player.getWorld().getName())) {
            return;
        }
        double balance = this.economy.getBalance((OfflinePlayer)player);
        if (balance <= 0.0) {
            return;
        }
        double fee = this.roundCurrency(balance * (this.config.getDeathFeePercent() / 100.0));
        if (this.config.getDeathFeeMaxLoss() > 0.0) {
            fee = Math.min(fee, this.config.getDeathFeeMaxLoss());
        }
        if (fee <= 0.0) {
            return;
        }
        this.withdrawSafely((OfflinePlayer)player, fee, TaxSink.DEATH);
    }

    public String format(double amount) {
        return this.economy != null ? this.economy.format(amount) : String.format(Locale.US, "%.2f", amount);
    }

    public double calculateTransactionTax(double withdrawalAmount) {
        double tax = this.calculateProgressiveTax(withdrawalAmount, this.config.getTransactionTaxBrackets(), this.config.getTransactionTaxPercent(), "transaction-tax");
        tax = Math.max(tax, this.config.getTransactionTaxMinimumFee());
        return this.roundCurrency(tax);
    }

    public double calculateProgressiveTax(double amount, List<TaxConfig.TaxBracket> brackets, double flatPercent, String type) {
        if (brackets == null || brackets.isEmpty()) {
            return this.roundCurrency(amount * (flatPercent / 100.0));
        }
        for (int i = 1; i < brackets.size(); ++i) {
            if (brackets.get(i).getThreshold() <= brackets.get(i - 1).getThreshold()) {
                this.sendBracketError("tax-bracket-error-overlap", type);
                return 0.0;
            }
            if (!(brackets.get(i).getRate() < 0.0) && !(brackets.get(i - 1).getRate() < 0.0)) continue;
            this.sendBracketError("tax-bracket-error-invalid", type);
            return 0.0;
        }
        double tax = 0.0;
        double previousThreshold = 0.0;
        for (TaxConfig.TaxBracket bracket : brackets) {
            if (amount > bracket.getThreshold()) {
                double taxable = Math.min(amount, bracket.getThreshold()) - previousThreshold;
                tax += taxable * (bracket.getRate() / 100.0);
                previousThreshold = bracket.getThreshold();
                continue;
            }
            tax += (amount - previousThreshold) * (bracket.getRate() / 100.0);
            break;
        }
        if (tax < 0.0) {
            this.sendBracketError("tax-bracket-error-invalid", type);
            return 0.0;
        }
        return this.roundCurrency(tax);
    }

    private void sendBracketError(String key, String type) {
        String msg = this.getMessage(key).replace("{type}", type);
        this.logger.warning(msg);
    }

    private String getMessage(String key) {
        FileConfiguration messages;
        JavaPlugin plugin;
        JavaPlugin javaPlugin = plugin = this.config.getClass().getPackage().getName().startsWith("com.skyblockexp.eztax") ? this.config.getPlugin() : null;
        if (plugin != null && (messages = plugin.getConfig()).contains(key)) {
            return messages.getString(key);
        }
        return key;
    }

    private void withdrawSafely(OfflinePlayer player, double amount, TaxSink sink) {
        double balance = this.economy.getBalance(player);
        if (amount > balance) {
            this.debug(String.format(Locale.US, "%s tax skipped for %s (insufficient balance).", sink.name(), player.getUniqueId()));
            return;
        }
        EconomyResponse response = this.economy.withdrawPlayer(player, amount);
        if (!response.transactionSuccess()) {
            this.debug(String.format(Locale.US, "%s tax failed for %s (%s).", sink.name(), player.getUniqueId(), response.errorMessage));
            return;
        }
        this.statsService.recordTax(sink, amount);
        this.debug(String.format(Locale.US, "%s tax applied to %s: %.2f", sink.name(), player.getUniqueId(), amount));
    }

    private double roundCurrency(double amount) {
        return BigDecimal.valueOf(amount).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    private void debug(String message) {
        if (this.config.isDebug()) {
            this.logger.fine(message);
        }
    }
}

