/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.eztax.service;

import com.skyblockexp.eztax.config.TaxConfig;
import com.skyblockexp.eztax.service.TaxSink;
import java.io.File;
import java.io.IOException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class StatsService {
    private final JavaPlugin plugin;
    private final TaxConfig config;
    private final File statsFile;
    private final Map<TaxSink, Double> sinkTotals = new EnumMap<TaxSink, Double>(TaxSink.class);
    private double totalRemoved;
    private double dailyRemoved;
    private double weeklyRemoved;
    private double treasuryBalance;
    private LocalDate dailyResetDate;
    private LocalDate weeklyResetDate;

    public StatsService(JavaPlugin plugin, TaxConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.statsFile = new File(plugin.getDataFolder(), "stats.yml");
        this.load();
    }

    public void reload() {
        this.load();
    }

    public synchronized void recordTax(TaxSink sink, double amount) {
        this.recordTax(sink, amount, this.config.isTreasuryEnabled());
    }

    public synchronized void recordTax(TaxSink sink, double amount, boolean addToTreasury) {
        if (amount <= 0.0) {
            return;
        }
        this.ensureResets();
        this.totalRemoved += amount;
        this.dailyRemoved += amount;
        this.weeklyRemoved += amount;
        this.sinkTotals.put(sink, this.sinkTotals.getOrDefault((Object)sink, 0.0) + amount);
        if (addToTreasury) {
            this.treasuryBalance += amount;
        }
        this.save();
    }

    public synchronized double getTotalRemoved() {
        return this.totalRemoved;
    }

    public synchronized double getDailyRemoved() {
        this.ensureResets();
        return this.dailyRemoved;
    }

    public synchronized double getWeeklyRemoved() {
        this.ensureResets();
        return this.weeklyRemoved;
    }

    public synchronized double getTreasuryBalance() {
        return this.treasuryBalance;
    }

    public synchronized Map<TaxSink, Double> getSinkTotals() {
        return new EnumMap<TaxSink, Double>(this.sinkTotals);
    }

    public synchronized void save() {
        YamlConfiguration config = new YamlConfiguration();
        config.set("totals.overall", (Object)this.totalRemoved);
        config.set("totals.daily", (Object)this.dailyRemoved);
        config.set("totals.weekly", (Object)this.weeklyRemoved);
        config.set("totals.treasury", (Object)this.treasuryBalance);
        for (Map.Entry<TaxSink, Double> entry : this.sinkTotals.entrySet()) {
            config.set("totals.sinks." + entry.getKey().name(), (Object)entry.getValue());
        }
        config.set("resets.daily", this.dailyResetDate != null ? this.dailyResetDate.toString() : null);
        config.set("resets.weekly", this.weeklyResetDate != null ? this.weeklyResetDate.toString() : null);
        try {
            config.save(this.statsFile);
        }
        catch (IOException exception) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to save EzTax stats file.", exception);
        }
    }

    private void load() {
        if (!this.statsFile.exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.statsFile);
        this.totalRemoved = config.getDouble("totals.overall", 0.0);
        this.dailyRemoved = config.getDouble("totals.daily", 0.0);
        this.weeklyRemoved = config.getDouble("totals.weekly", 0.0);
        this.treasuryBalance = config.getDouble("totals.treasury", 0.0);
        this.sinkTotals.clear();
        for (TaxSink sink : TaxSink.values()) {
            this.sinkTotals.put(sink, config.getDouble("totals.sinks." + sink.name(), 0.0));
        }
        this.dailyResetDate = this.parseDate(config.getString("resets.daily"));
        this.weeklyResetDate = this.parseDate(config.getString("resets.weekly"));
        this.ensureResets();
        this.save();
    }

    private LocalDate parseDate(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return LocalDate.parse(value);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private void ensureResets() {
        LocalDate today = LocalDate.now(ZoneId.systemDefault());
        if (this.dailyResetDate == null || !this.dailyResetDate.equals(today)) {
            this.dailyResetDate = today;
            this.dailyRemoved = 0.0;
        }
        LocalDate weekStart = today.with(DayOfWeek.MONDAY);
        if (this.weeklyResetDate == null || !this.weeklyResetDate.equals(weekStart)) {
            this.weeklyResetDate = weekStart;
            this.weeklyRemoved = 0.0;
        }
    }
}

