/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.eztax.service;

import com.skyblockexp.eztax.config.TaxConfig;
import com.skyblockexp.eztax.config.TaxInterval;
import com.skyblockexp.eztax.service.TaxEngine;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SchedulerService {
    private final JavaPlugin plugin;
    private final TaxConfig config;
    private final TaxEngine taxEngine;
    private int wealthTaskId = -1;
    private int inactivityTaskId = -1;

    public SchedulerService(JavaPlugin plugin, TaxConfig config, TaxEngine taxEngine) {
        this.plugin = plugin;
        this.config = config;
        this.taxEngine = taxEngine;
    }

    public void start() {
        this.scheduleWealthTax();
        this.scheduleInactivityFee();
    }

    public void stop() {
        this.cancelTask(this.wealthTaskId);
        this.cancelTask(this.inactivityTaskId);
    }

    public void reload() {
        this.stop();
        this.start();
    }

    private void scheduleWealthTax() {
        if (!this.config.isWealthTaxEnabled()) {
            return;
        }
        TaxInterval interval = this.config.getWealthTaxInterval();
        this.wealthTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.runWealthTaxAsync();
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.WARNING, "Wealth tax run failed; skipping this cycle.", ex);
            }
        }, interval.getTicks(), interval.getTicks()).getTaskId();
    }

    private void scheduleInactivityFee() {
        if (!this.config.isInactivityFeeEnabled()) {
            return;
        }
        long dailyTicks = TaxInterval.DAILY.getTicks();
        this.inactivityTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.runInactivityFeeAsync();
            }
            catch (Exception ex) {
                this.plugin.getLogger().log(Level.WARNING, "Inactivity fee run failed; skipping this cycle.", ex);
            }
        }, dailyTicks, dailyTicks).getTaskId();
    }

    private void runWealthTaxAsync() {
        List<OfflinePlayer> players = Arrays.asList(Bukkit.getOfflinePlayers());
        for (OfflinePlayer player : players) {
            if (player == null || !player.hasPlayedBefore()) continue;
            UUID uuid = player.getUniqueId();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                OfflinePlayer syncPlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                this.taxEngine.applyWealthTax(syncPlayer);
            });
        }
    }

    private void runInactivityFeeAsync() {
        List<OfflinePlayer> players = Arrays.asList(Bukkit.getOfflinePlayers());
        int inactiveDays = this.config.getInactivityDays();
        Instant now = Instant.now();
        for (OfflinePlayer player : players) {
            long days;
            long lastPlayed;
            if (player == null || !player.hasPlayedBefore() || (lastPlayed = player.getLastPlayed()) <= 0L || (days = Duration.between(Instant.ofEpochMilli(lastPlayed), now).toDays()) < (long)inactiveDays) continue;
            UUID uuid = player.getUniqueId();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                OfflinePlayer syncPlayer = Bukkit.getOfflinePlayer((UUID)uuid);
                this.taxEngine.applyInactivityFee(syncPlayer);
            });
        }
    }

    private void cancelTask(int taskId) {
        if (taskId != -1) {
            Bukkit.getScheduler().cancelTask(taskId);
        }
    }
}

