/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.eztax.economy;

import com.skyblockexp.eztax.config.TaxConfig;
import com.skyblockexp.eztax.economy.TaxedEconomy;
import com.skyblockexp.eztax.service.TaxEngine;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class VaultHook {
    private final JavaPlugin plugin;
    private Economy economy;
    private TaxedEconomy taxedEconomy;
    private boolean registered;

    public VaultHook(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean hook() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.plugin.getLogger().warning("Vault plugin not found. EzTax will not apply taxes.");
            return false;
        }
        RegisteredServiceProvider registration = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (registration == null || registration.getProvider() == null) {
            this.plugin.getLogger().warning("No Vault economy provider found. EzTax will not apply taxes.");
            return false;
        }
        this.economy = (Economy)registration.getProvider();
        this.plugin.getLogger().info("Using Vault economy provider: " + this.economy.getName());
        return true;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public void registerTaxedEconomy(TaxEngine taxEngine, TaxConfig config) {
        if (this.economy == null || this.registered) {
            return;
        }
        this.taxedEconomy = new TaxedEconomy(this.economy, taxEngine, config, this.plugin.getLogger());
        this.plugin.getServer().getServicesManager().register(Economy.class, (Object)this.taxedEconomy, (Plugin)this.plugin, ServicePriority.Highest);
        this.registered = true;
        this.plugin.getLogger().info("EzTax registered a Vault economy wrapper for transaction taxes.");
    }

    public void unregisterTaxedEconomy() {
        if (!this.registered || this.taxedEconomy == null) {
            return;
        }
        this.plugin.getServer().getServicesManager().unregister(Economy.class, (Object)this.taxedEconomy);
        this.registered = false;
        this.plugin.getLogger().info("EzTax unregistered its Vault economy wrapper.");
    }
}

