/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.eztax.config;

public enum TaxInterval {
    HOURLY(72000L),
    DAILY(1728000L),
    WEEKLY(12096000L);

    private final long ticks;

    private TaxInterval(long ticks) {
        this.ticks = ticks;
    }

    public long getTicks() {
        return this.ticks;
    }

    public static TaxInterval fromString(String value) {
        if (value == null) {
            return DAILY;
        }
        for (TaxInterval interval : TaxInterval.values()) {
            if (!interval.name().equalsIgnoreCase(value)) continue;
            return interval;
        }
        return DAILY;
    }
}

