/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.eztax;

import com.skyblockexp.eztax.command.EzTaxCommand;
import com.skyblockexp.eztax.config.Messages;
import com.skyblockexp.eztax.config.TaxConfig;
import com.skyblockexp.eztax.economy.VaultHook;
import com.skyblockexp.eztax.libs.org.bstats.bukkit.Metrics;
import com.skyblockexp.eztax.listener.DeathFeeListener;
import com.skyblockexp.eztax.service.SchedulerService;
import com.skyblockexp.eztax.service.StatsService;
import com.skyblockexp.eztax.service.TaxEngine;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EzTaxPlugin
extends JavaPlugin {
    private TaxConfig taxConfig;
    private StatsService statsService;
    private VaultHook vaultHook;
    private TaxEngine taxEngine;
    private SchedulerService schedulerService;
    private Messages messages;

    public void onEnable() {
        this.saveDefaultConfig();
        this.taxConfig = new TaxConfig(this);
        this.statsService = new StatsService(this, this.taxConfig);
        this.vaultHook = new VaultHook(this);
        this.messages = new Messages(this);
        if (this.vaultHook.hook()) {
            this.taxEngine = new TaxEngine(this.taxConfig, this.statsService, this.vaultHook.getEconomy(), this.getLogger());
            this.vaultHook.registerTaxedEconomy(this.taxEngine, this.taxConfig);
            this.registerListeners();
            this.schedulerService = new SchedulerService(this, this.taxConfig, this.taxEngine);
            this.schedulerService.start();
        } else {
            this.getLogger().warning("Vault economy was not detected. EzTax will run in standby mode.");
        }
        new Metrics(this, 28537);
        this.registerCommands();
    }

    public void onDisable() {
        if (this.schedulerService != null) {
            this.schedulerService.stop();
        }
        if (this.vaultHook != null) {
            this.vaultHook.unregisterTaxedEconomy();
        }
        if (this.statsService != null) {
            this.statsService.save();
        }
    }

    public void reloadEzTax() {
        this.reloadConfig();
        this.taxConfig.reload();
        this.statsService.reload();
        this.messages.reload();
        if (this.taxEngine == null && this.vaultHook.hook()) {
            this.taxEngine = new TaxEngine(this.taxConfig, this.statsService, this.vaultHook.getEconomy(), this.getLogger());
            this.vaultHook.registerTaxedEconomy(this.taxEngine, this.taxConfig);
            this.registerListeners();
            this.schedulerService = new SchedulerService(this, this.taxConfig, this.taxEngine);
            this.schedulerService.start();
            return;
        }
        if (this.schedulerService != null) {
            this.schedulerService.reload();
        }
    }

    private void registerListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)new DeathFeeListener(this.taxConfig, this.taxEngine), (Plugin)this);
    }

    private void registerCommands() {
        PluginCommand alias;
        EzTaxCommand executor = new EzTaxCommand(this, this.taxConfig, this.statsService, this.taxEngine, this.vaultHook, this.messages);
        PluginCommand command = this.getCommand("eztax");
        if (command != null) {
            command.setExecutor((CommandExecutor)executor);
            command.setTabCompleter((TabCompleter)executor);
        }
        if ((alias = this.getCommand("tax")) != null) {
            alias.setExecutor((CommandExecutor)executor);
            alias.setTabCompleter((TabCompleter)executor);
        }
    }
}

