/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.eztax.config;

import java.io.File;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class Messages {
    private final JavaPlugin plugin;
    private FileConfiguration configuration;
    private String prefix;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();

    public Messages(JavaPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        File file = new File(plugin.getDataFolder(), "messages.yml");
        if (!file.exists()) {
            plugin.saveResource("messages.yml", false);
        }
        this.reload();
    }

    public void reload() {
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
        this.prefix = this.configuration.getString("prefix", "");
    }

    public Component message(String key, TagResolver ... resolvers) {
        String raw = this.configuration.getString(key, "");
        if (raw.contains("<")) {
            try {
                return this.miniMessage.deserialize(this.prefix + raw, resolvers);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.legacySerializer.deserialize(this.prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)raw));
    }

    public Component plain(String key, TagResolver ... resolvers) {
        String raw = this.configuration.getString(key, "");
        if (raw.contains("<")) {
            try {
                return this.miniMessage.deserialize(raw, resolvers);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.legacySerializer.deserialize(ChatColor.translateAlternateColorCodes((char)'&', (String)raw));
    }
}

