/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.eztax.service;

import com.skyblockexp.eztax.config.TaxConfig;
import com.skyblockexp.eztax.service.StatsService;
import com.skyblockexp.eztax.service.TaxSink;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class TaxEngine {
    private final TaxConfig config;
    private final StatsService statsService;
    private final Economy economy;
    private final Logger logger;

    public TaxEngine(TaxConfig config, StatsService statsService, Economy economy, Logger logger) {
        this.config = config;
        this.statsService = statsService;
        this.economy = economy;
        this.logger = logger;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public void recordTransactionTax(String playerName, double amount) {
        if (amount <= 0.0) {
            return;
        }
        this.statsService.recordTax(TaxSink.TRANSACTION, amount);
        this.debug(String.format(Locale.US, "Transaction tax recorded for %s: %.2f", playerName, amount));
    }

    public void recordTransactionTax(UUID playerId, double amount) {
        this.recordTransactionTax(playerId.toString(), amount);
    }

    public void applyWealthTax(OfflinePlayer player) {
        if (!this.config.isWealthTaxEnabled()) {
            return;
        }
        double balance = this.economy.getBalance(player);
        if (balance <= this.config.getWealthTaxThreshold()) {
            return;
        }
        double taxableAmount = balance - this.config.getWealthTaxThreshold();
        double tax = this.roundCurrency(taxableAmount * (this.config.getWealthTaxPercent() / 100.0));
        if (tax <= 0.0) {
            return;
        }
        this.withdrawSafely(player, tax, TaxSink.WEALTH);
    }

    public void applyInactivityFee(OfflinePlayer player) {
        if (!this.config.isInactivityFeeEnabled()) {
            return;
        }
        double balance = this.economy.getBalance(player);
        if (balance <= 0.0) {
            return;
        }
        double fee = this.config.getInactivityPercentage() > 0.0 ? this.roundCurrency(balance * (this.config.getInactivityPercentage() / 100.0)) : this.config.getInactivityFlatFee();
        if (fee <= 0.0) {
            return;
        }
        this.withdrawSafely(player, fee, TaxSink.INACTIVITY);
    }

    public void applyDeathFee(Player player) {
        if (!this.config.isDeathFeeEnabled()) {
            return;
        }
        if (this.config.getDeathFeeDisabledWorlds().contains(player.getWorld().getName())) {
            return;
        }
        double balance = this.economy.getBalance((OfflinePlayer)player);
        if (balance <= 0.0) {
            return;
        }
        double fee = this.roundCurrency(balance * (this.config.getDeathFeePercent() / 100.0));
        if (this.config.getDeathFeeMaxLoss() > 0.0) {
            fee = Math.min(fee, this.config.getDeathFeeMaxLoss());
        }
        if (fee <= 0.0) {
            return;
        }
        this.withdrawSafely((OfflinePlayer)player, fee, TaxSink.DEATH);
    }

    public String format(double amount) {
        return this.economy != null ? this.economy.format(amount) : String.format(Locale.US, "%.2f", amount);
    }

    public double calculateTransactionTax(double withdrawalAmount) {
        double percentFee = withdrawalAmount * (this.config.getTransactionTaxPercent() / 100.0);
        double tax = Math.max(percentFee, this.config.getTransactionTaxMinimumFee());
        return this.roundCurrency(tax);
    }

    private void withdrawSafely(OfflinePlayer player, double amount, TaxSink sink) {
        double balance = this.economy.getBalance(player);
        if (amount > balance) {
            this.debug(String.format(Locale.US, "%s tax skipped for %s (insufficient balance).", sink.name(), player.getUniqueId()));
            return;
        }
        EconomyResponse response = this.economy.withdrawPlayer(player, amount);
        if (!response.transactionSuccess()) {
            this.debug(String.format(Locale.US, "%s tax failed for %s (%s).", sink.name(), player.getUniqueId(), response.errorMessage));
            return;
        }
        this.statsService.recordTax(sink, amount);
        this.debug(String.format(Locale.US, "%s tax applied to %s: %.2f", sink.name(), player.getUniqueId(), amount));
    }

    private double roundCurrency(double amount) {
        return BigDecimal.valueOf(amount).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    private void debug(String message) {
        if (this.config.isDebug()) {
            this.logger.fine(message);
        }
    }
}

