/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.eztax.economy;

import com.skyblockexp.eztax.config.TaxConfig;
import com.skyblockexp.eztax.service.TaxEngine;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;

public class TaxedEconomy
implements Economy {
    private final Economy delegate;
    private final TaxEngine taxEngine;
    private final TaxConfig config;
    private final Logger logger;

    public TaxedEconomy(Economy delegate, TaxEngine taxEngine, TaxConfig config, Logger logger) {
        this.delegate = delegate;
        this.taxEngine = taxEngine;
        this.config = config;
        this.logger = logger;
    }

    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public boolean hasBankSupport() {
        return this.delegate.hasBankSupport();
    }

    public int fractionalDigits() {
        return this.delegate.fractionalDigits();
    }

    public String format(double amount) {
        return this.delegate.format(amount);
    }

    public String currencyNamePlural() {
        return this.delegate.currencyNamePlural();
    }

    public String currencyNameSingular() {
        return this.delegate.currencyNameSingular();
    }

    public boolean hasAccount(String playerName) {
        return this.delegate.hasAccount(playerName);
    }

    public boolean hasAccount(OfflinePlayer player) {
        return this.delegate.hasAccount(player);
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.delegate.hasAccount(playerName, worldName);
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.delegate.hasAccount(player, worldName);
    }

    public double getBalance(String playerName) {
        return this.delegate.getBalance(playerName);
    }

    public double getBalance(OfflinePlayer player) {
        return this.delegate.getBalance(player);
    }

    public double getBalance(String playerName, String world) {
        return this.delegate.getBalance(playerName, world);
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.delegate.getBalance(player, world);
    }

    public boolean has(String playerName, double amount) {
        return this.delegate.has(playerName, amount);
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.delegate.has(player, amount);
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.delegate.has(playerName, worldName, amount);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.delegate.has(player, worldName, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        return this.withdrawWithTax(playerName, null, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        return this.withdrawWithTax(player, null, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawWithTax(playerName, worldName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawWithTax(player, worldName, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        return this.delegate.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        return this.delegate.depositPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.delegate.depositPlayer(playerName, worldName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.delegate.depositPlayer(player, worldName, amount);
    }

    public EconomyResponse createBank(String name, String player) {
        return this.delegate.createBank(name, player);
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return this.delegate.createBank(name, player);
    }

    public EconomyResponse deleteBank(String name) {
        return this.delegate.deleteBank(name);
    }

    public EconomyResponse bankBalance(String name) {
        return this.delegate.bankBalance(name);
    }

    public EconomyResponse bankHas(String name, double amount) {
        return this.delegate.bankHas(name, amount);
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return this.delegate.bankWithdraw(name, amount);
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return this.delegate.bankDeposit(name, amount);
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return this.delegate.isBankOwner(name, playerName);
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return this.delegate.isBankOwner(name, player);
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return this.delegate.isBankMember(name, playerName);
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return this.delegate.isBankMember(name, player);
    }

    public List<String> getBanks() {
        return this.delegate.getBanks();
    }

    public boolean createPlayerAccount(String playerName) {
        return this.delegate.createPlayerAccount(playerName);
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        return this.delegate.createPlayerAccount(player);
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.delegate.createPlayerAccount(playerName, worldName);
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return this.delegate.createPlayerAccount(player, worldName);
    }

    private EconomyResponse withdrawWithTax(String playerName, String worldName, double amount) {
        EconomyResponse response;
        double balance;
        if (amount <= 0.0) {
            return worldName == null ? this.delegate.withdrawPlayer(playerName, amount) : this.delegate.withdrawPlayer(playerName, worldName, amount);
        }
        if (!this.config.isTransactionTaxEnabled()) {
            return worldName == null ? this.delegate.withdrawPlayer(playerName, amount) : this.delegate.withdrawPlayer(playerName, worldName, amount);
        }
        double tax = this.taxEngine.calculateTransactionTax(amount);
        if (tax <= 0.0) {
            return worldName == null ? this.delegate.withdrawPlayer(playerName, amount) : this.delegate.withdrawPlayer(playerName, worldName, amount);
        }
        double total = amount + tax;
        double d = balance = worldName == null ? this.delegate.getBalance(playerName) : this.delegate.getBalance(playerName, worldName);
        if (balance < total) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds for tax.");
        }
        EconomyResponse economyResponse = response = worldName == null ? this.delegate.withdrawPlayer(playerName, total) : this.delegate.withdrawPlayer(playerName, worldName, total);
        if (response.transactionSuccess()) {
            this.taxEngine.recordTransactionTax(playerName, tax);
            this.debug(playerName, amount, tax);
            return new EconomyResponse(amount, response.balance, EconomyResponse.ResponseType.SUCCESS, response.errorMessage);
        }
        return response;
    }

    private EconomyResponse withdrawWithTax(OfflinePlayer player, String worldName, double amount) {
        EconomyResponse response;
        double balance;
        if (amount <= 0.0) {
            return worldName == null ? this.delegate.withdrawPlayer(player, amount) : this.delegate.withdrawPlayer(player, worldName, amount);
        }
        if (!this.config.isTransactionTaxEnabled()) {
            return worldName == null ? this.delegate.withdrawPlayer(player, amount) : this.delegate.withdrawPlayer(player, worldName, amount);
        }
        double tax = this.taxEngine.calculateTransactionTax(amount);
        if (tax <= 0.0) {
            return worldName == null ? this.delegate.withdrawPlayer(player, amount) : this.delegate.withdrawPlayer(player, worldName, amount);
        }
        double total = amount + tax;
        double d = balance = worldName == null ? this.delegate.getBalance(player) : this.delegate.getBalance(player, worldName);
        if (balance < total) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds for tax.");
        }
        EconomyResponse economyResponse = response = worldName == null ? this.delegate.withdrawPlayer(player, total) : this.delegate.withdrawPlayer(player, worldName, total);
        if (response.transactionSuccess()) {
            UUID uuid = player.getUniqueId();
            this.taxEngine.recordTransactionTax(uuid, tax);
            this.debug(player.getName(), amount, tax);
            return new EconomyResponse(amount, response.balance, EconomyResponse.ResponseType.SUCCESS, response.errorMessage);
        }
        return response;
    }

    private void debug(String playerName, double amount, double tax) {
        if (this.config.isDebug()) {
            this.logger.fine(String.format(Locale.US, "Transaction tax applied to %s: amount=%.2f tax=%.2f", playerName, amount, tax));
        }
    }
}

