/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.eztax.config;

import com.skyblockexp.eztax.config.TaxInterval;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class TaxConfig {
    private final JavaPlugin plugin;
    private boolean debug;
    private boolean transactionTaxEnabled;
    private double transactionTaxPercent;
    private double transactionTaxMinimumFee;
    private boolean wealthTaxEnabled;
    private double wealthTaxThreshold;
    private double wealthTaxPercent;
    private TaxInterval wealthTaxInterval;
    private boolean inactivityFeeEnabled;
    private int inactivityDays;
    private double inactivityFlatFee;
    private double inactivityPercentage;
    private boolean deathFeeEnabled;
    private double deathFeePercent;
    private double deathFeeMaxLoss;
    private List<String> deathFeeDisabledWorlds;
    private boolean treasuryEnabled;

    public TaxConfig(JavaPlugin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        FileConfiguration config = this.plugin.getConfig();
        this.debug = config.getBoolean("debug", false);
        this.transactionTaxEnabled = config.getBoolean("transaction-tax.enabled", true);
        this.transactionTaxPercent = config.getDouble("transaction-tax.percentage", 0.0);
        this.transactionTaxMinimumFee = config.getDouble("transaction-tax.minimum-fee", 0.0);
        this.wealthTaxEnabled = config.getBoolean("wealth-tax.enabled", false);
        this.wealthTaxThreshold = config.getDouble("wealth-tax.threshold", 0.0);
        this.wealthTaxPercent = config.getDouble("wealth-tax.percentage", 0.0);
        this.wealthTaxInterval = TaxInterval.fromString(config.getString("wealth-tax.interval", "DAILY"));
        this.inactivityFeeEnabled = config.getBoolean("inactivity-fee.enabled", false);
        this.inactivityDays = config.getInt("inactivity-fee.days-inactive", 30);
        this.inactivityFlatFee = config.getDouble("inactivity-fee.flat-fee", 0.0);
        this.inactivityPercentage = config.getDouble("inactivity-fee.percentage", 0.0);
        this.deathFeeEnabled = config.getBoolean("death-fee.enabled", false);
        this.deathFeePercent = config.getDouble("death-fee.percentage", 0.0);
        this.deathFeeMaxLoss = config.getDouble("death-fee.max-loss", 0.0);
        this.deathFeeDisabledWorlds = config.getStringList("death-fee.disabled-worlds");
        if (this.deathFeeDisabledWorlds == null) {
            this.deathFeeDisabledWorlds = Collections.emptyList();
        }
        this.treasuryEnabled = config.getBoolean("server-treasury.enabled", true);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isTransactionTaxEnabled() {
        return this.transactionTaxEnabled;
    }

    public double getTransactionTaxPercent() {
        return this.transactionTaxPercent;
    }

    public double getTransactionTaxMinimumFee() {
        return this.transactionTaxMinimumFee;
    }

    public boolean isWealthTaxEnabled() {
        return this.wealthTaxEnabled;
    }

    public double getWealthTaxThreshold() {
        return this.wealthTaxThreshold;
    }

    public double getWealthTaxPercent() {
        return this.wealthTaxPercent;
    }

    public TaxInterval getWealthTaxInterval() {
        return this.wealthTaxInterval;
    }

    public boolean isInactivityFeeEnabled() {
        return this.inactivityFeeEnabled;
    }

    public int getInactivityDays() {
        return this.inactivityDays;
    }

    public double getInactivityFlatFee() {
        return this.inactivityFlatFee;
    }

    public double getInactivityPercentage() {
        return this.inactivityPercentage;
    }

    public boolean isDeathFeeEnabled() {
        return this.deathFeeEnabled;
    }

    public double getDeathFeePercent() {
        return this.deathFeePercent;
    }

    public double getDeathFeeMaxLoss() {
        return this.deathFeeMaxLoss;
    }

    public List<String> getDeathFeeDisabledWorlds() {
        return this.deathFeeDisabledWorlds;
    }

    public boolean isTreasuryEnabled() {
        return this.treasuryEnabled;
    }
}

