/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.eztax.command;

import com.skyblockexp.eztax.EzTaxPlugin;
import com.skyblockexp.eztax.MessageManager;
import com.skyblockexp.eztax.config.Messages;
import com.skyblockexp.eztax.config.TaxConfig;
import com.skyblockexp.eztax.economy.VaultHook;
import com.skyblockexp.eztax.service.StatsService;
import com.skyblockexp.eztax.service.TaxEngine;
import com.skyblockexp.eztax.service.TaxSink;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class EzTaxCommand
implements CommandExecutor,
TabCompleter {
    private final EzTaxPlugin plugin;
    private final TaxConfig config;
    private final StatsService statsService;
    private final TaxEngine taxEngine;
    private final VaultHook vaultHook;
    private final Messages messages;
    private final MessageManager messageManager;

    public EzTaxCommand(EzTaxPlugin plugin, TaxConfig config, StatsService statsService, TaxEngine taxEngine, VaultHook vaultHook, Messages messages) {
        this.plugin = plugin;
        this.config = config;
        this.statsService = statsService;
        this.taxEngine = taxEngine;
        this.vaultHook = vaultHook;
        this.messages = messages;
        this.messageManager = new MessageManager((Plugin)plugin, messages);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (sub = args[0].toLowerCase(Locale.US)) {
            case "runwealthtax": {
                if (!sender.hasPermission("eztax.admin")) {
                    this.messageManager.send(sender, "no-permission", new TagResolver[0]);
                    return true;
                }
                this.messageManager.send(sender, "reloaded", Placeholder.parsed("reason", "Running wealth tax for all players..."));
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    int count = 0;
                    for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                        if (player == null || !player.hasPlayedBefore()) continue;
                        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.taxEngine.applyWealthTax(player));
                        ++count;
                    }
                    if (count == 0) {
                        this.messageManager.send(sender, "no-players", new TagResolver[0]);
                    } else {
                        this.messageManager.send(sender, "wealth-tax-manual", Placeholder.parsed("count", String.valueOf(count)));
                    }
                });
                return true;
            }
            case "stats": {
                if (!sender.hasPermission("eztax.stats")) {
                    this.messageManager.send(sender, "no-permission", new TagResolver[0]);
                    return true;
                }
                this.sendStats(sender);
                return true;
            }
            case "sinks": {
                if (!sender.hasPermission("eztax.stats")) {
                    this.messageManager.send(sender, "no-permission", new TagResolver[0]);
                    return true;
                }
                this.sendSinks(sender);
                return true;
            }
            case "reload": {
                if (!sender.hasPermission("eztax.admin")) {
                    this.messageManager.send(sender, "no-permission", new TagResolver[0]);
                    return true;
                }
                this.plugin.reloadEzTax();
                this.messageManager.send(sender, "reloaded", new TagResolver[0]);
                if (this.vaultHook.getEconomy() == null) {
                    this.messageManager.send(sender, "no-economy", new TagResolver[0]);
                }
                return true;
            }
        }
        this.sendHelp(sender);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("stats");
            completions.add("sinks");
            completions.add("reload");
        }
        return completions;
    }

    private void sendHelp(CommandSender sender) {
        this.messageManager.send(sender, "stats-header", new TagResolver[0]);
        this.messageManager.send(sender, "stats-line", Placeholder.parsed("type", "stats"), Placeholder.parsed("amount", "/eztax stats - View tax totals"));
        this.messageManager.send(sender, "sinks-header", new TagResolver[0]);
        this.messageManager.send(sender, "sinks-line", Placeholder.parsed("type", "sinks"), Placeholder.parsed("amount", "/eztax sinks - View tax breakdowns"));
        this.messageManager.send(sender, "reloaded", Placeholder.parsed("reason", "/eztax reload - Reload configuration"));
    }

    private void sendStats(CommandSender sender) {
        this.messageManager.send(sender, "stats-header", new TagResolver[0]);
        this.messageManager.send(sender, "stats-line", Placeholder.parsed("type", "Total removed"), Placeholder.parsed("amount", this.format(this.statsService.getTotalRemoved())));
        this.messageManager.send(sender, "stats-line", Placeholder.parsed("type", "Daily removed"), Placeholder.parsed("amount", this.format(this.statsService.getDailyRemoved())));
        this.messageManager.send(sender, "stats-line", Placeholder.parsed("type", "Weekly removed"), Placeholder.parsed("amount", this.format(this.statsService.getWeeklyRemoved())));
        if (this.config.isTreasuryEnabled()) {
            this.messageManager.send(sender, "stats-line", Placeholder.parsed("type", "Treasury balance"), Placeholder.parsed("amount", this.format(this.statsService.getTreasuryBalance())));
        }
    }

    private void sendSinks(CommandSender sender) {
        this.messageManager.send(sender, "sinks-header", new TagResolver[0]);
        for (Map.Entry<TaxSink, Double> entry : this.statsService.getSinkTotals().entrySet()) {
            this.messageManager.send(sender, "sinks-line", Placeholder.parsed("type", this.formatSink(entry.getKey())), Placeholder.parsed("amount", this.format(entry.getValue())));
        }
    }

    private String format(double amount) {
        return this.taxEngine != null ? this.taxEngine.format(amount) : String.format(Locale.US, "%.2f", amount);
    }

    private String formatSink(TaxSink sink) {
        switch (sink) {
            case TRANSACTION: {
                return "Transaction";
            }
            case WEALTH: {
                return "Wealth";
            }
            case INACTIVITY: {
                return "Inactivity";
            }
            case DEATH: {
                return "Death";
            }
        }
        return sink.name();
    }
}

