/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.teleport;

import com.skyblockexp.ezrtp.config.CountdownBossBarSettings;
import com.skyblockexp.ezrtp.config.CountdownParticleSettings;
import com.skyblockexp.ezrtp.config.ParticleSettings;
import com.skyblockexp.ezrtp.config.RandomTeleportSettings;
import com.skyblockexp.ezrtp.config.TeleportQueueSettings;
import com.skyblockexp.ezrtp.economy.EconomyService;
import com.skyblockexp.ezrtp.protection.ProtectionRegistry;
import com.skyblockexp.ezrtp.teleport.TeleportReason;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

public final class RandomTeleportService {
    private final Random random = new Random();
    private final BukkitScheduler scheduler;
    private final JavaPlugin plugin;
    private final Deque<QueuedTeleport> teleportQueue = new ArrayDeque<QueuedTeleport>();
    private final Map<UUID, BossBar> countdownBossBars = new HashMap<UUID, BossBar>();
    private static final int NETHER_ROOF_Y = 127;
    private RandomTeleportSettings settings;
    private TeleportQueueSettings queueSettings;
    private boolean queueProcessing;
    private UUID activeTeleportPlayer;
    private EconomyService economyService;
    private BiFunction<Player, RandomTeleportSettings, Double> costResolver;
    private ProtectionRegistry protectionRegistry;

    public RandomTeleportService(JavaPlugin plugin, RandomTeleportSettings settings, TeleportQueueSettings queueSettings, EconomyService economyService, BiFunction<Player, RandomTeleportSettings, Double> costResolver, ProtectionRegistry protectionRegistry) {
        this.plugin = plugin;
        this.scheduler = plugin.getServer().getScheduler();
        this.settings = settings;
        this.queueSettings = queueSettings != null ? queueSettings : TeleportQueueSettings.disabled();
        this.economyService = economyService != null ? economyService : EconomyService.disabled();
        this.costResolver = costResolver;
        this.protectionRegistry = protectionRegistry;
    }

    public void reload(RandomTeleportSettings newSettings, TeleportQueueSettings newQueueSettings) {
        this.settings = newSettings;
        TeleportQueueSettings teleportQueueSettings = this.queueSettings = newQueueSettings != null ? newQueueSettings : TeleportQueueSettings.disabled();
        if (!this.queueSettings.isEnabled() && this.teleportQueue.isEmpty()) {
            this.queueProcessing = false;
            this.activeTeleportPlayer = null;
        }
    }

    public void setEconomyService(EconomyService economyService) {
        this.economyService = economyService != null ? economyService : EconomyService.disabled();
    }

    public void setCostResolver(BiFunction<Player, RandomTeleportSettings, Double> costResolver) {
        this.costResolver = costResolver;
    }

    public void setProtectionRegistry(ProtectionRegistry protectionRegistry) {
        this.protectionRegistry = protectionRegistry;
    }

    public void teleportPlayer(@NotNull Player player, @NotNull TeleportReason reason) {
        this.teleportPlayer(player, this.settings, reason, null);
    }

    public void teleportPlayer(@NotNull Player player, RandomTeleportSettings teleportSettings, @NotNull TeleportReason reason) {
        this.teleportPlayer(player, teleportSettings, reason, null);
    }

    public void teleportPlayer(@NotNull Player player, @NotNull TeleportReason reason, Consumer<Boolean> callback) {
        this.teleportPlayer(player, this.settings, reason, callback);
    }

    public void teleportPlayer(@NotNull Player player, RandomTeleportSettings teleportSettings, @NotNull TeleportReason reason, Consumer<Boolean> callback) {
        if (teleportSettings == null) {
            if (callback != null) {
                callback.accept(false);
            }
            return;
        }
        double resolvedCost = this.resolveTeleportCost(player, teleportSettings);
        if (this.requiresPayment(reason, resolvedCost) && !this.economyService.hasBalance(player, resolvedCost)) {
            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().insufficientFunds(resolvedCost)));
            if (callback != null) {
                callback.accept(false);
            }
            return;
        }
        if (this.queueSettings != null && this.queueSettings.isEnabled() && !this.queueSettings.canBypass(player)) {
            this.enqueueTeleport(player, teleportSettings, reason);
            if (callback != null) {
                callback.accept(false);
            }
            return;
        }
        int countdown = teleportSettings.getCountdownSeconds();
        if (countdown > 0) {
            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().countdownStart(countdown)));
            this.runCountdown(player, teleportSettings, reason, callback, countdown, countdown);
            return;
        }
        this.performTeleport(player, teleportSettings, reason, callback);
    }

    private void runCountdown(Player player, RandomTeleportSettings teleportSettings, TeleportReason reason, Consumer<Boolean> callback, int seconds, int totalSeconds) {
        if (seconds <= 0) {
            this.clearCountdownBossBar(player.getUniqueId());
            this.performTeleport(player, teleportSettings, reason, callback);
            return;
        }
        if (!player.isOnline()) {
            this.clearCountdownBossBar(player.getUniqueId());
            if (callback != null) {
                callback.accept(false);
            }
            return;
        }
        player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().countdownTick(seconds)));
        this.updateCountdownBossBar(player, teleportSettings, seconds, totalSeconds);
        this.playCountdownParticles(player, teleportSettings.getCountdownParticleSettings());
        this.scheduler.runTaskLater((Plugin)this.plugin, () -> this.runCountdown(player, teleportSettings, reason, callback, seconds - 1, totalSeconds), 20L);
    }

    private CompletableFuture<Void> performTeleport(Player player, RandomTeleportSettings teleportSettings, TeleportReason reason, Consumer<Boolean> callback) {
        CompletableFuture<Void> completion = new CompletableFuture<Void>();
        if (teleportSettings == null) {
            if (callback != null) {
                callback.accept(false);
            }
            completion.complete(null);
            return completion;
        }
        World world = Bukkit.getWorld((String)teleportSettings.getWorldName());
        if (world == null) {
            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().worldMissing(teleportSettings.getWorldName())));
            if (callback != null) {
                callback.accept(false);
            }
            completion.complete(null);
            return completion;
        }
        if (reason == TeleportReason.JOIN) {
            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().joinSearching()));
        } else {
            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().teleporting()));
        }
        this.findSafeLocationAsync(world, teleportSettings).whenComplete((result, throwable) -> {
            Runnable task = () -> {
                boolean success = false;
                try {
                    if (throwable != null || result == null || result.location().isEmpty()) {
                        if (result != null && result.noValidBiome()) {
                            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().teleportFailureBiome()));
                        } else {
                            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().teleportFailure()));
                        }
                        if (callback != null) {
                            callback.accept(false);
                        }
                        return;
                    }
                    if (!player.isOnline()) {
                        if (callback != null) {
                            callback.accept(false);
                        }
                        return;
                    }
                    double resolvedCost = this.resolveTeleportCost(player, teleportSettings);
                    if (this.requiresPayment(reason, resolvedCost) && !this.economyService.withdraw(player, resolvedCost)) {
                        player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().insufficientFunds(resolvedCost)));
                        if (callback != null) {
                            callback.accept(false);
                        }
                        return;
                    }
                    Location destination = this.adjustDestinationForWaterSurface(result.location().get());
                    success = player.teleport(destination);
                    if (success) {
                        player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().teleportSuccess(destination.getBlockX(), destination.getBlockZ(), world.getName())));
                        this.playParticles(destination, teleportSettings.getParticleSettings());
                    } else {
                        player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().teleportFailure()));
                    }
                }
                finally {
                    if (callback != null) {
                        callback.accept(success);
                    }
                    completion.complete(null);
                }
            };
            try {
                this.scheduler.runTask((Plugin)this.plugin, task);
            }
            catch (IllegalStateException ex) {
                if (callback != null) {
                    callback.accept(false);
                }
                completion.complete(null);
            }
        });
        return completion;
    }

    private void enqueueTeleport(Player player, RandomTeleportSettings teleportSettings, TeleportReason reason) {
        UUID playerId = player.getUniqueId();
        if (this.activeTeleportPlayer != null && this.activeTeleportPlayer.equals(playerId)) {
            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().teleporting()));
            return;
        }
        int existingPosition = this.findQueuePosition(playerId);
        if (existingPosition >= 0) {
            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().queued(existingPosition + 1)));
            return;
        }
        if (this.queueSettings.getMaxSize() > 0 && this.teleportQueue.size() >= this.queueSettings.getMaxSize()) {
            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().queueFull(this.queueSettings.getMaxSize())));
            return;
        }
        this.teleportQueue.addLast(new QueuedTeleport(playerId, teleportSettings, reason));
        player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().queued(this.teleportQueue.size())));
        if (!this.queueProcessing) {
            this.queueProcessing = true;
            long delay = Math.max(0L, this.queueSettings.getStartDelayTicks());
            try {
                this.scheduler.runTaskLater((Plugin)this.plugin, this::processNextQueuedTeleport, delay);
            }
            catch (IllegalStateException ex) {
                this.queueProcessing = false;
                this.teleportQueue.clear();
            }
        }
    }

    private int findQueuePosition(UUID playerId) {
        int index = 0;
        for (QueuedTeleport queued : this.teleportQueue) {
            if (queued.playerId().equals(playerId)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void processNextQueuedTeleport() {
        QueuedTeleport next;
        while ((next = this.teleportQueue.pollFirst()) != null) {
            Player player = this.plugin.getServer().getPlayer(next.playerId());
            if (player == null || !player.isOnline()) continue;
            this.activeTeleportPlayer = next.playerId();
            this.performTeleport(player, next.settings(), next.reason()).whenComplete((ignored, throwable) -> {
                this.activeTeleportPlayer = null;
                this.scheduleNextTeleport();
            });
            return;
        }
        this.queueProcessing = false;
        this.activeTeleportPlayer = null;
    }

    private void scheduleNextTeleport() {
        if (this.teleportQueue.isEmpty()) {
            this.queueProcessing = false;
            return;
        }
        long delay = this.queueSettings != null ? Math.max(0L, this.queueSettings.getIntervalTicks()) : 0L;
        try {
            this.scheduler.runTaskLater((Plugin)this.plugin, this::processNextQueuedTeleport, delay);
        }
        catch (IllegalStateException ex) {
            this.queueProcessing = false;
            this.teleportQueue.clear();
        }
    }

    private CompletableFuture<Void> performTeleport(Player player, RandomTeleportSettings teleportSettings, TeleportReason reason) {
        CompletableFuture<Void> completion = new CompletableFuture<Void>();
        if (teleportSettings == null) {
            completion.complete(null);
            return completion;
        }
        World world = Bukkit.getWorld((String)teleportSettings.getWorldName());
        if (world == null) {
            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().worldMissing(teleportSettings.getWorldName())));
            completion.complete(null);
            return completion;
        }
        if (reason == TeleportReason.JOIN) {
            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().joinSearching()));
        } else {
            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().teleporting()));
        }
        this.findSafeLocationAsync(world, teleportSettings).whenComplete((result, throwable) -> {
            Runnable task = () -> {
                try {
                    if (throwable != null || result == null || result.location().isEmpty()) {
                        if (result != null && result.noValidBiome()) {
                            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().teleportFailureBiome()));
                        } else {
                            player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().teleportFailure()));
                        }
                        return;
                    }
                    if (!player.isOnline()) {
                        return;
                    }
                    double resolvedCost = this.resolveTeleportCost(player, teleportSettings);
                    if (this.requiresPayment(reason, resolvedCost) && !this.economyService.withdraw(player, resolvedCost)) {
                        player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().insufficientFunds(resolvedCost)));
                        return;
                    }
                    Location destination = this.adjustDestinationForWaterSurface(result.location().get());
                    boolean success = player.teleport(destination);
                    if (success) {
                        player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().teleportSuccess(destination.getBlockX(), destination.getBlockZ(), world.getName())));
                        this.playParticles(destination, teleportSettings.getParticleSettings());
                    } else {
                        player.sendMessage(RandomTeleportService.legacy(teleportSettings.getMessages().teleportFailure()));
                    }
                }
                finally {
                    completion.complete(null);
                }
            };
            try {
                this.scheduler.runTask((Plugin)this.plugin, task);
            }
            catch (IllegalStateException ex) {
                completion.complete(null);
            }
        });
        return completion;
    }

    private CompletableFuture<SearchResult> findSafeLocationAsync(World world, RandomTeleportSettings currentSettings) {
        return this.attemptFindLocation(world, currentSettings, 0, false);
    }

    private CompletableFuture<SearchResult> attemptFindLocation(World world, RandomTeleportSettings currentSettings, int attempt, boolean rejectedForBiome) {
        if (attempt >= currentSettings.getMaxAttempts()) {
            boolean noValidBiome = rejectedForBiome && (!currentSettings.getBiomeInclude().isEmpty() || !currentSettings.getBiomeExclude().isEmpty());
            return CompletableFuture.completedFuture(new SearchResult(Optional.empty(), noValidBiome));
        }
        return this.generateCandidateLocationAsync(world, currentSettings).thenCompose(candidate -> {
            if (candidate == null || !this.isSafe((Location)candidate, currentSettings)) {
                return this.attemptFindLocation(world, currentSettings, attempt + 1, rejectedForBiome);
            }
            if (!this.isBiomeAllowed((Location)candidate, currentSettings)) {
                this.debugReject((Location)candidate, "Biome not allowed: " + candidate.getBlock().getBiome().name());
                return this.attemptFindLocation(world, currentSettings, attempt + 1, true);
            }
            if (this.isProtectedByClaims((Location)candidate, currentSettings)) {
                this.debugReject((Location)candidate, "Location is inside a protected region");
                return this.attemptFindLocation(world, currentSettings, attempt + 1, rejectedForBiome);
            }
            return CompletableFuture.completedFuture(new SearchResult(Optional.of(candidate), false));
        });
    }

    private CompletableFuture<Location> generateCandidateLocationAsync(World world, RandomTeleportSettings currentSettings) {
        int min = currentSettings.getMinimumRadius();
        int max = this.resolveMaximumRadius(world, currentSettings);
        if (max < min) {
            max = min;
        }
        int radius = min == max ? min : min + this.random.nextInt(max - min + 1);
        double angle = this.random.nextDouble() * Math.PI * 2.0;
        int centerX = currentSettings.getCenterX();
        int centerZ = currentSettings.getCenterZ();
        if (currentSettings.useWorldBorderRadius()) {
            Location borderCenter = world.getWorldBorder().getCenter();
            centerX = (int)Math.round(borderCenter.getX());
            centerZ = (int)Math.round(borderCenter.getZ());
        }
        int x = centerX + (int)Math.round(Math.cos(angle) * (double)radius);
        int z = centerZ + (int)Math.round(Math.sin(angle) * (double)radius);
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        CompletableFuture<Location> future = new CompletableFuture<Location>();
        if (!world.isChunkLoaded(chunkX, chunkZ)) {
            this.scheduler.runTask((Plugin)this.plugin, () -> {
                world.loadChunk(chunkX, chunkZ);
                this.scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
                    try {
                        Location candidate = this.resolveCandidateLocation(world, x, z);
                        future.complete(candidate);
                    }
                    catch (Exception ex) {
                        future.completeExceptionally(ex);
                    }
                });
            });
        } else {
            this.scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
                try {
                    Location candidate = this.resolveCandidateLocation(world, x, z);
                    future.complete(candidate);
                }
                catch (Exception ex) {
                    future.completeExceptionally(ex);
                }
            });
        }
        return future;
    }

    private Location resolveCandidateLocation(World world, int x, int z) {
        int minY = this.getWorldMinHeight(world);
        int maxY = this.getWorldMaxHeight(world) - 1;
        if (world.getEnvironment() == World.Environment.NETHER) {
            maxY = Math.min(maxY, 126);
        }
        if (world.getEnvironment() != World.Environment.NORMAL) {
            int highestY = Math.min(world.getHighestBlockYAt(x, z, HeightMap.MOTION_BLOCKING), maxY);
            if (highestY <= minY) {
                return null;
            }
            return this.findPassableLocation(world, x, z, highestY, minY);
        }
        int highestY = world.getHighestBlockYAt(x, z, HeightMap.MOTION_BLOCKING);
        if (highestY <= minY) {
            return null;
        }
        return this.findPassableLocation(world, x, z, highestY, minY);
    }

    private Location findPassableLocation(World world, int x, int z, int startY, int minY) {
        for (int y = startY; y > minY; --y) {
            Block block = world.getBlockAt(x, y, z);
            if (!block.getType().isSolid()) continue;
            Block above = block.getRelative(BlockFace.UP);
            Block twoAbove = above.getRelative(BlockFace.UP);
            if (!above.isPassable() || !twoAbove.isPassable()) continue;
            if (above.isLiquid()) {
                Location surface = this.findSurfaceAboveLiquid(world, x, z, above.getY());
                if (surface == null) continue;
                return surface;
            }
            return new Location(world, (double)x + 0.5, (double)block.getY() + 1.0, (double)z + 0.5);
        }
        return null;
    }

    private Location findSurfaceAboveLiquid(World world, int x, int z, int startY) {
        int y;
        int maxY = this.getWorldMaxHeight(world) - 1;
        for (y = startY; y <= maxY && world.getBlockAt(x, y, z).isLiquid(); ++y) {
        }
        if (y > maxY) {
            return null;
        }
        Block surface = world.getBlockAt(x, y, z);
        Block above = surface.getRelative(BlockFace.UP);
        if (!surface.isPassable() || !above.isPassable()) {
            return null;
        }
        return new Location(world, (double)x + 0.5, (double)surface.getY(), (double)z + 0.5);
    }

    private Location adjustDestinationForWaterSurface(Location destination) {
        World world = destination.getWorld();
        if (world == null || world.getEnvironment() != World.Environment.NORMAL) {
            return destination;
        }
        Block baseBlock = destination.getBlock();
        Block blockBelow = baseBlock.getRelative(BlockFace.DOWN);
        if (blockBelow.getType() != Material.WATER) {
            return destination;
        }
        Block blockAbove = baseBlock.getRelative(BlockFace.UP);
        if (!baseBlock.isPassable() || baseBlock.isLiquid() || !blockAbove.isPassable()) {
            return destination;
        }
        baseBlock.setType(Material.DIRT, false);
        return destination.clone().add(0.0, 1.0, 0.0);
    }

    private boolean isSafe(Location location, RandomTeleportSettings currentSettings) {
        boolean waterSurface;
        int maxY;
        Block blockBelow = location.clone().subtract(0.0, 1.0, 0.0).getBlock();
        Block destination = location.getBlock();
        Material typeBelow = blockBelow.getType();
        int y = location.getBlockY();
        int minY = currentSettings.getMinY() != null ? currentSettings.getMinY().intValue() : this.getWorldMinHeight(location.getWorld());
        int n = maxY = currentSettings.getMaxY() != null ? currentSettings.getMaxY().intValue() : this.getWorldMaxHeight(location.getWorld());
        if (y < minY || y > maxY) {
            this.debugReject(location, "Y out of range: " + y + " not in [" + minY + ", " + maxY + "]");
            return false;
        }
        if (destination.isLiquid()) {
            this.debugReject(location, "Destination is inside liquid: " + String.valueOf(destination.getType()));
            return false;
        }
        boolean bl = waterSurface = typeBelow == Material.WATER && !destination.isLiquid();
        if (currentSettings.getUnsafeBlocks().contains(typeBelow) && !waterSurface) {
            this.debugReject(location, "Unsafe block below: " + String.valueOf(typeBelow));
            return false;
        }
        if (!blockBelow.getType().isSolid() && !waterSurface) {
            this.debugReject(location, "Block below not solid: " + String.valueOf(typeBelow));
            return false;
        }
        if (!location.getWorld().getWorldBorder().isInside(location)) {
            this.debugReject(location, "Outside world border");
            return false;
        }
        return true;
    }

    private boolean isBiomeAllowed(Location location, RandomTeleportSettings currentSettings) {
        if (currentSettings.getBiomeInclude().isEmpty() && currentSettings.getBiomeExclude().isEmpty()) {
            return true;
        }
        Biome biome = location.getBlock().getBiome();
        if (!currentSettings.getBiomeExclude().isEmpty() && currentSettings.getBiomeExclude().contains(biome)) {
            return false;
        }
        return currentSettings.getBiomeInclude().isEmpty() || currentSettings.getBiomeInclude().contains(biome);
    }

    private boolean isProtectedByClaims(Location location, RandomTeleportSettings currentSettings) {
        if (this.protectionRegistry == null || currentSettings == null) {
            return false;
        }
        return this.protectionRegistry.findProtectionProvider(location, currentSettings.getProtectionSettings()).isPresent();
    }

    private void debugReject(Location loc, String reason) {
        if (this.settings != null && this.settings.isDebugRejectionLoggingEnabled()) {
            Bukkit.getLogger().info("RTP rejected " + String.valueOf(loc) + ": " + reason);
        }
    }

    private int resolveMaximumRadius(World world, RandomTeleportSettings settings) {
        if (!settings.useWorldBorderRadius()) {
            return settings.getMaximumRadius();
        }
        double borderRadius = world.getWorldBorder().getSize() * 0.5;
        int resolved = (int)Math.floor(borderRadius);
        return Math.max(settings.getMinimumRadius(), resolved);
    }

    private double resolveTeleportCost(Player player, RandomTeleportSettings teleportSettings) {
        if (teleportSettings == null) {
            return 0.0;
        }
        if (this.costResolver == null) {
            return teleportSettings.getTeleportCost();
        }
        Double resolved = this.costResolver.apply(player, teleportSettings);
        return resolved != null ? resolved.doubleValue() : teleportSettings.getTeleportCost();
    }

    private boolean requiresPayment(TeleportReason reason, double cost) {
        return reason == TeleportReason.COMMAND && cost > 0.0;
    }

    private int getWorldMinHeight(World world) {
        try {
            return (Integer)World.class.getMethod("getMinHeight", new Class[0]).invoke((Object)world, new Object[0]);
        }
        catch (ReflectiveOperationException ignored) {
            return 0;
        }
    }

    private int getWorldMaxHeight(World world) {
        try {
            return (Integer)World.class.getMethod("getMaxHeight", new Class[0]).invoke((Object)world, new Object[0]);
        }
        catch (ReflectiveOperationException ignored) {
            return world.getMaxHeight();
        }
    }

    private void playParticles(Location destination, ParticleSettings particleSettings) {
        if (particleSettings == null || !particleSettings.isEnabled()) {
            return;
        }
        World world = destination.getWorld();
        if (world == null) {
            return;
        }
        world.spawnParticle(particleSettings.getParticle(), destination, particleSettings.getCount(), particleSettings.getOffsetX(), particleSettings.getOffsetY(), particleSettings.getOffsetZ(), particleSettings.getExtra(), null, particleSettings.isForce());
    }

    private void updateCountdownBossBar(Player player, RandomTeleportSettings teleportSettings, int seconds, int totalSeconds) {
        CountdownBossBarSettings bossBarSettings = teleportSettings.getCountdownBossBarSettings();
        if (bossBarSettings == null || !bossBarSettings.isEnabled()) {
            this.clearCountdownBossBar(player.getUniqueId());
            return;
        }
        BossBar bossBar = this.countdownBossBars.get(player.getUniqueId());
        if (bossBar == null) {
            bossBar = Bukkit.createBossBar((String)"", (BarColor)bossBarSettings.getColor(), (BarStyle)bossBarSettings.getStyle(), (BarFlag[])new BarFlag[0]);
            this.countdownBossBars.put(player.getUniqueId(), bossBar);
        } else {
            if (bossBar.getColor() != bossBarSettings.getColor()) {
                bossBar.setColor(bossBarSettings.getColor());
            }
            if (bossBar.getStyle() != bossBarSettings.getStyle()) {
                bossBar.setStyle(bossBarSettings.getStyle());
            }
        }
        if (!bossBar.getPlayers().contains(player)) {
            bossBar.addPlayer(player);
        }
        bossBar.setTitle(LegacyComponentSerializer.legacySection().serialize(bossBarSettings.titleComponent(seconds)));
        double progress = totalSeconds > 0 ? (double)seconds / (double)totalSeconds : 1.0;
        bossBar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
    }

    private void clearCountdownBossBar(UUID playerId) {
        BossBar bossBar = this.countdownBossBars.remove(playerId);
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    private void playCountdownParticles(Player player, CountdownParticleSettings settings) {
        if (settings == null || !settings.isEnabled()) {
            return;
        }
        Location baseLocation = player.getLocation().clone().add(0.0, settings.getHeightOffset(), 0.0);
        World world = baseLocation.getWorld();
        if (world == null) {
            return;
        }
        int points = Math.max(1, settings.getPoints());
        double radius = settings.getRadius();
        for (int i = 0; i < points; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)points;
            double x = Math.cos(angle) * radius;
            double z = Math.sin(angle) * radius;
            Location particleLocation = baseLocation.clone().add(x, 0.0, z);
            world.spawnParticle(settings.getParticle(), particleLocation, 1, 0.0, 0.0, 0.0, settings.getExtra(), null, settings.isForce());
        }
        Particle secondary = settings.getSecondaryParticle();
        if (secondary != null && settings.getSecondaryCount() > 0) {
            world.spawnParticle(secondary, baseLocation, settings.getSecondaryCount(), settings.getSecondaryOffset(), settings.getSecondaryOffset(), settings.getSecondaryOffset(), settings.getExtra(), null, settings.isForce());
        }
    }

    private static String legacy(Component component) {
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    private record QueuedTeleport(UUID playerId, RandomTeleportSettings settings, TeleportReason reason) {
    }

    private record SearchResult(Optional<Location> location, boolean noValidBiome) {
    }
}

