/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.storage;

import com.skyblockexp.ezrtp.storage.RtpUsageStorage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlRtpUsageStorage
implements RtpUsageStorage {
    private final File file;
    private YamlConfiguration config;
    private final Map<String, Object> cache = new HashMap<String, Object>();

    public YamlRtpUsageStorage(File file) {
        this.file = file;
        this.reload();
    }

    @Override
    public long getLastRtpTime(UUID player, String world) {
        return this.config.getLong("players." + String.valueOf(player) + "." + world + ".lastRtp", 0L);
    }

    @Override
    public void setLastRtpTime(UUID player, String world, long time) {
        this.config.set("players." + String.valueOf(player) + "." + world + ".lastRtp", (Object)time);
    }

    @Override
    public int getUsageCount(UUID player, String world, String period) {
        return this.config.getInt("players." + String.valueOf(player) + "." + world + ".usage." + period, 0);
    }

    @Override
    public void incrementUsage(UUID player, String world, String period) {
        String path = "players." + String.valueOf(player) + "." + world + ".usage." + period;
        int count = this.config.getInt(path, 0);
        this.config.set(path, (Object)(count + 1));
    }

    @Override
    public void resetUsage(UUID player, String world, String period) {
        if (player == null && world == null) {
            if (this.config.isConfigurationSection("players")) {
                for (String p : this.config.getConfigurationSection("players").getKeys(false)) {
                    for (String w : this.config.getConfigurationSection("players." + p).getKeys(false)) {
                        this.config.set("players." + p + "." + w + ".usage." + period, (Object)0);
                    }
                }
            }
        } else if (player != null && world == null) {
            if (this.config.isConfigurationSection("players." + String.valueOf(player))) {
                for (String w : this.config.getConfigurationSection("players." + String.valueOf(player)).getKeys(false)) {
                    this.config.set("players." + String.valueOf(player) + "." + w + ".usage." + period, (Object)0);
                }
            }
        } else if (player == null && world != null) {
            if (this.config.isConfigurationSection("players")) {
                for (String p : this.config.getConfigurationSection("players").getKeys(false)) {
                    this.config.set("players." + p + "." + world + ".usage." + period, (Object)0);
                }
            }
        } else {
            this.config.set("players." + String.valueOf(player) + "." + world + ".usage." + period, (Object)0);
        }
    }

    @Override
    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            Bukkit.getLogger().warning("[EzRTP] Failed to save RTP usage YAML: " + e.getMessage());
        }
    }

    @Override
    public void reload() {
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getLogger().warning("[EzRTP] Failed to create RTP usage YAML: " + e.getMessage());
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }
}

