/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.protection;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.skyblockexp.ezrtp.protection.ProtectionProvider;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class WorldGuardProtectionProvider
implements ProtectionProvider {
    private static final String GLOBAL_REGION_ID = "__global__";
    private final Logger logger;
    private final boolean available;
    private final RegionContainer regionContainer;

    public WorldGuardProtectionProvider(PluginManager pluginManager, Logger logger) {
        Plugin plugin;
        this.logger = Objects.requireNonNull(logger, "logger");
        Plugin plugin2 = plugin = pluginManager != null ? pluginManager.getPlugin("WorldGuard") : null;
        if (plugin == null || !plugin.isEnabled()) {
            this.available = false;
            this.regionContainer = null;
            return;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        if (container == null) {
            this.available = false;
            this.regionContainer = null;
            return;
        }
        this.available = true;
        this.regionContainer = container;
    }

    @Override
    public String getId() {
        return "worldguard";
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public boolean isLocationProtected(Location location) {
        if (!this.available || location == null) {
            return false;
        }
        World world = location.getWorld();
        if (world == null) {
            return false;
        }
        RegionManager manager = this.getRegionManager(world);
        if (manager == null) {
            return false;
        }
        try {
            ApplicableRegionSet regions = manager.getApplicableRegions(BlockVector3.at((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ()));
            if (regions == null) {
                return false;
            }
            for (ProtectedRegion region : regions) {
                if (GLOBAL_REGION_ID.equalsIgnoreCase(region.getId())) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException ex) {
            this.logger.log(Level.WARNING, "Failed to query WorldGuard regions for RTP protection check.", ex);
            return false;
        }
    }

    private RegionManager getRegionManager(World world) {
        try {
            return this.regionContainer.get(BukkitAdapter.adapt((World)world));
        }
        catch (RuntimeException ex) {
            this.logger.log(Level.WARNING, "Unable to access WorldGuard region manager for world " + world.getName(), ex);
            return null;
        }
    }
}

