/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.protection;

import com.skyblockexp.ezrtp.config.ProtectionSettings;
import com.skyblockexp.ezrtp.protection.GriefPreventionProtectionProvider;
import com.skyblockexp.ezrtp.protection.ProtectionProvider;
import com.skyblockexp.ezrtp.protection.WorldGuardProtectionProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class ProtectionRegistry {
    private final Map<String, ProtectionProvider> providers = new HashMap<String, ProtectionProvider>();
    private final Logger logger;

    public ProtectionRegistry(JavaPlugin plugin) {
        this.logger = plugin.getLogger();
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        this.registerProvider(new WorldGuardProtectionProvider(pluginManager, this.logger));
        this.registerProvider(new GriefPreventionProtectionProvider(pluginManager, this.logger));
    }

    public Optional<String> findProtectionProvider(Location location, ProtectionSettings settings) {
        if (settings == null || !settings.isAvoidClaims()) {
            return Optional.empty();
        }
        for (String providerId : settings.getProviders()) {
            ProtectionProvider provider = this.providers.get(providerId);
            if (provider == null || !provider.isAvailable() || !provider.isLocationProtected(location)) continue;
            return Optional.of(providerId);
        }
        return Optional.empty();
    }

    public void warnMissingProviders(ProtectionSettings settings) {
        if (settings == null || !settings.isAvoidClaims()) {
            return;
        }
        for (String providerId : settings.getProviders()) {
            ProtectionProvider provider = this.providers.get(providerId);
            if (provider != null && provider.isAvailable()) continue;
            this.logger.warning("EzRTP protection provider '" + providerId + "' is configured but not available; protected regions will not be avoided for this provider.");
        }
    }

    private void registerProvider(ProtectionProvider provider) {
        this.providers.put(provider.getId(), provider);
    }
}

