/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.protection;

import com.skyblockexp.ezrtp.protection.ProtectionProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class GriefPreventionProtectionProvider
implements ProtectionProvider {
    private final Logger logger;
    private final boolean available;
    private final Object dataStore;
    private final Method getClaimAtMethod;

    public GriefPreventionProtectionProvider(PluginManager pluginManager, Logger logger) {
        Plugin plugin;
        this.logger = Objects.requireNonNull(logger, "logger");
        Plugin plugin2 = plugin = pluginManager != null ? pluginManager.getPlugin("GriefPrevention") : null;
        if (plugin == null || !plugin.isEnabled()) {
            this.available = false;
            this.dataStore = null;
            this.getClaimAtMethod = null;
            return;
        }
        Object resolvedDataStore = null;
        Method resolvedGetClaimAt = null;
        boolean resolvedAvailable = false;
        try {
            ClassLoader classLoader = plugin.getClass().getClassLoader();
            Class<?> pluginClass = classLoader.loadClass("me.ryanhamshire.GriefPrevention.GriefPrevention");
            Field dataStoreField = pluginClass.getField("dataStore");
            resolvedDataStore = dataStoreField.get(plugin);
            if (resolvedDataStore != null) {
                resolvedGetClaimAt = resolvedDataStore.getClass().getMethod("getClaimAt", Location.class, Boolean.TYPE, Object.class);
                resolvedAvailable = true;
            }
        }
        catch (ReflectiveOperationException | RuntimeException ex) {
            logger.log(Level.WARNING, "Failed to initialize GriefPrevention RTP protection hook.", ex);
        }
        this.available = resolvedAvailable;
        this.dataStore = resolvedDataStore;
        this.getClaimAtMethod = resolvedGetClaimAt;
    }

    @Override
    public String getId() {
        return "griefprevention";
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public boolean isLocationProtected(Location location) {
        if (!this.available || location == null || this.dataStore == null || this.getClaimAtMethod == null) {
            return false;
        }
        try {
            Object claim = this.getClaimAtMethod.invoke(this.dataStore, location, false, null);
            return claim != null;
        }
        catch (ReflectiveOperationException | RuntimeException ex) {
            this.logger.log(Level.WARNING, "Failed to query GriefPrevention claims for RTP protection check.", ex);
            return false;
        }
    }
}

