/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.gui;

import com.skyblockexp.ezrtp.config.EzRtpConfiguration;
import com.skyblockexp.ezrtp.config.NetworkConfiguration;
import com.skyblockexp.ezrtp.config.RandomTeleportSettings;
import com.skyblockexp.ezrtp.network.NetworkService;
import com.skyblockexp.ezrtp.teleport.RandomTeleportService;
import com.skyblockexp.ezrtp.teleport.TeleportReason;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public final class RandomTeleportGuiManager
implements Listener {
    private final JavaPlugin plugin;
    private final Supplier<RandomTeleportService> teleportServiceSupplier;
    private final Supplier<EzRtpConfiguration> configurationSupplier;
    private final Supplier<NetworkService> networkServiceSupplier;
    private final Map<UUID, GuiSession> openMenus = new HashMap<UUID, GuiSession>();

    public RandomTeleportGuiManager(JavaPlugin plugin, Supplier<RandomTeleportService> teleportServiceSupplier, Supplier<EzRtpConfiguration> configurationSupplier, Supplier<NetworkService> networkServiceSupplier) {
        this.plugin = plugin;
        this.teleportServiceSupplier = teleportServiceSupplier;
        this.configurationSupplier = configurationSupplier;
        this.networkServiceSupplier = networkServiceSupplier;
    }

    public boolean openSelection(Player player) {
        EzRtpConfiguration configuration = this.configurationSupplier.get();
        if (configuration == null) {
            return false;
        }
        EzRtpConfiguration.GuiSettings guiSettings = configuration.getGuiSettings();
        if (!guiSettings.isEnabled()) {
            return false;
        }
        if (guiSettings.getWorldOptions().isEmpty() && guiSettings.getServerOptions().isEmpty()) {
            return false;
        }
        String titleString = LegacyComponentSerializer.legacySection().serialize(guiSettings.getTitle());
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)guiSettings.getSize(), (String)titleString);
        guiSettings.getFillerItem().ifPresent(filler -> this.fillInventory(inventory, (ItemStack)filler));
        HashMap<Integer, GuiOption> optionMap = new HashMap<Integer, GuiOption>();
        for (EzRtpConfiguration.GuiWorldOption option : guiSettings.getWorldOptions()) {
            int slot;
            if (!option.getPermission().isEmpty() && !player.hasPermission(option.getPermission()) || (slot = option.getSlot()) < 0 || slot >= inventory.getSize()) continue;
            inventory.setItem(slot, option.createIcon());
            optionMap.put(slot, GuiOption.world(option));
        }
        if (configuration.getNetworkConfiguration() != null && configuration.getNetworkConfiguration().isEnabled() && configuration.getNetworkConfiguration().isLobbyServer()) {
            NetworkService networkService;
            NetworkService networkService2 = networkService = this.networkServiceSupplier != null ? this.networkServiceSupplier.get() : null;
            if (networkService != null) {
                for (EzRtpConfiguration.GuiServerOption serverOption : guiSettings.getServerOptions()) {
                    int slot;
                    NetworkConfiguration.NetworkServer server = serverOption.getServer();
                    if (!server.getPermission().isEmpty() && !player.hasPermission(server.getPermission()) || (slot = server.getSlot()) < 0 || slot >= inventory.getSize() || optionMap.containsKey(slot)) continue;
                    NetworkConfiguration.ServerStatusSnapshot status = networkService.getStatus(server);
                    if (server.hideWhenOffline() && status.isOffline()) continue;
                    inventory.setItem(slot, networkService.createIcon(server));
                    optionMap.put(slot, GuiOption.server(serverOption));
                }
            }
        }
        if (optionMap.isEmpty()) {
            player.sendMessage("\u00a7cNo teleport destinations are currently available.");
            return true;
        }
        GuiSession session = new GuiSession(inventory, optionMap, guiSettings);
        this.openMenus.put(player.getUniqueId(), session);
        player.openInventory(inventory);
        return true;
    }

    public void closeAll() {
        if (this.openMenus.isEmpty()) {
            return;
        }
        for (UUID uuid : new ArrayList<UUID>(this.openMenus.keySet())) {
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (player == null || !player.isOnline()) continue;
            player.closeInventory();
        }
        this.openMenus.clear();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        NetworkService networkService;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        GuiSession session = this.openMenus.get(player.getUniqueId());
        if (session == null || !Objects.equals(event.getView().getTopInventory(), session.inventory())) {
            return;
        }
        event.setCancelled(true);
        if (event.getRawSlot() < 0 || event.getRawSlot() >= session.inventory().getSize()) {
            return;
        }
        GuiOption option = session.options().get(event.getRawSlot());
        if (option == null) {
            return;
        }
        if (option.isWorldOption()) {
            EzRtpConfiguration.GuiWorldOption worldOption = option.worldOption();
            if (!worldOption.getPermission().isEmpty() && !player.hasPermission(worldOption.getPermission())) {
                session.settings().noPermissionMessage().ifPresent(arg_0 -> player.sendMessage(arg_0));
                return;
            }
            RandomTeleportService service = this.teleportServiceSupplier.get();
            if (service == null) {
                return;
            }
            RandomTeleportSettings settings = worldOption.getSettings();
            player.closeInventory();
            service.teleportPlayer(player, settings, TeleportReason.COMMAND);
            return;
        }
        EzRtpConfiguration.GuiServerOption serverOption = option.serverOption();
        if (serverOption == null) {
            return;
        }
        NetworkService networkService2 = networkService = this.networkServiceSupplier != null ? this.networkServiceSupplier.get() : null;
        if (networkService == null) {
            player.sendMessage("\u00a7cUnable to connect to the network service right now. Please try again later.");
            return;
        }
        NetworkConfiguration.NetworkServer server = serverOption.getServer();
        if (!server.getPermission().isEmpty() && !player.hasPermission(server.getPermission())) {
            session.settings().noPermissionMessage().ifPresent(arg_0 -> player.sendMessage(arg_0));
            return;
        }
        NetworkConfiguration.ServerStatusSnapshot status = networkService.getStatus(server);
        if (status.isOffline() && !server.allowWhenOffline()) {
            Component message = server.offlineMessage();
            if (message != null && !message.equals(Component.empty())) {
                player.sendMessage(message);
            } else {
                player.sendMessage("\u00a7cThat server is currently offline.");
            }
            return;
        }
        player.closeInventory();
        networkService.transferPlayer(player, server);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        GuiSession session = this.openMenus.get(player.getUniqueId());
        if (session == null || !Objects.equals(event.getView().getTopInventory(), session.inventory())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        GuiSession session = this.openMenus.get(player.getUniqueId());
        if (session == null) {
            return;
        }
        if (Objects.equals(session.inventory(), event.getInventory())) {
            this.openMenus.remove(player.getUniqueId());
        }
    }

    private void fillInventory(Inventory inventory, ItemStack fillerTemplate) {
        ItemStack filler = fillerTemplate.clone();
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            if (inventory.getItem(slot) != null) continue;
            inventory.setItem(slot, filler.clone());
        }
    }

    private record GuiOption(EzRtpConfiguration.GuiWorldOption worldOption, EzRtpConfiguration.GuiServerOption serverOption) {
        static GuiOption world(EzRtpConfiguration.GuiWorldOption option) {
            return new GuiOption(option, null);
        }

        static GuiOption server(EzRtpConfiguration.GuiServerOption option) {
            return new GuiOption(null, option);
        }

        boolean isWorldOption() {
            return this.worldOption != null;
        }
    }

    private record GuiSession(Inventory inventory, Map<Integer, GuiOption> options, EzRtpConfiguration.GuiSettings settings) {
    }
}

