/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.economy;

import com.skyblockexp.ezrtp.economy.EconomyService;
import java.util.Locale;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public final class VaultEconomyService
implements EconomyService {
    private final Economy economy;
    private final Logger logger;

    public VaultEconomyService(Economy economy, Logger logger) {
        this.economy = economy;
        this.logger = logger;
    }

    @Override
    public boolean isEnabled() {
        return this.economy != null;
    }

    @Override
    public boolean hasBalance(Player player, double amount) {
        if (this.economy == null || amount <= 0.0) {
            return true;
        }
        return this.economy.has((OfflinePlayer)player, amount);
    }

    @Override
    public boolean withdraw(Player player, double amount) {
        if (this.economy == null || amount <= 0.0) {
            return true;
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)player, amount);
        if (response.transactionSuccess()) {
            return true;
        }
        if (this.logger != null) {
            this.logger.warning(String.format(Locale.US, "Failed to withdraw %.2f from %s: %s", amount, player.getName(), response.errorMessage == null ? "unknown error" : response.errorMessage));
        }
        return false;
    }

    public String getProviderName() {
        return this.economy != null ? this.economy.getName() : "Unknown";
    }
}

