/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.config;

import com.skyblockexp.ezrtp.config.NetworkConfiguration;
import com.skyblockexp.ezrtp.config.RandomTeleportSettings;
import com.skyblockexp.ezrtp.config.TeleportQueueSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class EzRtpConfiguration {
    private final Map<String, Map<String, RtpLimitSettings>> worldGroupLimits = new LinkedHashMap<String, Map<String, RtpLimitSettings>>();
    private final RtpLimitSettings defaultLimitSettings;
    private final List<String> bypassPermissions;
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final RandomTeleportSettings defaultSettings;
    private final GuiSettings guiSettings;
    private final TeleportQueueSettings queueSettings;
    private final NetworkConfiguration networkConfiguration;

    private EzRtpConfiguration(RandomTeleportSettings defaultSettings, GuiSettings guiSettings, TeleportQueueSettings queueSettings, NetworkConfiguration networkConfiguration) {
        this.defaultSettings = defaultSettings;
        this.guiSettings = guiSettings;
        this.queueSettings = queueSettings;
        this.networkConfiguration = networkConfiguration;
        Configuration config = defaultSettings.getConfigSection().getRoot();
        ConfigurationSection rtpLimits = config.getConfigurationSection("rtp-limits");
        if (rtpLimits != null) {
            ConfigurationSection def = rtpLimits.getConfigurationSection("default");
            this.defaultLimitSettings = EzRtpConfiguration.parseLimitSection(def);
            ConfigurationSection worlds = rtpLimits.getConfigurationSection("worlds");
            if (worlds != null) {
                for (String world : worlds.getKeys(false)) {
                    ConfigurationSection worldSec = worlds.getConfigurationSection(world);
                    LinkedHashMap<String, RtpLimitSettings> groupMap = new LinkedHashMap<String, RtpLimitSettings>();
                    for (String group : worldSec.getKeys(false)) {
                        ConfigurationSection groupSec = worldSec.getConfigurationSection(group);
                        groupMap.put(group, EzRtpConfiguration.parseLimitSection(groupSec));
                    }
                    this.worldGroupLimits.put(world, groupMap);
                }
            }
            this.bypassPermissions = rtpLimits.getStringList("bypass-permissions");
        } else {
            this.defaultLimitSettings = new RtpLimitSettings(300, 10, 50, null);
            this.bypassPermissions = Collections.emptyList();
        }
    }

    private static RtpLimitSettings parseLimitSection(ConfigurationSection section) {
        if (section == null) {
            return new RtpLimitSettings(300, 10, 50, null);
        }
        int cooldown = section.getInt("cooldown-seconds", 300);
        int daily = section.getInt("daily-limit", 10);
        int weekly = section.getInt("weekly-limit", 50);
        Double cost = section.contains("cost") ? Double.valueOf(section.getDouble("cost")) : null;
        return new RtpLimitSettings(cooldown, daily, weekly, cost);
    }

    public RtpLimitSettings getLimitSettings(String world, String group) {
        Map<String, RtpLimitSettings> groupMap = this.worldGroupLimits.get(world);
        if (groupMap != null) {
            if (group != null && groupMap.containsKey(group)) {
                return groupMap.get(group);
            }
            if (groupMap.containsKey("default")) {
                return groupMap.get("default");
            }
        }
        return this.defaultLimitSettings;
    }

    public List<String> getBypassPermissions() {
        return this.bypassPermissions;
    }

    public String resolveGroup(Player player, String world) {
        if (player == null || world == null) {
            return null;
        }
        Map<String, RtpLimitSettings> groupMap = this.worldGroupLimits.get(world);
        if (groupMap == null) {
            return null;
        }
        for (String groupKey : groupMap.keySet()) {
            String groupName;
            if (!groupKey.startsWith("group.") || (groupName = groupKey.substring("group.".length())).isEmpty() || !player.hasPermission("ezrtp.group." + groupName)) continue;
            return groupKey;
        }
        return null;
    }

    public double resolveTeleportCost(Player player, RandomTeleportSettings settings) {
        if (settings == null) {
            return 0.0;
        }
        double fallbackCost = settings.getTeleportCost();
        if (player == null) {
            return fallbackCost;
        }
        String world = settings.getWorldName();
        String group = this.resolveGroup(player, world);
        Map<String, RtpLimitSettings> groupMap = this.worldGroupLimits.get(world);
        if (groupMap != null) {
            RtpLimitSettings groupSettings;
            if (group != null && (groupSettings = groupMap.get(group)) != null && groupSettings.cost != null) {
                return groupSettings.cost;
            }
            RtpLimitSettings worldDefault = groupMap.get("default");
            if (worldDefault != null && worldDefault.cost != null) {
                return worldDefault.cost;
            }
        }
        if (this.defaultLimitSettings != null && this.defaultLimitSettings.cost != null) {
            return this.defaultLimitSettings.cost;
        }
        return fallbackCost;
    }

    public RandomTeleportSettings getDefaultSettings() {
        return this.defaultSettings;
    }

    public GuiSettings getGuiSettings() {
        return this.guiSettings;
    }

    public TeleportQueueSettings getQueueSettings() {
        return this.queueSettings;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public static EzRtpConfiguration fromConfiguration(FileConfiguration configuration, Logger logger) {
        return EzRtpConfiguration.fromConfigurations((ConfigurationSection)configuration, configuration.getConfigurationSection("messages"), configuration.getConfigurationSection("gui"), configuration.getConfigurationSection("queue"), configuration.getConfigurationSection("network"), logger);
    }

    public static EzRtpConfiguration fromConfigurations(ConfigurationSection baseConfiguration, ConfigurationSection messagesConfiguration, ConfigurationSection guiConfiguration, ConfigurationSection queueConfiguration, ConfigurationSection networkConfiguration, Logger logger) {
        MemoryConfiguration mergedConfiguration = new MemoryConfiguration();
        if (baseConfiguration != null) {
            EzRtpConfiguration.copySection(baseConfiguration, (ConfigurationSection)mergedConfiguration);
        }
        if (EzRtpConfiguration.isSectionPopulated(messagesConfiguration)) {
            mergedConfiguration.set("messages", null);
            EzRtpConfiguration.copySection(messagesConfiguration, mergedConfiguration.createSection("messages"));
        }
        RandomTeleportSettings defaultSettings = RandomTeleportSettings.fromConfiguration((ConfigurationSection)mergedConfiguration, logger);
        NetworkConfiguration networkConfig = NetworkConfiguration.fromConfiguration(networkConfiguration, logger);
        GuiSettings guiSettings = GuiSettings.fromConfiguration(guiConfiguration, defaultSettings, networkConfig, logger);
        TeleportQueueSettings queueSettings = TeleportQueueSettings.fromConfiguration(queueConfiguration);
        return new EzRtpConfiguration(defaultSettings, guiSettings, queueSettings, networkConfig);
    }

    private static void copySection(ConfigurationSection source, ConfigurationSection target) {
        if (source == null || target == null) {
            return;
        }
        for (String key : source.getKeys(false)) {
            Object value = source.get(key);
            if (value instanceof ConfigurationSection) {
                ConfigurationSection existing = target.getConfigurationSection(key);
                if (existing == null) {
                    existing = target.createSection(key);
                }
                EzRtpConfiguration.copySection((ConfigurationSection)value, existing);
                continue;
            }
            target.set(key, value);
        }
    }

    private static boolean isSectionPopulated(ConfigurationSection section) {
        return section != null && !section.getKeys(true).isEmpty();
    }

    public static final class GuiSettings {
        private static final int MAX_ROWS = 6;
        private final boolean enabled;
        private final Component title;
        private final int size;
        private final ItemStack fillerItem;
        private final List<GuiWorldOption> worldOptions;
        private final List<GuiServerOption> serverOptions;
        private final Component noPermissionMessage;
        private final boolean hasNoPermissionMessage;

        private GuiSettings(boolean enabled, Component title, int size, ItemStack fillerItem, List<GuiWorldOption> worldOptions, List<GuiServerOption> serverOptions, Component noPermissionMessage, boolean hasNoPermissionMessage) {
            this.enabled = enabled;
            this.title = title;
            this.size = size;
            this.fillerItem = fillerItem;
            this.worldOptions = worldOptions;
            this.serverOptions = serverOptions;
            this.noPermissionMessage = noPermissionMessage;
            this.hasNoPermissionMessage = hasNoPermissionMessage;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Component getTitle() {
            return this.title;
        }

        public int getSize() {
            return this.size;
        }

        public Optional<ItemStack> getFillerItem() {
            return Optional.ofNullable(this.fillerItem);
        }

        public List<GuiWorldOption> getWorldOptions() {
            return this.worldOptions;
        }

        public List<GuiServerOption> getServerOptions() {
            return this.serverOptions;
        }

        public Optional<Component> noPermissionMessage() {
            return this.hasNoPermissionMessage ? Optional.of(this.noPermissionMessage) : Optional.empty();
        }

        private static GuiSettings fromConfiguration(ConfigurationSection section, RandomTeleportSettings defaultSettings, NetworkConfiguration networkConfiguration, Logger logger) {
            String messageRaw;
            if (section == null) {
                return GuiSettings.disabled();
            }
            boolean enabled = section.getBoolean("enabled", false);
            String titleRaw = section.getString("title", "<gold>Select a destination</gold>");
            Object title = MINI_MESSAGE.deserialize(titleRaw == null ? "<gold>Select a destination</gold>" : titleRaw);
            int rows = Math.max(1, Math.min(6, section.getInt("rows", 1)));
            int size = rows * 9;
            ItemStack filler = GuiSettings.parseFiller(section.getConfigurationSection("filler"));
            TextComponent noPermission = null;
            boolean hasNoPermission = false;
            if (section.isString("no-permission-message") && (messageRaw = section.getString("no-permission-message", "")) != null && !messageRaw.isBlank()) {
                noPermission = (TextComponent)MINI_MESSAGE.deserialize(messageRaw);
                hasNoPermission = true;
            }
            Map<Integer, GuiWorldOption> worldOptionMap = GuiSettings.parseWorldOptions(section.getConfigurationSection("worlds"), size, defaultSettings, logger);
            ArrayList<GuiWorldOption> options = new ArrayList<GuiWorldOption>(worldOptionMap.values());
            options.sort((left, right) -> Integer.compare(left.getSlot(), right.getSlot()));
            List<GuiServerOption> serverOptions = GuiSettings.parseServerOptions(size, worldOptionMap, networkConfiguration, logger);
            return new GuiSettings(enabled, (Component)title, size, filler, Collections.unmodifiableList(options), Collections.unmodifiableList(serverOptions), hasNoPermission ? noPermission : Component.empty(), hasNoPermission);
        }

        private static GuiSettings disabled() {
            return new GuiSettings(false, Component.text("Select a destination"), 9, null, Collections.emptyList(), Collections.emptyList(), Component.empty(), false);
        }

        private static ItemStack parseFiller(ConfigurationSection section) {
            if (section == null || !section.getBoolean("enabled", false)) {
                return null;
            }
            String materialKey = section.getString("material", "GRAY_STAINED_GLASS_PANE");
            Material material = GuiSettings.parseMaterial(materialKey, Material.GRAY_STAINED_GLASS_PANE);
            ItemStack itemStack = new ItemStack(material);
            ItemMeta meta = itemStack.getItemMeta();
            String nameRaw = section.getString("name", "<gray> </gray>");
            if (nameRaw != null && !nameRaw.isBlank()) {
                Object component = MINI_MESSAGE.deserialize(nameRaw);
                try {
                    meta.getClass().getMethod("displayName", Component.class).invoke((Object)meta, component);
                }
                catch (Throwable t) {
                    meta.setDisplayName(LegacyComponentSerializer.legacySection().serialize((Component)component));
                }
            }
            if (section.contains("custom-model-data")) {
                meta.setCustomModelData(Integer.valueOf(section.getInt("custom-model-data")));
            }
            meta.addItemFlags(ItemFlag.values());
            itemStack.setItemMeta(meta);
            return itemStack;
        }

        private static Map<Integer, GuiWorldOption> parseWorldOptions(ConfigurationSection section, int size, RandomTeleportSettings defaultSettings, Logger logger) {
            LinkedHashMap<Integer, GuiWorldOption> options = new LinkedHashMap<Integer, GuiWorldOption>();
            if (section == null) {
                return options;
            }
            int nextSlot = 0;
            for (String key : section.getKeys(false)) {
                int slot;
                RandomTeleportSettings settings;
                ConfigurationSection entry = section.getConfigurationSection(key);
                if (entry == null) continue;
                ConfigurationSection settingsSection = entry.getConfigurationSection("settings");
                if (settingsSection == null) {
                    settingsSection = entry;
                }
                if ((settings = RandomTeleportSettings.fromConfiguration(settingsSection, logger, defaultSettings)) == null) continue;
                if (entry.contains("slot")) {
                    int configuredSlot = entry.getInt("slot");
                    if (configuredSlot < 0 || configuredSlot >= size) {
                        logger.warning(String.format("GUI world option '%s' uses an invalid slot '%d'. Skipping entry.", key, configuredSlot));
                        continue;
                    }
                    slot = configuredSlot;
                } else {
                    slot = nextSlot;
                }
                nextSlot = Math.min(size - 1, slot + 1);
                if (options.containsKey(slot)) {
                    logger.warning(String.format("Duplicate GUI slot '%d' detected for world option '%s'. Skipping entry.", slot, key));
                    continue;
                }
                GuiWorldOption option = new GuiWorldOption(settings, GuiSettings.parseIcon(entry.getConfigurationSection("icon"), settings), slot, entry.getString("permission", ""));
                options.put(slot, option);
            }
            return options;
        }

        private static List<GuiServerOption> parseServerOptions(int size, Map<Integer, GuiWorldOption> worldOptions, NetworkConfiguration networkConfiguration, Logger logger) {
            if (networkConfiguration == null || !networkConfiguration.isEnabled() || !networkConfiguration.isLobbyServer()) {
                return Collections.emptyList();
            }
            ArrayList<GuiServerOption> serverOptions = new ArrayList<GuiServerOption>();
            HashSet<Integer> occupiedSlots = new HashSet<Integer>(worldOptions.keySet());
            for (NetworkConfiguration.NetworkServer server : networkConfiguration.getServers()) {
                int slot = server.getSlot();
                if (slot < 0 || slot >= size) {
                    logger.warning(String.format("Network server '%s' uses an invalid slot '%d'. Skipping entry.", server.getId(), slot));
                    continue;
                }
                if (!occupiedSlots.add(slot)) {
                    logger.warning(String.format("Network server '%s' cannot use GUI slot '%d' because it is already occupied. Skipping entry.", server.getId(), slot));
                    continue;
                }
                serverOptions.add(new GuiServerOption(server));
            }
            return serverOptions;
        }

        private static ItemStack parseIcon(ConfigurationSection section, RandomTeleportSettings settings) {
            String nameRaw;
            String defaultMaterial = settings.getWorldName().equalsIgnoreCase("world_nether") ? "NETHERRACK" : (settings.getWorldName().equalsIgnoreCase("world_the_end") ? "END_STONE" : "GRASS_BLOCK");
            Material material = GuiSettings.parseMaterial(section != null ? section.getString("material") : null, GuiSettings.parseMaterial(defaultMaterial, Material.GRASS_BLOCK));
            int amount = 1;
            if (section != null) {
                amount = Math.max(1, section.getInt("amount", 1));
            }
            ItemStack stack = new ItemStack(material, amount);
            ItemMeta meta = stack.getItemMeta();
            String defaultName = "<green>" + settings.getWorldName() + "</green>";
            String string = nameRaw = section != null ? section.getString("name", defaultName) : defaultName;
            if (nameRaw != null && !nameRaw.isBlank()) {
                Object component = MINI_MESSAGE.deserialize(nameRaw);
                try {
                    meta.getClass().getMethod("displayName", Component.class).invoke((Object)meta, component);
                }
                catch (Throwable t) {
                    meta.setDisplayName(LegacyComponentSerializer.legacySection().serialize((Component)component));
                }
            }
            ArrayList lore = new ArrayList();
            if (section != null && section.isList("lore")) {
                for (String line : section.getStringList("lore")) {
                    lore.add(MINI_MESSAGE.deserialize(line));
                }
            }
            if (!lore.isEmpty()) {
                try {
                    meta.getClass().getMethod("lore", List.class).invoke((Object)meta, lore);
                }
                catch (Throwable t) {
                    ArrayList<String> legacyLore = new ArrayList<String>();
                    for (Component c : lore) {
                        legacyLore.add(LegacyComponentSerializer.legacySection().serialize(c));
                    }
                    meta.setLore(legacyLore);
                }
            }
            if (section != null && section.contains("custom-model-data")) {
                meta.setCustomModelData(Integer.valueOf(section.getInt("custom-model-data")));
            }
            meta.addItemFlags(ItemFlag.values());
            stack.setItemMeta(meta);
            return stack;
        }

        private static Material parseMaterial(String key, Material defaultMaterial) {
            if (key == null || key.isBlank()) {
                return defaultMaterial;
            }
            Material material = Material.matchMaterial((String)key.trim().toUpperCase(Locale.ROOT));
            return material != null ? material : defaultMaterial;
        }
    }

    public static class RtpLimitSettings {
        public final int cooldownSeconds;
        public final int dailyLimit;
        public final int weeklyLimit;
        public final Double cost;

        public RtpLimitSettings(int cooldownSeconds, int dailyLimit, int weeklyLimit, Double cost) {
            this.cooldownSeconds = cooldownSeconds;
            this.dailyLimit = dailyLimit;
            this.weeklyLimit = weeklyLimit;
            this.cost = cost;
        }
    }

    public static final class GuiServerOption {
        private final NetworkConfiguration.NetworkServer server;

        private GuiServerOption(NetworkConfiguration.NetworkServer server) {
            this.server = server;
        }

        public NetworkConfiguration.NetworkServer getServer() {
            return this.server;
        }
    }

    public static final class GuiWorldOption {
        private final RandomTeleportSettings settings;
        private final ItemStack iconTemplate;
        private final int slot;
        private final String permission;

        private GuiWorldOption(RandomTeleportSettings settings, ItemStack iconTemplate, int slot, String permission) {
            this.settings = settings;
            this.iconTemplate = iconTemplate;
            this.slot = slot;
            this.permission = permission == null ? "" : permission;
        }

        public RandomTeleportSettings getSettings() {
            return this.settings;
        }

        public ItemStack createIcon() {
            return this.iconTemplate.clone();
        }

        public int getSlot() {
            return this.slot;
        }

        public String getPermission() {
            return this.permission;
        }
    }
}

