/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp;

import com.skyblockexp.ezrtp.command.RandomTeleportCommand;
import com.skyblockexp.ezrtp.config.EzRtpConfiguration;
import com.skyblockexp.ezrtp.config.NetworkConfiguration;
import com.skyblockexp.ezrtp.config.RandomTeleportSettings;
import com.skyblockexp.ezrtp.economy.EconomyService;
import com.skyblockexp.ezrtp.economy.VaultEconomyService;
import com.skyblockexp.ezrtp.gui.RandomTeleportGuiManager;
import com.skyblockexp.ezrtp.libs.org.bstats.bukkit.Metrics;
import com.skyblockexp.ezrtp.listener.PlayerJoinTeleportListener;
import com.skyblockexp.ezrtp.network.NetworkService;
import com.skyblockexp.ezrtp.protection.ProtectionRegistry;
import com.skyblockexp.ezrtp.storage.MySqlRtpUsageStorage;
import com.skyblockexp.ezrtp.storage.RtpUsageStorage;
import com.skyblockexp.ezrtp.storage.YamlRtpUsageStorage;
import com.skyblockexp.ezrtp.teleport.RandomTeleportService;
import com.skyblockexp.ezrtp.update.SpigotUpdateChecker;
import java.io.File;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class EzRtpPlugin
extends JavaPlugin {
    private static final int SPIGOT_RESOURCE_ID = 129828;
    private EzRtpConfiguration configuration;
    private RandomTeleportService teleportService;
    private PlayerJoinTeleportListener joinTeleportListener;
    private RandomTeleportGuiManager guiManager;
    private EconomyService economyService = EconomyService.disabled();
    private NetworkService networkService;
    private RtpUsageStorage usageStorage;
    private ProtectionRegistry protectionRegistry;

    public void onEnable() {
        this.saveDefaultConfig();
        this.ensureAdditionalConfigFiles();
        this.setupEconomy();
        String storageType = this.getConfig().getString("rtp-limits.storage", "yaml");
        if (storageType.equalsIgnoreCase("mysql")) {
            String url = this.getConfig().getString("rtp-limits.mysql.url", "jdbc:mysql://localhost:3306/mc");
            String user = this.getConfig().getString("rtp-limits.mysql.user", "root");
            String pass = this.getConfig().getString("rtp-limits.mysql.password", "");
            this.usageStorage = new MySqlRtpUsageStorage(url, user, pass);
        } else {
            this.usageStorage = new YamlRtpUsageStorage(new File(this.getDataFolder(), "rtp-usage.yml"));
        }
        this.reloadPluginConfiguration();
        this.scheduleUsageResets();
        this.registerListeners();
        this.registerCommand();
        this.initializeMetrics();
        new SpigotUpdateChecker(this, 129828).checkForUpdates();
        this.getLogger().info("EzRTP plugin enabled.");
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        if (this.networkService != null) {
            this.networkService.shutdown();
            this.networkService = null;
        }
        this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.getLogger().info("EzRTP plugin disabled.");
    }

    public void reloadPluginConfiguration() {
        this.ensureAdditionalConfigFiles();
        this.reloadConfig();
        FileConfiguration messagesConfiguration = this.loadExternalConfiguration("messages.yml");
        FileConfiguration guiConfiguration = this.loadExternalConfiguration("gui.yml");
        FileConfiguration queueConfiguration = this.loadExternalConfiguration("queue.yml");
        FileConfiguration networkConfiguration = this.loadExternalConfiguration("network.yml");
        ConfigurationSection fallbackMessages = this.getConfig().getConfigurationSection("messages");
        ConfigurationSection fallbackGui = this.getConfig().getConfigurationSection("gui");
        ConfigurationSection fallbackQueue = this.getConfig().getConfigurationSection("queue");
        ConfigurationSection fallbackNetwork = this.getConfig().getConfigurationSection("network");
        this.configuration = EzRtpConfiguration.fromConfigurations((ConfigurationSection)this.getConfig(), this.selectSection(messagesConfiguration, "messages", fallbackMessages), this.selectSection(guiConfiguration, "gui", fallbackGui), this.selectSection(queueConfiguration, "queue", fallbackQueue), this.selectSection(networkConfiguration, "network", fallbackNetwork), this.getLogger());
        RandomTeleportSettings defaultSettings = this.configuration.getDefaultSettings();
        if (this.protectionRegistry == null) {
            this.protectionRegistry = new ProtectionRegistry(this);
        }
        this.protectionRegistry.warnMissingProviders(defaultSettings.getProtectionSettings());
        if (this.teleportService == null) {
            this.teleportService = new RandomTeleportService(this, defaultSettings, this.configuration.getQueueSettings(), this.economyService, (player, settings) -> this.configuration.resolveTeleportCost((Player)player, (RandomTeleportSettings)settings), this.protectionRegistry);
        } else {
            this.teleportService.reload(defaultSettings, this.configuration.getQueueSettings());
            this.teleportService.setEconomyService(this.economyService);
            this.teleportService.setCostResolver((player, settings) -> this.configuration.resolveTeleportCost((Player)player, (RandomTeleportSettings)settings));
            this.teleportService.setProtectionRegistry(this.protectionRegistry);
        }
        this.reloadNetworkService();
        if (this.guiManager != null) {
            this.guiManager.closeAll();
        }
        this.validateEconomyConfiguration(this.configuration);
    }

    private void ensureAdditionalConfigFiles() {
        this.saveResourceIfMissing("messages.yml");
        this.saveResourceIfMissing("gui.yml");
        this.saveResourceIfMissing("queue.yml");
        this.saveResourceIfMissing("network.yml");
    }

    private void saveResourceIfMissing(String resource) {
        File target = new File(this.getDataFolder(), resource);
        if (target.exists()) {
            return;
        }
        try {
            this.saveResource(resource, false);
        }
        catch (IllegalArgumentException exception) {
            this.getLogger().warning("Unable to save default resource '" + resource + "': " + exception.getMessage());
        }
    }

    private FileConfiguration loadExternalConfiguration(String fileName) {
        File file = new File(this.getDataFolder(), fileName);
        if (!file.exists()) {
            this.saveResourceIfMissing(fileName);
        }
        if (!file.exists()) {
            return null;
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private ConfigurationSection selectSection(FileConfiguration configuration, String nestedKey, ConfigurationSection fallback) {
        ConfigurationSection section = null;
        if (configuration != null) {
            if (nestedKey != null && configuration.isConfigurationSection(nestedKey)) {
                section = configuration.getConfigurationSection(nestedKey);
            }
            if (section == null && !configuration.getKeys(false).isEmpty()) {
                section = configuration;
            }
        }
        if (section != null && !section.getKeys(true).isEmpty()) {
            return section;
        }
        if (fallback != null && !fallback.getKeys(true).isEmpty()) {
            return fallback;
        }
        return null;
    }

    private void registerCommand() {
        RandomTeleportCommand command = new RandomTeleportCommand(this, () -> this.teleportService, () -> this.configuration, this.guiManager, this.usageStorage);
        PluginCommand pluginCommand = Objects.requireNonNull(this.getCommand("rtp"), "rtp command not defined in plugin.yml");
        pluginCommand.setExecutor((CommandExecutor)command);
        pluginCommand.setTabCompleter((TabCompleter)command);
    }

    private void scheduleUsageResets() {
        long ticksPerDay = 1728000L;
        long ticksUntilMidnight = this.getTicksUntilNext(0, 0);
        this.getServer().getScheduler().runTaskTimer((Plugin)this, this::resetDailyUsage, ticksUntilMidnight, ticksPerDay);
        long ticksPerWeek = 12096000L;
        long ticksUntilSunday = this.getTicksUntilNextSundayMidnight();
        this.getServer().getScheduler().runTaskTimer((Plugin)this, this::resetWeeklyUsage, ticksUntilSunday, ticksPerWeek);
    }

    private void resetDailyUsage() {
        try {
            this.usageStorage.resetUsage(null, null, "daily");
            this.usageStorage.save();
            this.getLogger().info("[EzRTP] Daily RTP usage counts reset.");
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "[EzRTP] Failed to reset daily RTP usage counts", e);
        }
    }

    private void resetWeeklyUsage() {
        try {
            this.usageStorage.resetUsage(null, null, "weekly");
            this.usageStorage.save();
            this.getLogger().info("[EzRTP] Weekly RTP usage counts reset.");
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "[EzRTP] Failed to reset weekly RTP usage counts", e);
        }
    }

    private long getTicksUntilNext(int hour, int minute) {
        ZonedDateTime now = ZonedDateTime.now(ZoneId.systemDefault());
        ZonedDateTime next = now.withHour(hour).withMinute(minute).withSecond(0).withNano(0);
        if (!next.isAfter(now)) {
            next = next.plusDays(1L);
        }
        long seconds = Duration.between(now, next).getSeconds();
        return seconds * 20L;
    }

    private long getTicksUntilNextSundayMidnight() {
        ZonedDateTime now = ZonedDateTime.now(ZoneId.systemDefault());
        ZonedDateTime next = now.with(DayOfWeek.SUNDAY).withHour(0).withMinute(0).withSecond(0).withNano(0);
        if (!next.isAfter(now)) {
            next = next.plusWeeks(1L);
        }
        long seconds = Duration.between(now, next).getSeconds();
        return seconds * 20L;
    }

    private void registerListeners() {
        this.joinTeleportListener = new PlayerJoinTeleportListener(this, () -> this.teleportService, () -> this.configuration != null ? this.configuration.getDefaultSettings() : null);
        this.guiManager = new RandomTeleportGuiManager(this, () -> this.teleportService, () -> this.configuration, () -> this.networkService);
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)this.joinTeleportListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.guiManager, (Plugin)this);
    }

    private void initializeMetrics() {
        try {
            new Metrics(this, 27735);
        }
        catch (Throwable throwable) {
            this.getLogger().warning("Failed to start bStats metrics: " + throwable.getMessage());
        }
    }

    private void setupEconomy() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (!pluginManager.isPluginEnabled("Vault")) {
            this.economyService = EconomyService.disabled();
            this.getLogger().info("Vault not found. Random teleport costs will be disabled.");
            return;
        }
        RegisteredServiceProvider registration = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (registration == null || registration.getProvider() == null) {
            this.economyService = EconomyService.disabled();
            this.getLogger().warning("Vault is installed but no economy provider is registered. Random teleport costs will be disabled.");
            return;
        }
        VaultEconomyService vaultEconomy = new VaultEconomyService((Economy)registration.getProvider(), this.getLogger());
        this.economyService = vaultEconomy;
        this.getLogger().info("Using Vault economy provider: " + vaultEconomy.getProviderName());
    }

    private void validateEconomyConfiguration(EzRtpConfiguration configuration) {
        if (this.economyService.isEnabled()) {
            return;
        }
        boolean requiresEconomy = false;
        RandomTeleportSettings defaultSettings = configuration.getDefaultSettings();
        if (defaultSettings != null && defaultSettings.getTeleportCost() > 0.0) {
            requiresEconomy = true;
        }
        if (!requiresEconomy && configuration.getGuiSettings() != null) {
            requiresEconomy = configuration.getGuiSettings().getWorldOptions().stream().anyMatch(option -> option.getSettings() != null && option.getSettings().getTeleportCost() > 0.0);
        }
        if (requiresEconomy) {
            this.getLogger().warning("Teleport costs are configured but Vault is unavailable. Teleports will not deduct currency.");
        }
    }

    private void reloadNetworkService() {
        NetworkConfiguration networkConfiguration;
        if (this.networkService != null) {
            this.networkService.shutdown();
            this.networkService = null;
        }
        if ((networkConfiguration = this.configuration.getNetworkConfiguration()) != null && networkConfiguration.isEnabled() && networkConfiguration.isLobbyServer()) {
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            this.networkService = new NetworkService(this, networkConfiguration, this.getLogger());
        } else {
            this.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this, "BungeeCord");
            this.networkService = null;
        }
    }
}

