/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.update;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SpigotUpdateChecker {
    private static final String UPDATE_ENDPOINT = "https://api.spigotmc.org/legacy/update.php?resource=";
    private final JavaPlugin plugin;
    private final int resourceId;

    public SpigotUpdateChecker(JavaPlugin plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public void checkForUpdates() {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String latestVersion = this.fetchLatestVersion();
                if (latestVersion == null || latestVersion.isBlank()) {
                    this.plugin.getLogger().warning("SpigotMC update check returned an empty response.");
                    return;
                }
                String currentVersion = this.plugin.getDescription().getVersion();
                if (!latestVersion.equalsIgnoreCase(currentVersion)) {
                    this.plugin.getLogger().info("A new EzRTP version is available: " + latestVersion + " (current: " + currentVersion + "). Download: https://www.spigotmc.org/resources/" + this.resourceId + "/");
                } else {
                    this.plugin.getLogger().info("EzRTP is up to date.");
                }
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to check for EzRTP updates: " + ex.getMessage());
            }
        });
    }

    private String fetchLatestVersion() throws Exception {
        URL url = new URL(UPDATE_ENDPOINT + this.resourceId);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestProperty("User-Agent", "EzRTP Update Checker");
        try {
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                string = reader.readLine();
            }
            return string;
        }
        finally {
            connection.disconnect();
        }
    }
}

