/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.listener;

import com.skyblockexp.ezrtp.config.OnJoinTeleportSettings;
import com.skyblockexp.ezrtp.config.RandomTeleportSettings;
import com.skyblockexp.ezrtp.teleport.RandomTeleportService;
import com.skyblockexp.ezrtp.teleport.TeleportReason;
import java.util.Objects;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PlayerJoinTeleportListener
implements Listener {
    private final JavaPlugin plugin;
    private final Supplier<RandomTeleportService> teleportServiceSupplier;
    private final Supplier<RandomTeleportSettings> settingsSupplier;

    public PlayerJoinTeleportListener(JavaPlugin plugin, Supplier<RandomTeleportService> teleportServiceSupplier, Supplier<RandomTeleportSettings> settingsSupplier) {
        this.plugin = plugin;
        this.teleportServiceSupplier = teleportServiceSupplier;
        this.settingsSupplier = settingsSupplier;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        RandomTeleportSettings settings = this.settingsSupplier.get();
        if (settings == null) {
            return;
        }
        OnJoinTeleportSettings onJoin = settings.getOnJoinTeleportSettings();
        if (!onJoin.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (onJoin.onlyFirstJoin() && player.hasPlayedBefore()) {
            return;
        }
        if (!onJoin.bypassPermission().isEmpty() && player.hasPermission(onJoin.bypassPermission())) {
            return;
        }
        RandomTeleportService service = Objects.requireNonNull(this.teleportServiceSupplier.get(), "Teleport service not initialised");
        long delay = Math.max(0L, onJoin.delayTicks());
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> service.teleportPlayer(player, TeleportReason.JOIN), delay);
    }

    public void updateSettings(RandomTeleportSettings newSettings) {
    }
}

