/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.config;

import com.skyblockexp.ezrtp.config.CountdownBossBarSettings;
import com.skyblockexp.ezrtp.config.CountdownParticleSettings;
import com.skyblockexp.ezrtp.config.OnJoinTeleportSettings;
import com.skyblockexp.ezrtp.config.ParticleSettings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;

public final class RandomTeleportSettings {
    private final ConfigurationSection configSection;
    private final String worldName;
    private final int centerX;
    private final int centerZ;
    private final int minimumRadius;
    private final int maximumRadius;
    private final int maxAttempts;
    private final boolean useWorldBorderRadius;
    private final Set<Material> unsafeBlocks;
    private final TeleportMessages messages;
    private final ParticleSettings particleSettings;
    private final OnJoinTeleportSettings onJoinTeleportSettings;
    private final CountdownBossBarSettings countdownBossBarSettings;
    private final CountdownParticleSettings countdownParticleSettings;
    private final double teleportCost;
    private final int countdownSeconds;
    private final boolean debugRejectionLogging;
    private final Integer minY;
    private final Integer maxY;

    public RandomTeleportSettings(ConfigurationSection configSection, String worldName, int centerX, int centerZ, int minimumRadius, int maximumRadius, int maxAttempts, boolean useWorldBorderRadius, Set<Material> unsafeBlocks, TeleportMessages messages, ParticleSettings particleSettings, OnJoinTeleportSettings onJoinTeleportSettings, CountdownBossBarSettings countdownBossBarSettings, CountdownParticleSettings countdownParticleSettings, double teleportCost, int countdownSeconds, boolean debugRejectionLogging, Integer minY, Integer maxY) {
        this.configSection = configSection;
        this.worldName = worldName;
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.minimumRadius = minimumRadius;
        this.maximumRadius = maximumRadius;
        this.maxAttempts = maxAttempts;
        this.useWorldBorderRadius = useWorldBorderRadius;
        this.unsafeBlocks = unsafeBlocks;
        this.messages = messages;
        this.particleSettings = particleSettings;
        this.onJoinTeleportSettings = onJoinTeleportSettings;
        this.countdownBossBarSettings = countdownBossBarSettings;
        this.countdownParticleSettings = countdownParticleSettings;
        this.teleportCost = teleportCost;
        this.countdownSeconds = countdownSeconds;
        this.debugRejectionLogging = debugRejectionLogging;
        this.minY = minY;
        this.maxY = maxY;
    }

    public Integer getMinY() {
        return this.minY;
    }

    public Integer getMaxY() {
        return this.maxY;
    }

    public boolean isDebugRejectionLoggingEnabled() {
        return this.debugRejectionLogging;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterZ() {
        return this.centerZ;
    }

    public int getMinimumRadius() {
        return this.minimumRadius;
    }

    public int getMaximumRadius() {
        return this.maximumRadius;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public boolean useWorldBorderRadius() {
        return this.useWorldBorderRadius;
    }

    public Set<Material> getUnsafeBlocks() {
        return this.unsafeBlocks;
    }

    public TeleportMessages getMessages() {
        return this.messages;
    }

    public ParticleSettings getParticleSettings() {
        return this.particleSettings;
    }

    public OnJoinTeleportSettings getOnJoinTeleportSettings() {
        return this.onJoinTeleportSettings;
    }

    public CountdownBossBarSettings getCountdownBossBarSettings() {
        return this.countdownBossBarSettings;
    }

    public CountdownParticleSettings getCountdownParticleSettings() {
        return this.countdownParticleSettings;
    }

    public double getTeleportCost() {
        return this.teleportCost;
    }

    public ConfigurationSection getConfigSection() {
        return this.configSection;
    }

    public static RandomTeleportSettings fromConfiguration(ConfigurationSection section, Logger logger) {
        if (section == null) {
            return new RandomTeleportSettings(null, "world", 0, 0, 100, 1000, 10, false, Collections.emptySet(), TeleportMessages.defaultMessages(), new ParticleSettings(false, Particle.PORTAL, 40, 0.5, 1.0, 0.5, 0.0, false), new OnJoinTeleportSettings(false, false, "", 20L), CountdownBossBarSettings.disabled(), CountdownParticleSettings.disabled(), 0.0, 0, false, null, null);
        }
        String worldName = section.getString("world", "world");
        int centerX = 0;
        int centerZ = 0;
        if (section.isConfigurationSection("center")) {
            ConfigurationSection center = section.getConfigurationSection("center");
            centerX = center.getInt("x", 0);
            centerZ = center.getInt("z", 0);
        }
        int minRadius = 100;
        int maxRadius = 1000;
        boolean useWorldBorder = false;
        if (section.isConfigurationSection("radius")) {
            ConfigurationSection radius = section.getConfigurationSection("radius");
            minRadius = radius.getInt("min", 100);
            maxRadius = radius.contains("max") ? radius.getInt("max") : 1000;
            useWorldBorder = radius.getBoolean("use-world-border", false);
        }
        int maxAttempts = section.getInt("max-attempts", 10);
        double teleportCost = section.getDouble("cost", 0.0);
        ConfigurationSection countdownSection = section.getConfigurationSection("countdown");
        int countdownSeconds = countdownSection != null ? countdownSection.getInt("seconds", section.getInt("countdown-seconds", 0)) : section.getInt("countdown-seconds", 0);
        boolean debugRejectionLogging = section.getBoolean("debug-rejection-logging", false);
        Integer minY = section.contains("min-y") ? Integer.valueOf(section.getInt("min-y")) : null;
        Integer maxY = section.contains("max-y") ? Integer.valueOf(section.getInt("max-y")) : null;
        HashSet<Material> unsafeBlocks = new HashSet<Material>();
        if (section.isList("unsafe-blocks")) {
            for (Object o : section.getList("unsafe-blocks")) {
                if (!(o instanceof String)) continue;
                String s = (String)o;
                try {
                    unsafeBlocks.add(Material.valueOf((String)s.toUpperCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        TeleportMessages messages = TeleportMessages.fromConfiguration(section.getConfigurationSection("messages"));
        ParticleSettings particleSettings = ParticleSettings.fromConfiguration(section.getConfigurationSection("particles"), logger, ParticleSettings.disabled());
        OnJoinTeleportSettings onJoinTeleportSettings = OnJoinTeleportSettings.fromConfiguration(section.getConfigurationSection("on-join"));
        CountdownBossBarSettings countdownBossBarSettings = CountdownBossBarSettings.fromConfiguration(countdownSection != null ? countdownSection.getConfigurationSection("bossbar") : null, logger);
        CountdownParticleSettings countdownParticleSettings = CountdownParticleSettings.fromConfiguration(countdownSection != null ? countdownSection.getConfigurationSection("particles") : null, logger);
        return new RandomTeleportSettings(section, worldName, centerX, centerZ, minRadius, maxRadius, maxAttempts, useWorldBorder, unsafeBlocks, messages, particleSettings, onJoinTeleportSettings, countdownBossBarSettings, countdownParticleSettings, teleportCost, countdownSeconds, debugRejectionLogging, minY, maxY);
    }

    public static RandomTeleportSettings fromConfiguration(ConfigurationSection section, Logger logger, RandomTeleportSettings fallback) {
        CountdownBossBarSettings countdownBossBarSettings;
        OnJoinTeleportSettings onJoinTeleportSettings;
        Integer minY;
        boolean useWorldBorder;
        int centerZ;
        if (section == null) {
            return fallback != null ? fallback : RandomTeleportSettings.fromConfiguration(section, logger);
        }
        String worldName = section.getString("world", fallback != null ? fallback.getWorldName() : "world");
        int centerX = fallback != null ? fallback.getCenterX() : 0;
        int n = centerZ = fallback != null ? fallback.getCenterZ() : 0;
        if (section.isConfigurationSection("center")) {
            ConfigurationSection center = section.getConfigurationSection("center");
            centerX = center.getInt("x", centerX);
            centerZ = center.getInt("z", centerZ);
        }
        int minRadius = fallback != null ? fallback.getMinimumRadius() : 100;
        int maxRadius = fallback != null ? fallback.getMaximumRadius() : 1000;
        boolean bl = useWorldBorder = fallback != null && fallback.useWorldBorderRadius();
        if (section.isConfigurationSection("radius")) {
            ConfigurationSection radius = section.getConfigurationSection("radius");
            minRadius = radius.getInt("min", minRadius);
            maxRadius = radius.contains("max") ? radius.getInt("max") : maxRadius;
            useWorldBorder = radius.getBoolean("use-world-border", useWorldBorder);
        }
        int maxAttempts = section.getInt("max-attempts", fallback != null ? fallback.getMaxAttempts() : 10);
        double teleportCost = section.getDouble("cost", fallback != null ? fallback.getTeleportCost() : 0.0);
        ConfigurationSection countdownSection = section.getConfigurationSection("countdown");
        int countdownSeconds = countdownSection != null ? countdownSection.getInt("seconds", section.getInt("countdown-seconds", fallback != null ? fallback.getCountdownSeconds() : 0)) : section.getInt("countdown-seconds", fallback != null ? fallback.getCountdownSeconds() : 0);
        boolean debugRejectionLogging = section.getBoolean("debug-rejection-logging", fallback != null && fallback.isDebugRejectionLoggingEnabled());
        Integer n2 = section.contains("min-y") ? Integer.valueOf(section.getInt("min-y")) : (minY = fallback != null ? fallback.getMinY() : null);
        Integer maxY = section.contains("max-y") ? Integer.valueOf(section.getInt("max-y")) : (fallback != null ? fallback.getMaxY() : null);
        HashSet<Material> unsafeBlocks = new HashSet<Material>();
        if (section.isList("unsafe-blocks")) {
            for (Object o : section.getList("unsafe-blocks")) {
                if (!(o instanceof String)) continue;
                String s = (String)o;
                try {
                    unsafeBlocks.add(Material.valueOf((String)s.toUpperCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else if (fallback != null) {
            unsafeBlocks.addAll(fallback.getUnsafeBlocks());
        }
        TeleportMessages messages = section.isConfigurationSection("messages") ? TeleportMessages.fromConfiguration(section.getConfigurationSection("messages")) : (fallback != null ? fallback.getMessages() : TeleportMessages.defaultMessages());
        ParticleSettings particleSettings = ParticleSettings.fromConfiguration(section.getConfigurationSection("particles"), logger, fallback != null ? fallback.getParticleSettings() : ParticleSettings.disabled());
        OnJoinTeleportSettings onJoinTeleportSettings2 = section.isConfigurationSection("on-join") ? OnJoinTeleportSettings.fromConfiguration(section.getConfigurationSection("on-join")) : (onJoinTeleportSettings = fallback != null ? fallback.getOnJoinTeleportSettings() : OnJoinTeleportSettings.fromConfiguration(null));
        CountdownBossBarSettings countdownBossBarSettings2 = countdownSection != null ? CountdownBossBarSettings.fromConfiguration(countdownSection.getConfigurationSection("bossbar"), logger) : (countdownBossBarSettings = fallback != null ? fallback.getCountdownBossBarSettings() : CountdownBossBarSettings.disabled());
        CountdownParticleSettings countdownParticleSettings = countdownSection != null ? CountdownParticleSettings.fromConfiguration(countdownSection.getConfigurationSection("particles"), logger) : (fallback != null ? fallback.getCountdownParticleSettings() : CountdownParticleSettings.disabled());
        return new RandomTeleportSettings(section, worldName, centerX, centerZ, minRadius, maxRadius, maxAttempts, useWorldBorder, unsafeBlocks, messages, particleSettings, onJoinTeleportSettings, countdownBossBarSettings, countdownParticleSettings, teleportCost, countdownSeconds, debugRejectionLogging, minY, maxY);
    }

    public int getCountdownSeconds() {
        return this.countdownSeconds;
    }

    public static final class TeleportMessages {
        private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
        private final String teleporting;
        private final String teleportSuccess;
        private final String teleportFailure;
        private final String worldMissing;
        private final String joinSearching;
        private final String queueQueued;
        private final String queueFull;
        private final String insufficientFunds;
        private final String countdownStart;
        private final String countdownTick;

        public TeleportMessages(String teleporting, String teleportSuccess, String teleportFailure, String worldMissing, String joinSearching, String queueQueued, String queueFull, String insufficientFunds, String countdownStart, String countdownTick) {
            this.teleporting = teleporting;
            this.teleportSuccess = teleportSuccess;
            this.teleportFailure = teleportFailure;
            this.worldMissing = worldMissing;
            this.joinSearching = joinSearching;
            this.queueQueued = queueQueued;
            this.queueFull = queueFull;
            this.insufficientFunds = insufficientFunds;
            this.countdownStart = countdownStart;
            this.countdownTick = countdownTick;
        }

        public Component teleporting() {
            return MINI_MESSAGE.deserialize(this.teleporting);
        }

        public Component teleportSuccess(int x, int z, String world) {
            return MINI_MESSAGE.deserialize(this.teleportSuccess, Placeholder.parsed("x", Integer.toString(x)), Placeholder.parsed("z", Integer.toString(z)), Placeholder.parsed("world", world));
        }

        public Component teleportFailure() {
            return MINI_MESSAGE.deserialize(this.teleportFailure);
        }

        public Component worldMissing(String world) {
            return MINI_MESSAGE.deserialize(this.worldMissing, (TagResolver)Placeholder.parsed("world", world));
        }

        public Component joinSearching() {
            return MINI_MESSAGE.deserialize(this.joinSearching);
        }

        public Component queued(int position) {
            return MINI_MESSAGE.deserialize(this.queueQueued, (TagResolver)Placeholder.parsed("position", Integer.toString(Math.max(position, 1))));
        }

        public Component queueFull(int maxSize) {
            return MINI_MESSAGE.deserialize(this.queueFull, (TagResolver)Placeholder.parsed("size", Integer.toString(Math.max(maxSize, 0))));
        }

        public Component insufficientFunds(double cost) {
            return MINI_MESSAGE.deserialize(this.insufficientFunds, (TagResolver)Placeholder.parsed("cost", String.format(Locale.US, "%.2f", Math.max(cost, 0.0))));
        }

        public Component countdownStart(int seconds) {
            return MINI_MESSAGE.deserialize(this.countdownStart != null ? this.countdownStart : "<yellow>Teleporting in <white><seconds></white> seconds...</yellow>", (TagResolver)Placeholder.parsed("seconds", Integer.toString(seconds)));
        }

        public Component countdownTick(int seconds) {
            return MINI_MESSAGE.deserialize(this.countdownTick != null ? this.countdownTick : "<gray><seconds>...</gray>", (TagResolver)Placeholder.parsed("seconds", Integer.toString(seconds)));
        }

        public static TeleportMessages fromConfiguration(ConfigurationSection section) {
            if (section == null) {
                return TeleportMessages.defaultMessages();
            }
            return new TeleportMessages(section.getString("teleporting", "<gray>Searching for a safe location...</gray>"), section.getString("teleport-success", "<green>Teleported to <white><x></white>, <white><z></white> in <white><world></white>.</green>"), section.getString("teleport-failed", "<red>Unable to find a safe location. Please try again.</red>"), section.getString("world-missing", "<red>The configured world '<white><world></white>' is not available.</red>"), section.getString("join-searching", "<gray>Finding you a safe place to explore...</gray>"), section.getString("queue-queued", "<gray>You joined the random teleport queue. Position: <white><position></white>.</gray>"), section.getString("queue-full", "<red>The random teleport queue is currently full. Please try again soon.</red>"), section.getString("insufficient-funds", "<red>You need <white><cost></white> to use random teleport.</red>"), section.getString("countdown-start", "<yellow>Teleporting in <white><seconds></white> seconds...</yellow>"), section.getString("countdown-tick", "<gray><seconds>...</gray>"));
        }

        public static TeleportMessages defaultMessages() {
            return new TeleportMessages("<gray>Searching for a safe location...</gray>", "<green>Teleported to <white><x></white>, <white><z></white> in <white><world></white>.</green>", "<red>Unable to find a safe location. Please try again.</red>", "<red>The configured world '<white><world></white>' is not available.</red>", "<gray>Finding you a safe place to explore...</gray>", "<gray>You joined the random teleport queue. Position: <white><position></white>.</gray>", "<red>The random teleport queue is currently full. Please try again soon.</red>", "<red>You need <white><cost></white> to use random teleport.</red>", "<yellow>Teleporting in <white><seconds></white> seconds...</yellow>", "<gray><seconds>...</gray>");
        }
    }
}

