/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class NetworkConfiguration {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final boolean enabled;
    private final boolean lobbyServer;
    private final long pingIntervalTicks;
    private final int pingTimeoutMillis;
    private final List<NetworkServer> servers;

    private NetworkConfiguration(boolean enabled, boolean lobbyServer, long pingIntervalTicks, int pingTimeoutMillis, List<NetworkServer> servers) {
        this.enabled = enabled;
        this.lobbyServer = lobbyServer;
        this.pingIntervalTicks = pingIntervalTicks;
        this.pingTimeoutMillis = pingTimeoutMillis;
        this.servers = servers;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLobbyServer() {
        return this.lobbyServer;
    }

    public long getPingIntervalTicks() {
        return this.pingIntervalTicks;
    }

    public int getPingTimeoutMillis() {
        return this.pingTimeoutMillis;
    }

    public List<NetworkServer> getServers() {
        return this.servers;
    }

    public static NetworkConfiguration disabled() {
        return new NetworkConfiguration(false, false, 200L, 1500, Collections.emptyList());
    }

    public static NetworkConfiguration fromConfiguration(ConfigurationSection section, Logger logger) {
        if (section == null) {
            return NetworkConfiguration.disabled();
        }
        boolean enabled = section.getBoolean("enabled", false);
        boolean lobbyServer = section.getBoolean("lobby", false);
        long pingInterval = Math.max(20L, section.getLong("ping-interval-ticks", 200L));
        int pingTimeout = Math.max(250, section.getInt("ping-timeout-millis", 1500));
        List<NetworkServer> servers = NetworkConfiguration.parseServers(section.getConfigurationSection("servers"), logger);
        return new NetworkConfiguration(enabled, lobbyServer, pingInterval, pingTimeout, Collections.unmodifiableList(servers));
    }

    private static List<NetworkServer> parseServers(ConfigurationSection section, Logger logger) {
        if (section == null) {
            return Collections.emptyList();
        }
        ArrayList<NetworkServer> servers = new ArrayList<NetworkServer>();
        int nextSlot = 0;
        for (String key : section.getKeys(false)) {
            ConfigurationSection entry = section.getConfigurationSection(key);
            if (entry == null) continue;
            String bungeeName = entry.getString("bungee-server", key);
            if (bungeeName == null || bungeeName.isBlank()) {
                logger.warning(String.format("Network server '%s' is missing a valid 'bungee-server' identifier.", key));
                continue;
            }
            String host = entry.getString("host", "127.0.0.1");
            int port = entry.getInt("port", 25565);
            if (port <= 0 || port > 65535) {
                logger.warning(String.format("Network server '%s' specifies an invalid port '%d'.", key, port));
                continue;
            }
            int slot = entry.contains("slot") ? entry.getInt("slot") : nextSlot;
            nextSlot = Math.min(53, slot + 1);
            String permission = entry.getString("permission", "");
            String displayName = entry.getString("display-name", key);
            boolean hideWhenOffline = entry.getBoolean("hide-when-offline", false);
            boolean allowWhenOffline = entry.getBoolean("allow-when-offline", false);
            String connectMessageRaw = entry.getString("connect-message", "<gray>Connecting you to <white><server></white>...</gray>");
            TextComponent connectMessage = connectMessageRaw == null || connectMessageRaw.isBlank() ? Component.empty() : MINI_MESSAGE.deserialize(connectMessageRaw, (TagResolver)Placeholder.unparsed("server", displayName));
            String offlineMessageRaw = entry.getString("offline-message", "<red><server></red> is currently unavailable.");
            TextComponent offlineMessage = offlineMessageRaw == null || offlineMessageRaw.isBlank() ? Component.empty() : MINI_MESSAGE.deserialize(offlineMessageRaw, (TagResolver)Placeholder.unparsed("server", displayName));
            IconTemplate iconTemplate = IconTemplate.fromConfiguration(entry.getConfigurationSection("icon"), displayName);
            if (iconTemplate == null) {
                logger.warning(String.format("Network server '%s' has an invalid icon configuration.", key));
                continue;
            }
            NetworkServer server = new NetworkServer(key, bungeeName, host, port, permission == null ? "" : permission, slot, displayName, hideWhenOffline, allowWhenOffline, connectMessage, offlineMessage, iconTemplate);
            servers.add(server);
        }
        return servers;
    }

    public static final class IconTemplate {
        private final Material material;
        private final int amount;
        private final Integer customModelData;
        private final String displayName;
        private final List<String> loreLines;

        private IconTemplate(Material material, int amount, Integer customModelData, String displayName, List<String> loreLines) {
            this.material = material;
            this.amount = amount;
            this.customModelData = customModelData;
            this.displayName = displayName;
            this.loreLines = loreLines;
        }

        public ItemStack createIcon(ServerStatusSnapshot status, String displayName) {
            boolean hasProvidedName;
            ItemStack itemStack = new ItemStack(this.material, this.amount);
            ItemMeta meta = itemStack.getItemMeta();
            String providedDisplayName = displayName != null ? displayName : "";
            String templateDisplayName = this.displayName != null ? this.displayName : "";
            TagResolver resolver = TagResolver.builder().resolvers(Placeholder.unparsed("server", providedDisplayName), Placeholder.unparsed("ping", status.pingDisplay()), Placeholder.parsed("status", status.statusMiniMessage())).build();
            boolean hasTemplateName = !templateDisplayName.isBlank();
            boolean bl = hasProvidedName = !providedDisplayName.isBlank();
            if (hasTemplateName || hasProvidedName) {
                String name = hasTemplateName ? templateDisplayName : providedDisplayName;
                Component component = MINI_MESSAGE.deserialize(name, resolver);
                try {
                    meta.getClass().getMethod("displayName", Component.class).invoke((Object)meta, component);
                }
                catch (Throwable t) {
                    try {
                        meta.getClass().getMethod("setDisplayName", String.class).invoke((Object)meta, LegacyComponentSerializer.legacySection().serialize(component));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (!this.loreLines.isEmpty()) {
                ArrayList<Component> lore = new ArrayList<Component>(this.loreLines.size());
                for (String line : this.loreLines) {
                    lore.add(MINI_MESSAGE.deserialize(line, resolver));
                }
                try {
                    meta.getClass().getMethod("lore", List.class).invoke((Object)meta, lore);
                }
                catch (Throwable t) {
                    ArrayList<String> legacyLore = new ArrayList<String>();
                    for (Component c : lore) {
                        legacyLore.add(LegacyComponentSerializer.legacySection().serialize(c));
                    }
                    try {
                        meta.getClass().getMethod("setLore", List.class).invoke((Object)meta, legacyLore);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (this.customModelData != null) {
                meta.setCustomModelData(this.customModelData);
            }
            meta.addItemFlags(ItemFlag.values());
            itemStack.setItemMeta(meta);
            return itemStack;
        }

        private static IconTemplate fromConfiguration(ConfigurationSection section, String displayName) {
            if (section == null) {
                return null;
            }
            String materialKey = section.getString("material", "ENDER_PEARL");
            Material material = IconTemplate.parseMaterial(materialKey, Material.ENDER_PEARL);
            int amount = Math.max(1, section.getInt("amount", 1));
            Integer customModelData = section.contains("custom-model-data") ? Integer.valueOf(section.getInt("custom-model-data")) : null;
            String name = section.getString("name", "<green><server></green>");
            List lore = section.isList("lore") ? section.getStringList("lore") : Collections.emptyList();
            return new IconTemplate(material, amount, customModelData, name, lore);
        }

        private static Material parseMaterial(String key, Material defaultMaterial) {
            if (key == null || key.isBlank()) {
                return defaultMaterial;
            }
            Material material = Material.matchMaterial((String)key.trim().toUpperCase(Locale.ROOT));
            return material != null ? material : defaultMaterial;
        }
    }

    public static final class NetworkServer {
        private final String id;
        private final String bungeeServer;
        private final String host;
        private final int port;
        private final String permission;
        private final int slot;
        private final String displayName;
        private final boolean hideWhenOffline;
        private final boolean allowWhenOffline;
        private final Component connectMessage;
        private final Component offlineMessage;
        private final IconTemplate iconTemplate;

        private NetworkServer(String id, String bungeeServer, String host, int port, String permission, int slot, String displayName, boolean hideWhenOffline, boolean allowWhenOffline, Component connectMessage, Component offlineMessage, IconTemplate iconTemplate) {
            this.id = id;
            this.bungeeServer = bungeeServer;
            this.host = host;
            this.port = port;
            this.permission = permission;
            this.slot = slot;
            this.displayName = displayName;
            this.hideWhenOffline = hideWhenOffline;
            this.allowWhenOffline = allowWhenOffline;
            this.connectMessage = connectMessage;
            this.offlineMessage = offlineMessage;
            this.iconTemplate = iconTemplate;
        }

        public String getId() {
            return this.id;
        }

        public String getBungeeServer() {
            return this.bungeeServer;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getPermission() {
            return this.permission;
        }

        public int getSlot() {
            return this.slot;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean hideWhenOffline() {
            return this.hideWhenOffline;
        }

        public boolean allowWhenOffline() {
            return this.allowWhenOffline;
        }

        public Component connectMessage() {
            return this.connectMessage;
        }

        public Component offlineMessage() {
            return this.offlineMessage;
        }

        public IconTemplate getIconTemplate() {
            return this.iconTemplate;
        }
    }

    public static final class ServerStatusSnapshot {
        private final Connectivity connectivity;
        private final long pingMillis;

        private ServerStatusSnapshot(Connectivity connectivity, long pingMillis) {
            this.connectivity = connectivity;
            this.pingMillis = pingMillis;
        }

        public static ServerStatusSnapshot online(long pingMillis) {
            return new ServerStatusSnapshot(Connectivity.ONLINE, Math.max(1L, pingMillis));
        }

        public static ServerStatusSnapshot offline() {
            return new ServerStatusSnapshot(Connectivity.OFFLINE, -1L);
        }

        public static ServerStatusSnapshot unknown() {
            return new ServerStatusSnapshot(Connectivity.UNKNOWN, -1L);
        }

        public Connectivity getConnectivity() {
            return this.connectivity;
        }

        public String pingDisplay() {
            return this.connectivity == Connectivity.ONLINE ? Long.toString(this.pingMillis) : "N/A";
        }

        public String statusMiniMessage() {
            return switch (this.connectivity.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> "<green>Online</green>";
                case 1 -> "<red>Offline</red>";
                case 2 -> "<gray>Unknown</gray>";
            };
        }

        public boolean isOnline() {
            return this.connectivity == Connectivity.ONLINE;
        }

        public boolean isOffline() {
            return this.connectivity == Connectivity.OFFLINE;
        }

        public boolean isUnknown() {
            return this.connectivity == Connectivity.UNKNOWN;
        }

        public static enum Connectivity {
            ONLINE,
            OFFLINE,
            UNKNOWN;

        }
    }
}

