/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezrtp.command;

import com.skyblockexp.ezrtp.EzRtpPlugin;
import com.skyblockexp.ezrtp.config.EzRtpConfiguration;
import com.skyblockexp.ezrtp.config.RandomTeleportSettings;
import com.skyblockexp.ezrtp.gui.RandomTeleportGuiManager;
import com.skyblockexp.ezrtp.storage.RtpUsageStorage;
import com.skyblockexp.ezrtp.teleport.RandomTeleportService;
import com.skyblockexp.ezrtp.teleport.TeleportReason;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class RandomTeleportCommand
implements CommandExecutor,
TabCompleter {
    private static final String RELOAD_SUBCOMMAND = "reload";
    private final EzRtpPlugin plugin;
    private final Supplier<RandomTeleportService> teleportServiceSupplier;
    private final Supplier<EzRtpConfiguration> configurationSupplier;
    private final RandomTeleportGuiManager guiManager;
    private final RtpUsageStorage usageStorage;

    public RandomTeleportCommand(EzRtpPlugin plugin, Supplier<RandomTeleportService> teleportServiceSupplier, Supplier<EzRtpConfiguration> configurationSupplier, RandomTeleportGuiManager guiManager, RtpUsageStorage usageStorage) {
        this.plugin = plugin;
        this.teleportServiceSupplier = teleportServiceSupplier;
        this.configurationSupplier = configurationSupplier;
        this.guiManager = guiManager;
        this.usageStorage = usageStorage;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        RandomTeleportSettings settings;
        if (args.length > 0 && RELOAD_SUBCOMMAND.equalsIgnoreCase(args[0])) {
            if (!sender.hasPermission("ezrtp.reload")) {
                sender.sendMessage("\u00a7cYou do not have permission to reload EzRTP.");
                return true;
            }
            this.plugin.reloadPluginConfiguration();
            sender.sendMessage("\u00a7aEzRTP configuration reloaded.");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command may only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        EzRtpConfiguration configuration = this.configurationSupplier.get();
        RandomTeleportSettings randomTeleportSettings = settings = configuration != null ? configuration.getDefaultSettings() : null;
        if (settings == null) {
            sender.sendMessage("\u00a7cEzRTP settings have not finished loading yet.");
            return true;
        }
        FileConfiguration messages = this.plugin.getConfig();
        try {
            File msgFile = new File(this.plugin.getDataFolder(), "messages.yml");
            if (msgFile.exists()) {
                messages = YamlConfiguration.loadConfiguration((File)msgFile);
            }
        }
        catch (Exception msgFile) {
            // empty catch block
        }
        MiniMessage mm = MiniMessage.miniMessage();
        String world = player.getWorld().getName();
        String group = null;
        for (String perm : configuration.getBypassPermissions()) {
            if (!player.hasPermission(perm)) continue;
            if (this.guiManager != null && this.guiManager.openSelection(player)) {
                return true;
            }
            RandomTeleportService service = Objects.requireNonNull(this.teleportServiceSupplier.get(), "Teleport service not initialised");
            service.teleportPlayer(player, TeleportReason.COMMAND);
            return true;
        }
        EzRtpConfiguration.RtpLimitSettings limit = configuration.getLimitSettings(world, group);
        long now = System.currentTimeMillis();
        long lastRtp = this.usageStorage.getLastRtpTime(player.getUniqueId(), world);
        int daily = this.usageStorage.getUsageCount(player.getUniqueId(), world, "daily");
        int weekly = this.usageStorage.getUsageCount(player.getUniqueId(), world, "weekly");
        if (limit.cooldownSeconds > 0 && now - lastRtp < (long)limit.cooldownSeconds * 1000L) {
            long wait = ((long)limit.cooldownSeconds * 1000L - (now - lastRtp)) / 1000L;
            String msg = messages.getString("cooldown", "<red>You must wait <white><seconds></white> seconds before using /rtp again.</red>");
            this.sendComponentMessage(sender, (Component)mm.deserialize(msg.replace("<seconds>", String.valueOf(wait))));
            return true;
        }
        if (limit.dailyLimit > 0 && daily >= limit.dailyLimit) {
            String msg = messages.getString("limit-daily", "<red>You have reached your daily /rtp limit for this world.</red>");
            this.sendComponentMessage(sender, (Component)mm.deserialize(msg));
            return true;
        }
        if (limit.weeklyLimit > 0 && weekly >= limit.weeklyLimit) {
            String msg = messages.getString("limit-weekly", "<red>You have reached your weekly /rtp limit for this world.</red>");
            this.sendComponentMessage(sender, (Component)mm.deserialize(msg));
            return true;
        }
        if (this.guiManager != null && this.guiManager.openSelection(player)) {
            return true;
        }
        RandomTeleportService service = Objects.requireNonNull(this.teleportServiceSupplier.get(), "Teleport service not initialised");
        service.teleportPlayer(player, TeleportReason.COMMAND, success -> {
            if (success.booleanValue()) {
                this.usageStorage.setLastRtpTime(player.getUniqueId(), world, System.currentTimeMillis());
                this.usageStorage.incrementUsage(player.getUniqueId(), world, "daily");
                this.usageStorage.incrementUsage(player.getUniqueId(), world, "weekly");
                this.usageStorage.save();
            }
        });
        return true;
    }

    private void sendComponentMessage(CommandSender sender, Component component) {
        try {
            sender.getClass().getMethod("sendMessage", Component.class);
            sender.sendMessage(component);
        }
        catch (NoSuchMethodException e) {
            sender.sendMessage(LegacyComponentSerializer.legacySection().serialize(component));
        }
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1 && RELOAD_SUBCOMMAND.startsWith(args[0].toLowerCase(Locale.ROOT)) && sender.hasPermission("ezrtp.reload")) {
            return Collections.singletonList(RELOAD_SUBCOMMAND);
        }
        return Collections.emptyList();
    }
}

