/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezmine.listener;

import com.skyblockexp.ezmine.config.CustomToolConfiguration;
import com.skyblockexp.ezmine.config.CustomToolDefinition;
import com.skyblockexp.ezmine.tool.CustomToolManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class CustomToolListener
implements Listener {
    private final CustomToolConfiguration configuration;
    private final CustomToolManager toolManager;

    public CustomToolListener(CustomToolConfiguration configuration, CustomToolManager toolManager) {
        this.configuration = configuration;
        this.toolManager = toolManager;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.configuration.isEnabled()) {
            return;
        }
        Action action = event.getAction();
        if (action == Action.PHYSICAL) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        CustomToolDefinition definition = this.configuration.match(item);
        if (definition == null) {
            return;
        }
        Player player = event.getPlayer();
        this.toolManager.setActiveTool(player.getUniqueId(), definition);
        Set<String> actions = definition.getActions();
        if (!actions.isEmpty()) {
            ArrayList<String> labels = new ArrayList<String>(actions);
            Collections.sort(labels);
            player.sendMessage(ChatColor.GOLD + "EzMine custom tool actions: " + ChatColor.AQUA + String.join((CharSequence)(ChatColor.GRAY + ", " + ChatColor.AQUA), labels));
        } else {
            player.sendMessage(ChatColor.GOLD + "EzMine custom tool ready.");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemHeld(PlayerItemHeldEvent event) {
        if (!this.configuration.isEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack newItem = player.getInventory().getItem(event.getNewSlot());
        CustomToolDefinition definition = this.configuration.match(newItem);
        if (definition == null) {
            this.toolManager.clear(player.getUniqueId());
        } else {
            this.toolManager.setActiveTool(player.getUniqueId(), definition);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.toolManager.clear(event.getPlayer().getUniqueId());
    }
}

