/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezmine.integration;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.skyblockexp.ezmine.EzMine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class WorldGuardIntegration {
    private final EzMine plugin;
    private boolean enabled;
    private boolean pluginPresent;
    private boolean requireRegion;
    private int minimumPriority;
    private List<String> allowedGlobalRegions;
    private List<String> blockedGlobalRegions;
    private final Map<String, List<String>> allowedWorldRegions = new HashMap<String, List<String>>();
    private final Map<String, List<String>> blockedWorldRegions = new HashMap<String, List<String>>();

    public WorldGuardIntegration(EzMine plugin) {
        this.plugin = plugin;
    }

    public void reload(FileConfiguration configuration) {
        Plugin dependency;
        boolean configuredEnabled;
        this.enabled = false;
        this.pluginPresent = false;
        this.requireRegion = false;
        this.minimumPriority = 0;
        this.allowedGlobalRegions = Collections.emptyList();
        this.blockedGlobalRegions = Collections.emptyList();
        this.allowedWorldRegions.clear();
        this.blockedWorldRegions.clear();
        ConfigurationSection section = configuration.getConfigurationSection("settings.worldguard");
        boolean bl = configuredEnabled = section == null || section.getBoolean("enabled", true);
        if (section != null) {
            this.requireRegion = section.getBoolean("require-region", false);
            this.minimumPriority = section.getInt("minimum-priority", 0);
            this.allowedGlobalRegions = WorldGuardIntegration.toLowercaseList(section.getStringList("allowed-regions.global"));
            this.blockedGlobalRegions = WorldGuardIntegration.toLowercaseList(section.getStringList("blocked-regions.global"));
            WorldGuardIntegration.loadWorldRegionMap(section.getConfigurationSection("allowed-regions"), this.allowedWorldRegions);
            WorldGuardIntegration.loadWorldRegionMap(section.getConfigurationSection("blocked-regions"), this.blockedWorldRegions);
        }
        boolean bl2 = this.pluginPresent = (dependency = Bukkit.getPluginManager().getPlugin("WorldGuard")) != null && dependency.isEnabled();
        if (!configuredEnabled) {
            if (this.pluginPresent) {
                this.plugin.getLogger().info("WorldGuard integration disabled in configuration.");
            }
            return;
        }
        if (!this.pluginPresent) {
            this.plugin.getLogger().warning("WorldGuard integration enabled but WorldGuard plugin is missing.");
            return;
        }
        this.enabled = true;
        this.plugin.getLogger().info("WorldGuard integration enabled.");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPluginPresent() {
        return this.pluginPresent;
    }

    public List<String> getApplicableRegions(Location location) {
        if (!this.enabled || location == null || location.getWorld() == null) {
            return Collections.emptyList();
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)location.getWorld()));
        if (manager == null) {
            return Collections.emptyList();
        }
        ApplicableRegionSet regions = manager.getApplicableRegions(BlockVector3.at((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ()));
        if (regions == null || regions.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProtectedRegion> sorted = new ArrayList<ProtectedRegion>(regions.getRegions());
        sorted.sort(Comparator.comparingInt(ProtectedRegion::getPriority).reversed());
        ArrayList<String> ids = new ArrayList<String>();
        for (ProtectedRegion region : sorted) {
            if (region.getPriority() < this.minimumPriority) continue;
            ids.add(region.getId().toLowerCase(Locale.ROOT));
        }
        return ids;
    }

    public boolean isMiningAllowed(Location location) {
        boolean hasAllowed;
        if (!this.enabled || location == null || location.getWorld() == null) {
            return true;
        }
        List<String> regions = this.getApplicableRegions(location);
        if (this.requireRegion && !WorldGuardIntegration.hasNonGlobalRegion(regions)) {
            return false;
        }
        String worldKey = location.getWorld().getName().toLowerCase(Locale.ROOT);
        if (WorldGuardIntegration.containsRegion(regions, this.blockedGlobalRegions) || WorldGuardIntegration.containsRegion(regions, this.blockedWorldRegions.get(worldKey))) {
            return false;
        }
        List<String> allowedWorld = this.allowedWorldRegions.get(worldKey);
        boolean bl = hasAllowed = this.allowedGlobalRegions != null && !this.allowedGlobalRegions.isEmpty() || allowedWorld != null && !allowedWorld.isEmpty();
        if (!hasAllowed) {
            return true;
        }
        return WorldGuardIntegration.containsRegion(regions, this.allowedGlobalRegions) || WorldGuardIntegration.containsRegion(regions, allowedWorld);
    }

    private static void loadWorldRegionMap(ConfigurationSection section, Map<String, List<String>> target) {
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            List<String> regions;
            if ("global".equalsIgnoreCase(key) || (regions = WorldGuardIntegration.toLowercaseList(section.getStringList(key))).isEmpty()) continue;
            target.put(key.toLowerCase(Locale.ROOT), regions);
        }
    }

    private static List<String> toLowercaseList(List<String> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String value : values) {
            if (value == null || value.trim().isEmpty()) continue;
            result.add(value.trim().toLowerCase(Locale.ROOT));
        }
        return result;
    }

    private static boolean containsRegion(List<String> regions, List<String> targets) {
        if (regions == null || regions.isEmpty() || targets == null || targets.isEmpty()) {
            return false;
        }
        for (String region : regions) {
            if (!targets.contains(region)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNonGlobalRegion(List<String> regions) {
        if (regions == null) {
            return false;
        }
        for (String region : regions) {
            if ("__global__".equalsIgnoreCase(region)) continue;
            return true;
        }
        return false;
    }
}

