/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezmine.integration;

import com.skyblockexp.ezmine.EzMine;
import com.skyblockexp.ezmine.util.BukkitCompatibility;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EzSkillsIntegration {
    private final EzMine plugin;
    private Method getLevelMethod;
    private Method addExperienceMethod;
    private boolean getLevelUsesUuidArgument;
    private boolean addExperienceUsesUuidArgument;
    private String skillName;
    private boolean enabled;
    private boolean experienceEnabled;
    private double baseExperiencePerBlock;
    private Map<Material, Double> materialExperience;
    private boolean applyRankMultiplier;
    private boolean perWorldEnabled;
    private Map<String, String> worldSkillOverrides;

    public EzSkillsIntegration(EzMine plugin) {
        this.plugin = plugin;
        this.materialExperience = Collections.emptyMap();
    }

    public void reload(FileConfiguration configuration) {
        ConfigurationSection experienceSection;
        this.getLevelMethod = null;
        this.addExperienceMethod = null;
        this.getLevelUsesUuidArgument = false;
        this.addExperienceUsesUuidArgument = false;
        this.skillName = null;
        this.enabled = false;
        this.experienceEnabled = false;
        this.baseExperiencePerBlock = 0.0;
        this.materialExperience = Collections.emptyMap();
        this.applyRankMultiplier = true;
        this.perWorldEnabled = false;
        this.worldSkillOverrides = Collections.emptyMap();
        ConfigurationSection section = configuration.getConfigurationSection("ezskills");
        if (section == null) {
            return;
        }
        Object enabledValue = section.get("enabled");
        Boolean enabledSetting = null;
        if (enabledValue instanceof Boolean) {
            enabledSetting = (Boolean)enabledValue;
        } else if (enabledValue instanceof String) {
            String rawValue = ((String)enabledValue).trim().toLowerCase(Locale.ROOT);
            if ("auto".equals(rawValue)) {
                enabledSetting = null;
            } else if ("true".equals(rawValue) || "false".equals(rawValue)) {
                enabledSetting = Boolean.parseBoolean(rawValue);
            } else {
                this.plugin.getLogger().warning("Unknown ezskills.enabled value '" + enabledValue + "'. Expected true, false, or auto. Defaulting to auto-detect.");
                enabledSetting = null;
            }
        }
        if (Boolean.FALSE.equals(enabledSetting)) {
            this.plugin.getLogger().info("EzSkills integration is disabled in configuration.");
            return;
        }
        Plugin dependency = Bukkit.getPluginManager().getPlugin("EzSkills");
        if (dependency == null || !dependency.isEnabled()) {
            if (Boolean.TRUE.equals(enabledSetting)) {
                this.plugin.getLogger().warning("EzSkills integration enabled but EzSkills plugin is missing.");
            }
            return;
        }
        this.skillName = section.getString("skill", "MINING");
        if (this.skillName == null || this.skillName.trim().isEmpty()) {
            this.plugin.getLogger().warning("EzSkills integration is enabled but no skill name is configured.");
            return;
        }
        this.skillName = this.skillName.toUpperCase(Locale.ROOT);
        ConfigurationSection perWorldSection = section.getConfigurationSection("per-world");
        if (perWorldSection != null) {
            this.perWorldEnabled = perWorldSection.getBoolean("enabled", false);
            ConfigurationSection overrideSection = perWorldSection.getConfigurationSection("skill-overrides");
            if (overrideSection != null) {
                HashMap<String, String> overrides = new HashMap<String, String>();
                for (Object worldKey : overrideSection.getKeys(false)) {
                    String skill = overrideSection.getString((String)worldKey);
                    if (skill == null || skill.trim().isEmpty()) continue;
                    overrides.put(((String)worldKey).toLowerCase(Locale.ROOT), skill.trim().toUpperCase(Locale.ROOT));
                }
                if (!overrides.isEmpty()) {
                    this.worldSkillOverrides = Collections.unmodifiableMap(overrides);
                }
            }
        }
        if ((experienceSection = section.getConfigurationSection("experience")) != null) {
            this.baseExperiencePerBlock = Math.max(0.0, experienceSection.getDouble("base-per-block", 0.0));
            this.applyRankMultiplier = experienceSection.getBoolean("apply-rank-multiplier", true);
            ConfigurationSection overridesSection = experienceSection.getConfigurationSection("material-overrides");
            if (overridesSection != null) {
                EnumMap<Material, Double> overrides = new EnumMap<Material, Double>(Material.class);
                for (String key : overridesSection.getKeys(false)) {
                    Material material = BukkitCompatibility.matchMaterial(key);
                    if (material == null) {
                        this.plugin.getLogger().log(Level.WARNING, "Unknown material in ezskills.experience.material-overrides: {0}", key);
                        continue;
                    }
                    double amount = Math.max(0.0, overridesSection.getDouble(key, 0.0));
                    if (!(amount > 0.0)) continue;
                    overrides.put(material, amount);
                }
                if (!overrides.isEmpty()) {
                    this.materialExperience = Collections.unmodifiableMap(overrides);
                }
            }
        }
        try {
            Class<?> apiClass = Class.forName("com.skyblockexp.ezskills.api.EzSkillsAPI");
            try {
                this.getLevelMethod = apiClass.getMethod("getSkillLevel", Player.class, String.class);
                this.getLevelUsesUuidArgument = false;
            }
            catch (NoSuchMethodException exception) {
                this.getLevelMethod = apiClass.getMethod("getSkillLevel", UUID.class, String.class);
                this.getLevelUsesUuidArgument = true;
            }
            try {
                this.addExperienceMethod = apiClass.getMethod("addExperience", Player.class, String.class, Double.TYPE);
                this.addExperienceUsesUuidArgument = false;
            }
            catch (NoSuchMethodException ignored) {
                try {
                    this.addExperienceMethod = apiClass.getMethod("addExperience", UUID.class, String.class, Double.TYPE);
                    this.addExperienceUsesUuidArgument = true;
                }
                catch (NoSuchMethodException nestedException) {
                    this.addExperienceMethod = null;
                }
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException exception) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to initialise EzSkills API reflection", exception);
            this.getLevelMethod = null;
            this.addExperienceMethod = null;
        }
        boolean bl = this.enabled = this.getLevelMethod != null;
        if (!this.enabled) {
            this.plugin.getLogger().warning("Unable to resolve EzSkills API getSkillLevel method. Integration disabled.");
            return;
        }
        boolean hasPositiveOverride = this.materialExperience.values().stream().anyMatch(value -> value > 0.0);
        boolean bl2 = this.experienceEnabled = this.addExperienceMethod != null && (this.baseExperiencePerBlock > 0.0 || hasPositiveOverride);
        if (this.baseExperiencePerBlock > 0.0 && this.addExperienceMethod == null) {
            this.plugin.getLogger().warning("EzSkills experience rewards configured but addExperience method could not be resolved.");
        }
        this.plugin.getLogger().info("EzSkills integration enabled (skill: " + this.skillName + ").");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasExperienceRewards() {
        return this.experienceEnabled;
    }

    public int getSkillLevel(Player player, String worldName) {
        if (!this.enabled || player == null || this.skillName == null) {
            return 0;
        }
        try {
            Object target = this.getLevelUsesUuidArgument ? player.getUniqueId() : player;
            Object result = this.getLevelMethod.invoke(null, target, this.resolveSkillName(worldName));
            if (result instanceof Integer) {
                return (Integer)result;
            }
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to query EzSkills level", exception);
        }
        return 0;
    }

    public void awardExperience(Player player, String worldName, Material material, double rankExperienceMultiplier) {
        double amount;
        if (!this.experienceEnabled || player == null || this.skillName == null) {
            return;
        }
        double base = this.materialExperience.getOrDefault(material, this.baseExperiencePerBlock);
        if (base <= 0.0) {
            return;
        }
        double d = amount = this.applyRankMultiplier ? base * rankExperienceMultiplier : base;
        if (amount <= 0.0) {
            return;
        }
        try {
            Object target = this.addExperienceUsesUuidArgument ? player.getUniqueId() : player;
            this.addExperienceMethod.invoke(null, target, this.resolveSkillName(worldName), amount);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to award EzSkills mining experience", exception);
        }
    }

    private String resolveSkillName(String worldName) {
        if (!this.perWorldEnabled || worldName == null || this.worldSkillOverrides.isEmpty()) {
            return this.skillName;
        }
        String override = this.worldSkillOverrides.get(worldName.toLowerCase(Locale.ROOT));
        return override != null ? override : this.skillName;
    }
}

