/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezmine.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public final class BukkitCompatibility {
    private static final Method MATCH_MATERIAL_WITH_FLAG;
    private static final Method MATCH_MATERIAL_SIMPLE;

    private BukkitCompatibility() {
    }

    public static Material matchMaterial(String name) {
        if (name == null || name.trim().isEmpty()) {
            return null;
        }
        try {
            if (MATCH_MATERIAL_WITH_FLAG != null) {
                return (Material)MATCH_MATERIAL_WITH_FLAG.invoke(null, name, false);
            }
            if (MATCH_MATERIAL_SIMPLE != null) {
                return (Material)MATCH_MATERIAL_SIMPLE.invoke(null, name);
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return Material.getMaterial((String)name);
    }

    public static ItemStack getHeldItem(Player player) {
        if (player == null) {
            return null;
        }
        PlayerInventory inventory = player.getInventory();
        try {
            Method mainHand = inventory.getClass().getMethod("getItemInMainHand", new Class[0]);
            return (ItemStack)mainHand.invoke((Object)inventory, new Object[0]);
        }
        catch (NoSuchMethodException mainHand) {
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return null;
        }
        try {
            Method legacyHand = player.getClass().getMethod("getItemInHand", new Class[0]);
            return (ItemStack)legacyHand.invoke((Object)player, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            return null;
        }
    }

    public static Collection<ItemStack> getDrops(Block block, ItemStack tool, Player player) {
        if (block == null) {
            return Collections.emptyList();
        }
        if (tool == null) {
            return block.getDrops();
        }
        try {
            Method dropsWithPlayer = block.getClass().getMethod("getDrops", ItemStack.class, Player.class);
            return (Collection)dropsWithPlayer.invoke((Object)block, tool, player);
        }
        catch (NoSuchMethodException dropsWithPlayer) {
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return block.getDrops();
        }
        try {
            Method dropsWithTool = block.getClass().getMethod("getDrops", ItemStack.class);
            return (Collection)dropsWithTool.invoke((Object)block, tool);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            return block.getDrops();
        }
    }

    public static boolean setDropItems(BlockBreakEvent event, boolean dropItems) {
        if (event == null) {
            return false;
        }
        try {
            Method setDropItems = event.getClass().getMethod("setDropItems", Boolean.TYPE);
            setDropItems.invoke((Object)event, dropItems);
            return true;
        }
        catch (NoSuchMethodException ignored) {
            return false;
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return false;
        }
    }

    public static boolean isSpectator(GameMode gameMode) {
        return gameMode != null && "SPECTATOR".equals(gameMode.name());
    }

    static {
        Method matchWithFlag = null;
        Method matchSimple = null;
        try {
            matchWithFlag = Material.class.getMethod("matchMaterial", String.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            matchSimple = Material.class.getMethod("matchMaterial", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        MATCH_MATERIAL_WITH_FLAG = matchWithFlag;
        MATCH_MATERIAL_SIMPLE = matchSimple;
    }
}

