/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezmine.shop;

import com.skyblockexp.ezmine.config.CustomToolConfiguration;
import com.skyblockexp.ezmine.config.CustomToolDefinition;
import com.skyblockexp.ezmine.config.CustomToolShopSettings;
import com.skyblockexp.ezmine.shop.CustomToolShopHolder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomToolShop {
    private static final DecimalFormat PRICE_FORMAT = new DecimalFormat("#,##0.##");

    public Inventory createInventory(CustomToolConfiguration configuration) {
        CustomToolShopSettings settings = configuration.getShopSettings();
        int size = settings.getRows() * 9;
        HashMap<Integer, String> slotMapping = new HashMap<Integer, String>();
        CustomToolShopHolder holder = new CustomToolShopHolder(slotMapping);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)size, (String)settings.getTitle());
        holder.setInventory(inventory);
        int nextSlot = 0;
        for (CustomToolDefinition definition : configuration.getTools().values()) {
            if (!definition.isShopVisible()) continue;
            int slot = this.resolveSlot(definition.getShopSlot(), size, inventory, nextSlot);
            if (slot == -1) break;
            nextSlot = slot + 1;
            ItemStack display = this.createDisplayItem(definition, settings);
            inventory.setItem(slot, display);
            slotMapping.put(slot, definition.getId());
        }
        if (slotMapping.isEmpty()) {
            return null;
        }
        return inventory;
    }

    private int resolveSlot(int preferredSlot, int size, Inventory inventory, int startSlot) {
        int i;
        if (preferredSlot >= 0 && preferredSlot < size && inventory.getItem(preferredSlot) == null) {
            return preferredSlot;
        }
        for (i = startSlot; i < size; ++i) {
            if (inventory.getItem(i) != null) continue;
            return i;
        }
        for (i = 0; i < startSlot; ++i) {
            if (inventory.getItem(i) != null) continue;
            return i;
        }
        return -1;
    }

    private ItemStack createDisplayItem(CustomToolDefinition definition, CustomToolShopSettings settings) {
        double cost;
        ItemStack itemStack = definition.createItemStack();
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return itemStack;
        }
        ArrayList<String> lore = new ArrayList<String>();
        if (meta.hasLore() && meta.getLore() != null) {
            lore.addAll(meta.getLore());
        }
        if (!lore.isEmpty()) {
            lore.add("");
        }
        if ((cost = definition.getShopCost()) > 0.0) {
            lore.add(ChatColor.YELLOW + "Cost: " + ChatColor.GOLD + this.formatCost(cost) + " " + settings.getCurrencyName());
        } else {
            lore.add(ChatColor.GREEN + "Free");
        }
        lore.add(ChatColor.GRAY + "Click to claim");
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    private String formatCost(double cost) {
        return PRICE_FORMAT.format(cost);
    }
}

