/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezmine.listener;

import com.skyblockexp.ezmine.config.MineConfiguration;
import com.skyblockexp.ezmine.config.OreSearcherSettings;
import com.skyblockexp.ezmine.integration.EzSkillsIntegration;
import com.skyblockexp.ezmine.integration.McMMOIntegration;
import com.skyblockexp.ezmine.integration.WorldGuardIntegration;
import com.skyblockexp.ezmine.tool.CustomToolManager;
import com.skyblockexp.ezmine.util.BukkitCompatibility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class RankedMiningListener
implements Listener {
    private final MineConfiguration configuration;
    private final EzSkillsIntegration ezSkills;
    private final McMMOIntegration mcMMO;
    private final WorldGuardIntegration worldGuard;
    private final CustomToolManager customToolManager;

    public RankedMiningListener(MineConfiguration configuration, EzSkillsIntegration ezSkills, McMMOIntegration mcMMO, WorldGuardIntegration worldGuard, CustomToolManager customToolManager) {
        this.configuration = configuration;
        this.ezSkills = ezSkills;
        this.mcMMO = mcMMO;
        this.worldGuard = worldGuard;
        this.customToolManager = customToolManager;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.mcMMO != null && this.mcMMO.isPluginPresent() && this.mcMMO.isFakeBlockBreakEvent(event)) {
            return;
        }
        Block block = event.getBlock();
        Material material = block.getType();
        if (!this.configuration.isTracked(material)) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE || BukkitCompatibility.isSpectator(player.getGameMode())) {
            return;
        }
        String worldName = block.getWorld().getName();
        if (!this.configuration.isWorldEnabled(worldName)) {
            return;
        }
        List<String> regions = this.worldGuard != null ? this.worldGuard.getApplicableRegions(block.getLocation()) : Collections.emptyList();
        String profileName = this.configuration.resolveProfileName(worldName, regions);
        boolean useEzSkills = this.ezSkills != null && this.ezSkills.isEnabled();
        boolean useMcMMO = !useEzSkills && this.mcMMO != null && this.mcMMO.isEnabled();
        boolean enforceSkillRequirements = useEzSkills || useMcMMO;
        int skillLevel = 0;
        if (useEzSkills) {
            skillLevel = this.ezSkills.getSkillLevel(player, worldName);
        } else if (useMcMMO) {
            skillLevel = this.mcMMO.getSkillLevel(player, worldName);
        }
        MineConfiguration.AppliedSettings settings = this.configuration.resolveSettings(player, material, skillLevel, enforceSkillRequirements, profileName);
        Set activeActions = this.customToolManager != null ? this.customToolManager.getActiveActions(player.getUniqueId()) : Collections.emptySet();
        boolean areaMining = activeActions.contains("3x3");
        boolean autoSmeltOverride = activeActions.contains("auto-smelt");
        boolean oreSearcher = activeActions.contains("ore-searcher");
        boolean fortuneEnabled = settings.fortuneEnabled();
        boolean applyAutoSmelt = settings.autoSmelt() || autoSmeltOverride;
        ArrayList<Block> targets = new ArrayList<Block>();
        targets.add(block);
        if (areaMining) {
            targets.addAll(this.collectAdjacentBlocks(block));
        }
        boolean processedPrimary = false;
        boolean cancelPrimary = false;
        for (int index = 0; index < targets.size(); ++index) {
            Block target = (Block)targets.get(index);
            boolean isPrimary = index == 0;
            Material targetMaterial = target.getType();
            if (!this.configuration.isTracked(targetMaterial)) {
                if (!isPrimary) continue;
                return;
            }
            Collection<ItemStack> drops = this.calculateDrops(target, player, fortuneEnabled);
            if (drops.isEmpty()) {
                if (!isPrimary) continue;
                return;
            }
            if (isPrimary) {
                if (!BukkitCompatibility.setDropItems(event, false)) {
                    event.setCancelled(true);
                    cancelPrimary = true;
                }
                processedPrimary = true;
            }
            for (ItemStack drop : drops) {
                ItemStack processedDrop = this.processDrop(drop, targetMaterial, settings, applyAutoSmelt);
                if (processedDrop == null || processedDrop.getAmount() <= 0) continue;
                target.getWorld().dropItemNaturally(target.getLocation(), processedDrop);
            }
            if (!isPrimary) {
                target.setType(Material.AIR);
            }
            if (this.ezSkills != null && this.ezSkills.hasExperienceRewards()) {
                this.ezSkills.awardExperience(player, worldName, targetMaterial, settings.experienceMultiplier());
                continue;
            }
            if (this.mcMMO == null || !this.mcMMO.hasExperienceRewards()) continue;
            this.mcMMO.awardExperience(player, worldName, targetMaterial, settings.experienceMultiplier());
        }
        if (oreSearcher) {
            this.spawnOreSearchParticles(player, block, this.configuration.getOreSearcherSettings());
        }
        if (!processedPrimary) {
            return;
        }
        int exp = event.getExpToDrop();
        int adjustedExp = (int)Math.max(0L, Math.round((double)exp * settings.experienceMultiplier()));
        if (cancelPrimary) {
            block.setType(Material.AIR);
            if (adjustedExp > 0) {
                player.giveExp(adjustedExp);
            }
            return;
        }
        event.setExpToDrop(adjustedExp);
    }

    private Collection<ItemStack> calculateDrops(Block block, Player player, boolean fortuneEnabled) {
        Collection<ItemStack> drops;
        ItemStack tool;
        ItemStack effectiveTool = tool = BukkitCompatibility.getHeldItem(player);
        if (!fortuneEnabled && tool != null && tool.getType() != Material.AIR) {
            effectiveTool = this.removeFortune(tool);
        }
        if ((drops = BukkitCompatibility.getDrops(block, effectiveTool, player)) == null || drops.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<ItemStack>(drops);
    }

    private ItemStack removeFortune(ItemStack tool) {
        ItemStack clone = tool.clone();
        ItemMeta meta = clone.getItemMeta();
        if (meta != null && meta.hasEnchants() && meta.hasEnchant(Enchantment.FORTUNE)) {
            meta.removeEnchant(Enchantment.FORTUNE);
            clone.setItemMeta(meta);
        } else {
            clone.removeEnchantment(Enchantment.FORTUNE);
        }
        return clone;
    }

    private ItemStack processDrop(ItemStack originalDrop, Material sourceMaterial, MineConfiguration.AppliedSettings settings, boolean autoSmeltOverride) {
        Material smeltedType;
        if (originalDrop == null) {
            return null;
        }
        ItemStack clone = originalDrop.clone();
        int adjustedAmount = (int)Math.max(0L, Math.round((double)clone.getAmount() * settings.dropMultiplier()));
        if (adjustedAmount <= 0) {
            return null;
        }
        clone.setAmount(adjustedAmount);
        if ((settings.autoSmelt() || autoSmeltOverride) && (smeltedType = this.configuration.resolveAutoSmeltResult(clone.getType(), sourceMaterial)) != null) {
            clone.setType(smeltedType);
        }
        return clone;
    }

    private List<Block> collectAdjacentBlocks(Block origin) {
        ArrayList<Block> blocks = new ArrayList<Block>(8);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0) continue;
                blocks.add(origin.getRelative(dx, 0, dz));
            }
        }
        return blocks;
    }

    private void spawnOreSearchParticles(Player player, Block origin, OreSearcherSettings settings) {
        if (settings == null || !settings.enabled()) {
            return;
        }
        int range = settings.range();
        ArrayList<Location> matches = new ArrayList<Location>();
        for (int dx = -range; dx <= range; ++dx) {
            for (int dy = -range; dy <= range; ++dy) {
                for (int dz = -range; dz <= range; ++dz) {
                    Block target = origin.getRelative(dx, dy, dz);
                    if (!settings.isTarget(target.getType())) continue;
                    matches.add(target.getLocation().add(0.5, 0.5, 0.5));
                }
            }
        }
        if (matches.isEmpty()) {
            return;
        }
        Location eyeLocation = player.getEyeLocation();
        matches.sort(Comparator.comparingDouble(location -> location.distanceSquared(eyeLocation)));
        int limit = Math.min(settings.maxResults(), matches.size());
        Particle particle = settings.particle();
        int particleCount = settings.particleCount();
        double distance = settings.particleDistance();
        for (int i = 0; i < limit; ++i) {
            Location target = (Location)matches.get(i);
            Vector direction = target.toVector().subtract(eyeLocation.toVector());
            if (direction.lengthSquared() <= 0.01) continue;
            direction.normalize().multiply(distance);
            Location particleLocation = eyeLocation.clone().add(direction);
            origin.getWorld().spawnParticle(particle, particleLocation, particleCount, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

