/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezmine.integration;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.skyblockexp.ezmine.EzMine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class WorldGuardIntegration {
    private final EzMine plugin;
    private boolean enabled;
    private boolean pluginPresent;

    public WorldGuardIntegration(EzMine plugin) {
        this.plugin = plugin;
    }

    public void reload(FileConfiguration configuration) {
        this.enabled = false;
        this.pluginPresent = false;
        ConfigurationSection section = configuration.getConfigurationSection("settings.worldguard");
        boolean configuredEnabled = section == null || section.getBoolean("enabled", true);
        Plugin dependency = Bukkit.getPluginManager().getPlugin("WorldGuard");
        boolean bl = this.pluginPresent = dependency != null && dependency.isEnabled();
        if (!configuredEnabled) {
            if (this.pluginPresent) {
                this.plugin.getLogger().info("WorldGuard integration disabled in configuration.");
            }
            return;
        }
        if (!this.pluginPresent) {
            this.plugin.getLogger().warning("WorldGuard integration enabled but WorldGuard plugin is missing.");
            return;
        }
        this.enabled = true;
        this.plugin.getLogger().info("WorldGuard integration enabled.");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPluginPresent() {
        return this.pluginPresent;
    }

    public List<String> getApplicableRegions(Location location) {
        if (!this.enabled || location == null || location.getWorld() == null) {
            return Collections.emptyList();
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)location.getWorld()));
        if (manager == null) {
            return Collections.emptyList();
        }
        ApplicableRegionSet regions = manager.getApplicableRegions(BlockVector3.at((int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ()));
        if (regions == null || regions.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProtectedRegion> sorted = new ArrayList<ProtectedRegion>(regions.getRegions());
        sorted.sort(Comparator.comparingInt(ProtectedRegion::getPriority).reversed());
        ArrayList<String> ids = new ArrayList<String>();
        for (ProtectedRegion region : sorted) {
            ids.add(region.getId().toLowerCase(Locale.ROOT));
        }
        return ids;
    }
}

