/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezmine.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class WorldSettings {
    private final boolean defaultEnabled;
    private final Set<String> enabledWorlds;
    private final Set<String> disabledWorlds;
    private final String defaultProfile;
    private final Map<String, String> worldProfiles;
    private final Map<String, Map<String, String>> regionProfiles;

    private WorldSettings(boolean defaultEnabled, Set<String> enabledWorlds, Set<String> disabledWorlds, String defaultProfile, Map<String, String> worldProfiles, Map<String, Map<String, String>> regionProfiles) {
        this.defaultEnabled = defaultEnabled;
        this.enabledWorlds = enabledWorlds == null ? Collections.emptySet() : Collections.unmodifiableSet(enabledWorlds);
        this.disabledWorlds = disabledWorlds == null ? Collections.emptySet() : Collections.unmodifiableSet(disabledWorlds);
        this.defaultProfile = defaultProfile == null ? "default" : defaultProfile;
        this.worldProfiles = worldProfiles == null ? Collections.emptyMap() : Collections.unmodifiableMap(worldProfiles);
        this.regionProfiles = regionProfiles == null ? Collections.emptyMap() : Collections.unmodifiableMap(regionProfiles);
    }

    public static WorldSettings createDefault() {
        return new WorldSettings(true, Collections.emptySet(), Collections.emptySet(), "default", Collections.emptyMap(), Collections.emptyMap());
    }

    public static WorldSettings fromConfiguration(FileConfiguration configuration) {
        boolean defaultEnabled = true;
        Set<String> enabledWorlds = new HashSet<String>();
        Set<String> disabledWorlds = new HashSet<String>();
        String defaultProfile = "default";
        HashMap<String, String> worldProfiles = new HashMap<String, String>();
        HashMap<String, Map<String, String>> regionProfiles = new HashMap<String, Map<String, String>>();
        if (configuration != null) {
            ConfigurationSection profilesSection;
            ConfigurationSection worldsSection = configuration.getConfigurationSection("settings.worlds");
            if (worldsSection != null) {
                defaultEnabled = worldsSection.getBoolean("default-enabled", defaultEnabled);
                enabledWorlds = WorldSettings.toLowercaseSet(worldsSection.getStringList("enabled"));
                disabledWorlds = WorldSettings.toLowercaseSet(worldsSection.getStringList("disabled"));
            }
            if ((profilesSection = configuration.getConfigurationSection("settings.profiles")) != null) {
                ConfigurationSection regionsSection;
                ConfigurationSection worldProfilesSection;
                String configuredDefault = profilesSection.getString("default");
                if (configuredDefault != null && !configuredDefault.trim().isEmpty()) {
                    defaultProfile = configuredDefault.trim().toLowerCase(Locale.ROOT);
                }
                if ((worldProfilesSection = profilesSection.getConfigurationSection("worlds")) != null) {
                    for (String worldName : worldProfilesSection.getKeys(false)) {
                        String profileName = worldProfilesSection.getString(worldName);
                        if (profileName == null || profileName.trim().isEmpty()) continue;
                        worldProfiles.put(worldName.toLowerCase(Locale.ROOT), profileName.trim().toLowerCase(Locale.ROOT));
                    }
                }
                if ((regionsSection = profilesSection.getConfigurationSection("regions")) != null) {
                    for (String worldKey : regionsSection.getKeys(false)) {
                        ConfigurationSection regionSection = regionsSection.getConfigurationSection(worldKey);
                        if (regionSection == null) continue;
                        HashMap<String, String> mappings = new HashMap<String, String>();
                        for (String regionId : regionSection.getKeys(false)) {
                            String profileName = regionSection.getString(regionId);
                            if (profileName == null || profileName.trim().isEmpty()) continue;
                            mappings.put(regionId.toLowerCase(Locale.ROOT), profileName.trim().toLowerCase(Locale.ROOT));
                        }
                        if (mappings.isEmpty()) continue;
                        regionProfiles.put(worldKey.toLowerCase(Locale.ROOT), mappings);
                    }
                }
            }
        }
        return new WorldSettings(defaultEnabled, enabledWorlds, disabledWorlds, defaultProfile, worldProfiles, regionProfiles);
    }

    public boolean isWorldEnabled(String worldName) {
        if (worldName == null) {
            return this.defaultEnabled;
        }
        String key = worldName.toLowerCase(Locale.ROOT);
        if (this.disabledWorlds.contains(key)) {
            return false;
        }
        if (!this.enabledWorlds.isEmpty()) {
            return this.enabledWorlds.contains(key);
        }
        return this.defaultEnabled;
    }

    public String resolveProfile(String worldName, Collection<String> regionNames) {
        String profile;
        if (regionNames != null && !regionNames.isEmpty() && (profile = this.resolveRegionProfile(worldName, regionNames)) != null) {
            return profile;
        }
        if (worldName != null && (profile = this.worldProfiles.get(worldName.toLowerCase(Locale.ROOT))) != null) {
            return profile;
        }
        return this.defaultProfile;
    }

    private String resolveRegionProfile(String worldName, Collection<String> regionNames) {
        if (regionNames == null || regionNames.isEmpty()) {
            return null;
        }
        Map<String, String> worldMappings = worldName == null ? null : this.regionProfiles.get(worldName.toLowerCase(Locale.ROOT));
        Map<String, String> globalMappings = this.regionProfiles.get("global");
        for (String regionName : regionNames) {
            String profile;
            String normalized = regionName.toLowerCase(Locale.ROOT);
            if (worldMappings != null && (profile = worldMappings.get(normalized)) != null) {
                return profile;
            }
            if (globalMappings == null || (profile = globalMappings.get(normalized)) == null) continue;
            return profile;
        }
        return null;
    }

    public String getDefaultProfile() {
        return this.defaultProfile;
    }

    private static Set<String> toLowercaseSet(Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (String value : values) {
            if (value == null || value.trim().isEmpty()) continue;
            result.add(value.trim().toLowerCase(Locale.ROOT));
        }
        return result;
    }
}

