/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezmine.config;

import com.skyblockexp.ezmine.EzMine;
import com.skyblockexp.ezmine.config.BlockOverride;
import com.skyblockexp.ezmine.config.CustomToolConfiguration;
import com.skyblockexp.ezmine.config.OreSearcherSettings;
import com.skyblockexp.ezmine.config.RankSettings;
import com.skyblockexp.ezmine.config.WorldSettings;
import com.skyblockexp.ezmine.util.BukkitCompatibility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class MineConfiguration {
    private final EzMine plugin;
    private final Map<String, ProfileSettings> profiles;
    private String defaultProfileName;
    private Set<Material> trackedMaterials;
    private Map<Material, Material> autoSmeltResults;
    private final CustomToolConfiguration customToolConfiguration;
    private OreSearcherSettings oreSearcherSettings;
    private WorldSettings worldSettings;

    public MineConfiguration(EzMine plugin) {
        this.plugin = plugin;
        this.profiles = new LinkedHashMap<String, ProfileSettings>();
        this.defaultProfileName = "default";
        this.trackedMaterials = new HashSet<Material>();
        this.autoSmeltResults = Collections.emptyMap();
        this.customToolConfiguration = new CustomToolConfiguration(plugin);
        this.oreSearcherSettings = OreSearcherSettings.createDefault(plugin);
        this.worldSettings = WorldSettings.createDefault();
    }

    public void reload(FileConfiguration settingsConfiguration, FileConfiguration ranksConfiguration, FileConfiguration toolsConfiguration) {
        this.trackedMaterials = this.parseTrackedMaterials(settingsConfiguration);
        this.autoSmeltResults = this.parseAutoSmeltResults(settingsConfiguration);
        this.oreSearcherSettings = OreSearcherSettings.fromConfiguration(this.plugin, settingsConfiguration);
        this.worldSettings = WorldSettings.fromConfiguration(settingsConfiguration);
        Map<String, ProfileSettings> parsedProfiles = this.parseProfiles(settingsConfiguration, ranksConfiguration);
        this.profiles.clear();
        this.profiles.putAll(parsedProfiles);
        this.defaultProfileName = this.resolveDefaultProfileName(this.worldSettings, parsedProfiles);
        this.customToolConfiguration.reload(toolsConfiguration);
        int totalRanks = this.profiles.values().stream().mapToInt(profile -> ((ProfileSettings)profile).rankSettings.size()).sum();
        this.plugin.getLogger().info("Loaded " + this.profiles.size() + " profile(s) with " + totalRanks + " rank definition(s) for EzMine");
    }

    public boolean isTracked(Material material) {
        return this.trackedMaterials.contains(material);
    }

    public boolean isWorldEnabled(String worldName) {
        return this.worldSettings.isWorldEnabled(worldName);
    }

    public String resolveProfileName(String worldName, Collection<String> regionNames) {
        String profileName = this.worldSettings.resolveProfile(worldName, regionNames);
        if (profileName == null) {
            return this.defaultProfileName;
        }
        String normalized = profileName.toLowerCase(Locale.ROOT);
        if (this.profiles.containsKey(normalized)) {
            return normalized;
        }
        return this.defaultProfileName;
    }

    public String getDefaultProfileName() {
        return this.defaultProfileName;
    }

    public AppliedSettings resolveSettings(Player player, Material material, int skillLevel, boolean enforceSkillRequirement, String profileName) {
        RankSettings rank = this.resolveRank(player, skillLevel, enforceSkillRequirement, profileName);
        if (rank == null) {
            return AppliedSettings.DEFAULT;
        }
        return rank.appliedSettings(material);
    }

    public String resolveRankName(Player player, int skillLevel, boolean enforceSkillRequirement, String profileName) {
        RankSettings rank = this.resolveRank(player, skillLevel, enforceSkillRequirement, profileName);
        return rank != null ? rank.name() : "default";
    }

    public List<String> getRankNames(String profileName) {
        ProfileSettings profile = this.getProfile(profileName);
        if (profile == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(profile.rankOrder);
    }

    public Material resolveAutoSmeltResult(Material dropType, Material sourceMaterial) {
        Material result = this.autoSmeltResults.get(dropType);
        if (result != null) {
            return result;
        }
        return this.autoSmeltResults.get(sourceMaterial);
    }

    public CustomToolConfiguration getCustomToolConfiguration() {
        return this.customToolConfiguration;
    }

    public OreSearcherSettings getOreSearcherSettings() {
        return this.oreSearcherSettings;
    }

    private RankSettings resolveRank(Player player, int skillLevel, boolean enforceSkillRequirement, String profileName) {
        ProfileSettings profile = this.getProfile(profileName);
        if (profile == null || profile.rankOrder.isEmpty()) {
            return null;
        }
        for (String name : profile.rankOrder) {
            RankSettings rank = (RankSettings)profile.rankSettings.get(name);
            if (rank == null || rank.permission() != null && !rank.permission().trim().isEmpty() && !player.hasPermission(rank.permission()) || !rank.meetsSkillRequirement(skillLevel, enforceSkillRequirement)) continue;
            return rank;
        }
        return (RankSettings)profile.rankSettings.get(profile.rankOrder.get(0));
    }

    private Set<Material> parseTrackedMaterials(FileConfiguration configuration) {
        List<String> materialKeys = configuration.getStringList("settings.tracked-blocks");
        if (materialKeys.isEmpty()) {
            materialKeys = Arrays.asList("STONE", "COBBLESTONE", "COAL_ORE", "DEEPSLATE_COAL_ORE", "IRON_ORE", "DEEPSLATE_IRON_ORE", "COPPER_ORE", "DEEPSLATE_COPPER_ORE", "GOLD_ORE", "DEEPSLATE_GOLD_ORE", "NETHER_GOLD_ORE", "REDSTONE_ORE", "DEEPSLATE_REDSTONE_ORE", "LAPIS_ORE", "DEEPSLATE_LAPIS_ORE", "EMERALD_ORE", "DEEPSLATE_EMERALD_ORE", "DIAMOND_ORE", "DEEPSLATE_DIAMOND_ORE", "ANCIENT_DEBRIS");
        }
        HashSet<Material> materials = new HashSet<Material>();
        for (String key : materialKeys) {
            Material material = BukkitCompatibility.matchMaterial(key);
            if (material == null) {
                this.plugin.getLogger().warning("Unknown material in settings.tracked-blocks: " + key);
                continue;
            }
            materials.add(material);
        }
        return materials;
    }

    private Map<Material, Material> parseAutoSmeltResults(FileConfiguration configuration) {
        ConfigurationSection section;
        Map<Material, Material> defaults = this.defaultAutoSmeltResults();
        boolean useDefaults = configuration.getBoolean("settings.auto-smelt-use-defaults", true);
        EnumMap<Material, Material> results = new EnumMap<Material, Material>(Material.class);
        if (useDefaults) {
            results.putAll(defaults);
        }
        if ((section = configuration.getConfigurationSection("settings.auto-smelt-results")) != null) {
            for (String key : section.getKeys(false)) {
                String value = section.getString(key);
                if (value == null) {
                    this.plugin.getLogger().warning("Missing value for auto-smelt material: " + key);
                    continue;
                }
                Material source = BukkitCompatibility.matchMaterial(key);
                if (source == null) {
                    this.plugin.getLogger().warning("Unknown material in settings.auto-smelt-results: " + key);
                    continue;
                }
                Material result = BukkitCompatibility.matchMaterial(value);
                if (result == null) {
                    this.plugin.getLogger().warning("Unknown smelt result material for " + key + ": " + value);
                    continue;
                }
                results.put(source, result);
            }
        }
        return Collections.unmodifiableMap(results);
    }

    private Map<Material, Material> defaultAutoSmeltResults() {
        EnumMap<Material, Material> map = new EnumMap<Material, Material>(Material.class);
        this.addAutoSmeltPair(map, "IRON_ORE", "IRON_INGOT");
        this.addAutoSmeltPair(map, "DEEPSLATE_IRON_ORE", "IRON_INGOT");
        this.addAutoSmeltPair(map, "RAW_IRON", "IRON_INGOT");
        this.addAutoSmeltPair(map, "GOLD_ORE", "GOLD_INGOT");
        this.addAutoSmeltPair(map, "DEEPSLATE_GOLD_ORE", "GOLD_INGOT");
        this.addAutoSmeltPair(map, "NETHER_GOLD_ORE", "GOLD_NUGGET");
        this.addAutoSmeltPair(map, "RAW_GOLD", "GOLD_INGOT");
        this.addAutoSmeltPair(map, "COPPER_ORE", "COPPER_INGOT");
        this.addAutoSmeltPair(map, "DEEPSLATE_COPPER_ORE", "COPPER_INGOT");
        this.addAutoSmeltPair(map, "RAW_COPPER", "COPPER_INGOT");
        this.addAutoSmeltPair(map, "ANCIENT_DEBRIS", "NETHERITE_SCRAP");
        this.addAutoSmeltPair(map, "COBBLESTONE", "STONE");
        this.addAutoSmeltPair(map, "SAND", "GLASS");
        this.addAutoSmeltPair(map, "RED_SAND", "GLASS");
        this.addAutoSmeltPair(map, "WET_SPONGE", "SPONGE");
        return map;
    }

    private Map<String, ProfileSettings> parseProfiles(FileConfiguration settingsConfiguration, FileConfiguration ranksConfiguration) {
        List<String> rankOrder;
        LinkedHashMap<String, ProfileSettings> parsedProfiles = new LinkedHashMap<String, ProfileSettings>();
        ConfigurationSection profilesSection = ranksConfiguration.getConfigurationSection("profiles");
        if (profilesSection != null) {
            for (String profileKey : profilesSection.getKeys(false)) {
                List<String> rankOrder2;
                ConfigurationSection ranksSection;
                ConfigurationSection profileSection = profilesSection.getConfigurationSection(profileKey);
                if (profileSection == null || (ranksSection = profileSection.getConfigurationSection("ranks")) == null) continue;
                Map<String, RankSettings> parsedRanks = this.parseRankSettings(ranksSection);
                if (parsedRanks.isEmpty()) {
                    parsedRanks.put("default", RankSettings.createDefault());
                }
                if ((rankOrder2 = this.parseRankOrder(profileSection, settingsConfiguration, parsedRanks.keySet())).isEmpty()) {
                    rankOrder2 = new ArrayList<String>(parsedRanks.keySet());
                }
                parsedProfiles.put(profileKey.toLowerCase(Locale.ROOT), new ProfileSettings(parsedRanks, rankOrder2));
            }
        }
        if (!parsedProfiles.isEmpty()) {
            return parsedProfiles;
        }
        ConfigurationSection ranksSection = ranksConfiguration.getConfigurationSection("ranks");
        if (ranksSection == null) {
            this.plugin.getLogger().warning("No ranks configured for EzMine. Falling back to defaults.");
            LinkedHashMap<String, RankSettings> defaults = new LinkedHashMap<String, RankSettings>();
            defaults.put("default", RankSettings.createDefault());
            ArrayList order = new ArrayList(defaults.keySet());
            parsedProfiles.put("default", new ProfileSettings(defaults, order));
            return parsedProfiles;
        }
        Map<String, RankSettings> parsedRanks = this.parseRankSettings(ranksSection);
        if (parsedRanks.isEmpty()) {
            parsedRanks.put("default", RankSettings.createDefault());
        }
        if ((rankOrder = this.parseRankOrder(settingsConfiguration, parsedRanks.keySet())).isEmpty()) {
            rankOrder = new ArrayList<String>(parsedRanks.keySet());
        }
        parsedProfiles.put("default", new ProfileSettings(parsedRanks, rankOrder));
        return parsedProfiles;
    }

    private Map<String, RankSettings> parseRankSettings(ConfigurationSection ranksSection) {
        LinkedHashMap<String, RankSettings> parsedRanks = new LinkedHashMap<String, RankSettings>();
        for (String key : ranksSection.getKeys(false)) {
            ConfigurationSection rankSection = ranksSection.getConfigurationSection(key);
            if (rankSection == null) continue;
            String permission = rankSection.getString("permission", "").trim();
            int minimumSkillLevel = Math.max(0, rankSection.getInt("minimum-skill-level", 0));
            double dropMultiplier = rankSection.getDouble("drop-multiplier", 1.0);
            double experienceMultiplier = rankSection.getDouble("experience-multiplier", 1.0);
            boolean autoSmelt = rankSection.getBoolean("auto-smelt", false);
            boolean fortuneEnabled = rankSection.getBoolean("fortune", true);
            Map<Material, BlockOverride> overrides = this.parseOverrides(rankSection.getConfigurationSection("block-overrides"));
            parsedRanks.put(key, new RankSettings(key, permission, minimumSkillLevel, dropMultiplier, autoSmelt, fortuneEnabled, experienceMultiplier, overrides));
        }
        return parsedRanks;
    }

    private Map<Material, BlockOverride> parseOverrides(ConfigurationSection overridesSection) {
        if (overridesSection == null) {
            return Collections.emptyMap();
        }
        EnumMap<Material, BlockOverride> overrides = new EnumMap<Material, BlockOverride>(Material.class);
        for (String key : overridesSection.getKeys(false)) {
            ConfigurationSection section = overridesSection.getConfigurationSection(key);
            if (section == null) continue;
            Material material = BukkitCompatibility.matchMaterial(key.toUpperCase(Locale.ROOT));
            if (material == null) {
                this.plugin.getLogger().log(Level.WARNING, "Unknown material in block-overrides: {0}", key);
                continue;
            }
            Double dropMultiplier = section.isSet("drop-multiplier") ? Double.valueOf(section.getDouble("drop-multiplier")) : null;
            Double experienceMultiplier = section.isSet("experience-multiplier") ? Double.valueOf(section.getDouble("experience-multiplier")) : null;
            Boolean autoSmelt = section.isSet("auto-smelt") ? Boolean.valueOf(section.getBoolean("auto-smelt")) : null;
            Boolean fortune = section.isSet("fortune") ? Boolean.valueOf(section.getBoolean("fortune")) : null;
            overrides.put(material, new BlockOverride(dropMultiplier, autoSmelt, fortune, experienceMultiplier));
        }
        return overrides;
    }

    private List<String> parseRankOrder(ConfigurationSection profileSection, FileConfiguration configuration, Set<String> configuredRanks) {
        List definedOrder = Collections.emptyList();
        if (profileSection != null) {
            definedOrder = profileSection.getStringList("rank-order");
        }
        if (definedOrder == null || definedOrder.isEmpty()) {
            definedOrder = configuration.getStringList("settings.rank-order");
        }
        ArrayList<String> order = new ArrayList<String>();
        if (definedOrder != null && !definedOrder.isEmpty()) {
            LinkedHashSet<String> seen = new LinkedHashSet<String>();
            for (String name : definedOrder) {
                if (!configuredRanks.contains(name) || !seen.add(name)) continue;
                order.add(name);
            }
        }
        if (order.isEmpty()) {
            order.addAll(configuredRanks);
        } else {
            for (String name : configuredRanks) {
                if (order.contains(name)) continue;
                order.add(name);
            }
        }
        return order;
    }

    private List<String> parseRankOrder(FileConfiguration configuration, Set<String> configuredRanks) {
        return this.parseRankOrder(null, configuration, configuredRanks);
    }

    private ProfileSettings getProfile(String profileName) {
        ProfileSettings profile;
        String key;
        if (this.profiles.isEmpty()) {
            return null;
        }
        String string = key = profileName == null ? null : profileName.toLowerCase(Locale.ROOT);
        if (key != null && (profile = this.profiles.get(key)) != null) {
            return profile;
        }
        ProfileSettings defaultProfile = this.profiles.get(this.defaultProfileName);
        if (defaultProfile != null) {
            return defaultProfile;
        }
        return this.profiles.values().iterator().next();
    }

    private String resolveDefaultProfileName(WorldSettings settings, Map<String, ProfileSettings> parsedProfiles) {
        String configuredDefault = settings.getDefaultProfile();
        if (configuredDefault != null && parsedProfiles.containsKey(configuredDefault.toLowerCase(Locale.ROOT))) {
            return configuredDefault.toLowerCase(Locale.ROOT);
        }
        if (configuredDefault != null && !parsedProfiles.isEmpty()) {
            this.plugin.getLogger().warning("Default profile '" + configuredDefault + "' is not defined in ranks.yml. Falling back to first configured profile.");
        }
        if (!parsedProfiles.isEmpty()) {
            return parsedProfiles.keySet().iterator().next();
        }
        return "default";
    }

    private void addAutoSmeltPair(Map<Material, Material> map, String sourceName, String resultName) {
        Material source = BukkitCompatibility.matchMaterial(sourceName);
        Material result = BukkitCompatibility.matchMaterial(resultName);
        if (source == null || result == null) {
            return;
        }
        map.put(source, result);
    }

    public static class AppliedSettings {
        public static final AppliedSettings DEFAULT = new AppliedSettings(1.0, false, true, 1.0);
        private final double dropMultiplier;
        private final boolean autoSmelt;
        private final boolean fortuneEnabled;
        private final double experienceMultiplier;

        public AppliedSettings(double dropMultiplier, boolean autoSmelt, boolean fortuneEnabled, double experienceMultiplier) {
            this.dropMultiplier = dropMultiplier;
            this.autoSmelt = autoSmelt;
            this.fortuneEnabled = fortuneEnabled;
            this.experienceMultiplier = experienceMultiplier;
        }

        public double dropMultiplier() {
            return this.dropMultiplier;
        }

        public boolean autoSmelt() {
            return this.autoSmelt;
        }

        public boolean fortuneEnabled() {
            return this.fortuneEnabled;
        }

        public double experienceMultiplier() {
            return this.experienceMultiplier;
        }
    }

    private static class ProfileSettings {
        private final Map<String, RankSettings> rankSettings;
        private final List<String> rankOrder;

        private ProfileSettings(Map<String, RankSettings> rankSettings, List<String> rankOrder) {
            this.rankSettings = rankSettings == null ? Collections.emptyMap() : rankSettings;
            this.rankOrder = rankOrder == null ? Collections.emptyList() : rankOrder;
        }
    }
}

