/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezmine.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomToolDefinition {
    private final String id;
    private final Material material;
    private final String displayName;
    private final List<String> lore;
    private final Set<String> actions;
    private final boolean shopVisible;
    private final int shopSlot;
    private final double shopCost;

    public CustomToolDefinition(String id, Material material, String displayName, List<String> lore, Set<String> actions, boolean shopVisible, int shopSlot, double shopCost) {
        this.id = Objects.requireNonNull(id, "id");
        this.material = Objects.requireNonNull(material, "material");
        this.displayName = displayName != null && !displayName.trim().isEmpty() ? displayName : null;
        this.lore = lore == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(lore));
        this.actions = actions == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(actions));
        this.shopVisible = shopVisible;
        this.shopSlot = shopSlot;
        this.shopCost = Math.max(0.0, shopCost);
    }

    public String getId() {
        return this.id;
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getLore() {
        return Collections.unmodifiableList(this.lore);
    }

    public Set<String> getActions() {
        return Collections.unmodifiableSet(this.actions);
    }

    public boolean isShopVisible() {
        return this.shopVisible;
    }

    public int getShopSlot() {
        return this.shopSlot;
    }

    public double getShopCost() {
        return this.shopCost;
    }

    public boolean matches(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() != this.material) {
            return false;
        }
        if (this.displayName == null && this.lore.isEmpty()) {
            return true;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return false;
        }
        if (!(this.displayName == null || meta.hasDisplayName() && this.displayName.equals(meta.getDisplayName()))) {
            return false;
        }
        if (!this.lore.isEmpty()) {
            if (!meta.hasLore()) {
                return false;
            }
            List itemLore = meta.getLore();
            if (itemLore == null || itemLore.size() != this.lore.size()) {
                return false;
            }
            for (int i = 0; i < this.lore.size(); ++i) {
                String actual;
                String expected = this.lore.get(i);
                if (Objects.equals(expected, actual = (String)itemLore.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack createItemStack() {
        ItemStack itemStack = new ItemStack(this.material);
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            if (this.displayName != null) {
                meta.setDisplayName(this.displayName);
            }
            if (!this.lore.isEmpty()) {
                meta.setLore(this.lore);
            }
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }
}

