/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezmine.config;

import com.skyblockexp.ezmine.EzMine;
import com.skyblockexp.ezmine.config.CustomToolDefinition;
import com.skyblockexp.ezmine.config.CustomToolShopSettings;
import com.skyblockexp.ezmine.util.BukkitCompatibility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class CustomToolConfiguration {
    private final EzMine plugin;
    private boolean enabled;
    private Map<String, CustomToolDefinition> tools;
    private Map<Material, List<CustomToolDefinition>> toolsByMaterial;
    private CustomToolShopSettings shopSettings;

    public CustomToolConfiguration(EzMine plugin) {
        this.plugin = plugin;
        this.enabled = false;
        this.tools = Collections.emptyMap();
        this.toolsByMaterial = Collections.emptyMap();
        this.shopSettings = CustomToolShopSettings.disabled();
    }

    public void reload(FileConfiguration configuration) {
        ConfigurationSection section = configuration.getConfigurationSection("custom-tools");
        if (section == null || !section.getBoolean("enabled", false)) {
            this.enabled = false;
            this.tools = Collections.emptyMap();
            this.toolsByMaterial = Collections.emptyMap();
            this.shopSettings = CustomToolShopSettings.disabled();
            return;
        }
        ConfigurationSection toolsSection = section.getConfigurationSection("tools");
        if (toolsSection == null) {
            this.enabled = false;
            this.tools = Collections.emptyMap();
            this.toolsByMaterial = Collections.emptyMap();
            this.shopSettings = CustomToolShopSettings.disabled();
            this.plugin.getLogger().warning("custom-tools.enabled is true but no tools are defined.");
            return;
        }
        this.shopSettings = CustomToolShopSettings.from(section.getConfigurationSection("shop"));
        LinkedHashMap<String, CustomToolDefinition> parsedTools = new LinkedHashMap<String, CustomToolDefinition>();
        HashMap<Material, List> byMaterial = new HashMap<Material, List>();
        for (String key : toolsSection.getKeys(false)) {
            Object line2;
            ConfigurationSection toolSection = toolsSection.getConfigurationSection(key);
            if (toolSection == null) continue;
            String materialKey = toolSection.getString("material");
            if (materialKey == null || materialKey.trim().isEmpty()) {
                this.plugin.getLogger().log(Level.WARNING, "Missing material for custom tool {0}", key);
                continue;
            }
            Material material = BukkitCompatibility.matchMaterial(materialKey);
            if (material == null) {
                this.plugin.getLogger().log(Level.WARNING, "Unknown material {0} for custom tool {1}", new Object[]{materialKey, key});
                continue;
            }
            String displayName = toolSection.getString("name");
            if (displayName != null && !displayName.trim().isEmpty()) {
                displayName = ChatColor.translateAlternateColorCodes((char)'&', (String)displayName);
            }
            ArrayList<String> lore = new ArrayList<String>();
            for (Object line2 : toolSection.getStringList("lore")) {
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line2));
            }
            HashSet<String> actions = new HashSet<String>();
            line2 = toolSection.getStringList("actions").iterator();
            while (line2.hasNext()) {
                String action = (String)line2.next();
                if (action == null || action.trim().isEmpty()) continue;
                actions.add(action.toLowerCase(Locale.ROOT));
            }
            ConfigurationSection shopSection = toolSection.getConfigurationSection("shop");
            boolean shopVisible = shopSection == null || shopSection.getBoolean("visible", true);
            int shopSlot = shopSection != null ? shopSection.getInt("slot", -1) : -1;
            double shopCost = shopSection != null ? shopSection.getDouble("cost", 0.0) : 0.0;
            CustomToolDefinition definition = new CustomToolDefinition(key.toLowerCase(Locale.ROOT), material, displayName, lore, actions, shopVisible, shopSlot, shopCost);
            parsedTools.put(definition.getId(), definition);
            byMaterial.computeIfAbsent(material, unused -> new ArrayList()).add(definition);
        }
        boolean bl = this.enabled = !parsedTools.isEmpty();
        if (!this.enabled) {
            this.tools = Collections.emptyMap();
            this.toolsByMaterial = Collections.emptyMap();
            this.shopSettings = CustomToolShopSettings.disabled();
            return;
        }
        this.tools = Collections.unmodifiableMap(parsedTools);
        HashMap materialIndex = new HashMap();
        for (Map.Entry entry : byMaterial.entrySet()) {
            materialIndex.put((Material)entry.getKey(), Collections.unmodifiableList(new ArrayList((Collection)entry.getValue())));
        }
        this.toolsByMaterial = Collections.unmodifiableMap(materialIndex);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CustomToolDefinition getTool(String id) {
        if (!this.enabled || id == null) {
            return null;
        }
        return this.tools.get(id.toLowerCase(Locale.ROOT));
    }

    public Map<String, CustomToolDefinition> getTools() {
        return this.tools;
    }

    public CustomToolShopSettings getShopSettings() {
        return this.shopSettings;
    }

    public CustomToolDefinition match(ItemStack itemStack) {
        if (!this.enabled || itemStack == null) {
            return null;
        }
        List<CustomToolDefinition> candidates = this.toolsByMaterial.get(itemStack.getType());
        if (candidates == null) {
            return null;
        }
        for (CustomToolDefinition definition : candidates) {
            if (!definition.matches(itemStack)) continue;
            return definition;
        }
        return null;
    }
}

