/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.tabcomplete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class BankTabCompleter
implements TabCompleter {
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("ezeconomy.bank")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            List<String> subs = List.of("create", "delete", "balance", "deposit", "withdraw", "addmember", "removemember", "info");
            return subs.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return Collections.emptyList();
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("deposit") || args[0].equalsIgnoreCase("withdraw")) {
                return List.of("100", "1k", "10k", "100k", "1m", "10m", "100m", "1b");
            }
            return Collections.emptyList();
        }
        if (args.length == 4) {
            List<String> currencies = List.of("dollar", "coin", "gem");
            return currencies.stream().filter(c -> c.startsWith(args[3].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

