/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.storage;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.api.storage.models.Transaction;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;

public class YMLStorageProvider
implements StorageProvider {
    private final File dataFolder;
    private final String namingScheme;
    private final EzEconomyPlugin plugin;
    private final YamlConfiguration dbConfig;
    private final Map<UUID, Object> playerLocks = new ConcurrentHashMap<UUID, Object>();
    private final Map<String, Object> bankLocks = new ConcurrentHashMap<String, Object>();

    public YMLStorageProvider(EzEconomyPlugin plugin, YamlConfiguration dbConfig) {
        this.plugin = plugin;
        this.dbConfig = dbConfig;
        if (dbConfig == null) {
            throw new IllegalArgumentException("YML config is missing!");
        }
        String folderName = dbConfig.getString("yml.data-folder", "data");
        this.dataFolder = new File(plugin.getDataFolder(), folderName);
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        this.namingScheme = dbConfig.getString("yml.per-player-file-naming", "uuid");
    }

    private File getPlayerFile(UUID uuid) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        String username = player.getName() != null ? player.getName() : "unknown";
        return new File(this.dataFolder, switch (this.namingScheme) {
            default -> uuid.toString() + ".yml";
            case "username" -> username + ".yml";
        });
    }

    private YamlConfiguration loadPlayerData(UUID uuid) {
        File file = this.getPlayerFile(uuid);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private Object getPlayerLock(UUID uuid) {
        return this.playerLocks.computeIfAbsent(uuid, key -> new Object());
    }

    private Object getBankLock(String name) {
        return this.bankLocks.computeIfAbsent(name, key -> new Object());
    }

    private void savePlayerData(UUID uuid, YamlConfiguration data) {
        File file = this.getPlayerFile(uuid);
        try {
            if (!data.isString("uuid")) {
                data.set("uuid", (Object)uuid.toString());
            }
            data.save(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getBalance(UUID uuid, String currency) {
        Object object = this.getPlayerLock(uuid);
        synchronized (object) {
            try {
                YamlConfiguration pdata = this.loadPlayerData(uuid);
                return pdata.getDouble("balances." + currency, 0.0);
            }
            catch (Exception e) {
                System.err.println("[EzEconomy] Failed to get balance for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
                return 0.0;
            }
        }
    }

    @Override
    public void setBalance(UUID uuid, String currency, double amount) {
        CompletableFuture.runAsync(() -> {
            Object object = this.getPlayerLock(uuid);
            synchronized (object) {
                try {
                    YamlConfiguration pdata = this.loadPlayerData(uuid);
                    pdata.set("balances." + currency, (Object)amount);
                    this.savePlayerData(uuid, pdata);
                }
                catch (Exception e) {
                    System.err.println("[EzEconomy] Failed to save balance for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryWithdraw(UUID uuid, String currency, double amount) {
        Object object = this.getPlayerLock(uuid);
        synchronized (object) {
            try {
                YamlConfiguration pdata = this.loadPlayerData(uuid);
                double balance = pdata.getDouble("balances." + currency, 0.0);
                if (balance < amount) {
                    return false;
                }
                pdata.set("balances." + currency, (Object)(balance - amount));
                this.savePlayerData(uuid, pdata);
                return true;
            }
            catch (Exception e) {
                System.err.println("[EzEconomy] Failed to withdraw balance for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deposit(UUID uuid, String currency, double amount) {
        Object object = this.getPlayerLock(uuid);
        synchronized (object) {
            try {
                YamlConfiguration pdata = this.loadPlayerData(uuid);
                double balance = pdata.getDouble("balances." + currency, 0.0);
                pdata.set("balances." + currency, (Object)(balance + amount));
                this.savePlayerData(uuid, pdata);
            }
            catch (Exception e) {
                System.err.println("[EzEconomy] Failed to deposit balance for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
        }
    }

    @Override
    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, Double> getAllBalances(String currency) {
        Object object = this.getBankLock("all-balances");
        synchronized (object) {
            HashMap<UUID, Double> map = new HashMap<UUID, Double>();
            File[] files = this.dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
            if (files == null) {
                return map;
            }
            for (File file : files) {
                try {
                    UUID uuid;
                    YamlConfiguration pdata;
                    block16: {
                        pdata = YamlConfiguration.loadConfiguration((File)file);
                        uuid = null;
                        String storedUuid = pdata.getString("uuid");
                        if (storedUuid != null && !storedUuid.isBlank()) {
                            try {
                                uuid = UUID.fromString(storedUuid);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        if (uuid == null) {
                            String fname = file.getName();
                            String namePart = fname.replace(".yml", "");
                            try {
                                uuid = UUID.fromString(namePart);
                            }
                            catch (IllegalArgumentException illegalArgumentEx) {
                                OfflinePlayer player = Bukkit.getOfflinePlayer((String)namePart);
                                if (player != null) {
                                    uuid = player.getUniqueId();
                                }
                                if (uuid == null) break block16;
                                pdata.set("uuid", (Object)uuid.toString());
                                try {
                                    pdata.save(file);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (uuid == null) continue;
                    double bal = pdata.getDouble("balances." + currency, 0.0);
                    map.put(uuid, bal);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return map;
        }
    }

    private File findBankOwnerFile(String bankName) {
        File[] files = this.dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null) {
            return null;
        }
        for (File file : files) {
            YamlConfiguration pdata = YamlConfiguration.loadConfiguration((File)file);
            if (!pdata.isConfigurationSection("banks." + bankName)) continue;
            return file;
        }
        return null;
    }

    private YamlConfiguration loadBankData(String bankName) {
        File file = this.findBankOwnerFile(bankName);
        if (file == null) {
            return null;
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private void saveBankData(String bankName, YamlConfiguration data) {
        File file = this.findBankOwnerFile(bankName);
        if (file != null) {
            try {
                data.save(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createBank(String name, UUID owner) {
        Object object = this.getBankLock(name);
        synchronized (object) {
            YamlConfiguration pdata = this.loadPlayerData(owner);
            if (pdata.isConfigurationSection("banks." + name)) {
                return false;
            }
            pdata.set("banks." + name + ".balances.dollar", (Object)0.0);
            pdata.set("banks." + name + ".owners", List.of(owner.toString()));
            pdata.set("banks." + name + ".members", new ArrayList());
            this.savePlayerData(owner, pdata);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteBank(String name) {
        Object object = this.getBankLock(name);
        synchronized (object) {
            File file = this.findBankOwnerFile(name);
            if (file == null) {
                return false;
            }
            YamlConfiguration pdata = YamlConfiguration.loadConfiguration((File)file);
            if (!pdata.isConfigurationSection("banks." + name)) {
                return false;
            }
            pdata.set("banks." + name, null);
            try {
                pdata.save(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bankExists(String name) {
        Object object = this.getBankLock(name);
        synchronized (object) {
            return this.findBankOwnerFile(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getBankBalance(String name, String currency) {
        Object object = this.getBankLock(name);
        synchronized (object) {
            YamlConfiguration pdata = this.loadBankData(name);
            if (pdata == null) {
                return 0.0;
            }
            return pdata.getDouble("banks." + name + ".balances." + currency, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBankBalance(String name, String currency, double amount) {
        Object object = this.getBankLock(name);
        synchronized (object) {
            YamlConfiguration pdata = this.loadBankData(name);
            if (pdata == null) {
                return;
            }
            pdata.set("banks." + name + ".balances." + currency, (Object)amount);
            this.saveBankData(name, pdata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryWithdrawBank(String name, String currency, double amount) {
        Object object = this.getBankLock(name);
        synchronized (object) {
            YamlConfiguration pdata = this.loadBankData(name);
            if (pdata == null) {
                return false;
            }
            double balance = pdata.getDouble("banks." + name + ".balances." + currency, 0.0);
            if (balance < amount) {
                return false;
            }
            pdata.set("banks." + name + ".balances." + currency, (Object)(balance - amount));
            this.saveBankData(name, pdata);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void depositBank(String name, String currency, double amount) {
        Object object = this.getBankLock(name);
        synchronized (object) {
            YamlConfiguration pdata = this.loadBankData(name);
            if (pdata == null) {
                return;
            }
            double balance = pdata.getDouble("banks." + name + ".balances." + currency, 0.0);
            pdata.set("banks." + name + ".balances." + currency, (Object)(balance + amount));
            this.saveBankData(name, pdata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getBanks() {
        Object object = this.getBankLock("all-banks");
        synchronized (object) {
            HashSet<String> banks = new HashSet<String>();
            File[] files = this.dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
            if (files == null) {
                return banks;
            }
            for (File file : files) {
                YamlConfiguration pdata = YamlConfiguration.loadConfiguration((File)file);
                if (!pdata.isConfigurationSection("banks")) continue;
                banks.addAll(pdata.getConfigurationSection("banks").getKeys(false));
            }
            return banks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBankOwner(String name, UUID uuid) {
        Object object = this.getBankLock(name);
        synchronized (object) {
            YamlConfiguration pdata = this.loadBankData(name);
            if (pdata == null) {
                return false;
            }
            List owners = pdata.getStringList("banks." + name + ".owners");
            return owners.contains(uuid.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBankMember(String name, UUID uuid) {
        Object object = this.getBankLock(name);
        synchronized (object) {
            YamlConfiguration pdata = this.loadBankData(name);
            if (pdata == null) {
                return false;
            }
            List members = pdata.getStringList("banks." + name + ".members");
            return members.contains(uuid.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBankMember(String name, UUID uuid) {
        Object object = this.getBankLock(name);
        synchronized (object) {
            YamlConfiguration pdata = this.loadBankData(name);
            if (pdata == null) {
                return false;
            }
            List members = pdata.getStringList("banks." + name + ".members");
            if (members.contains(uuid.toString())) {
                return false;
            }
            members.add(uuid.toString());
            pdata.set("banks." + name + ".members", (Object)members);
            this.saveBankData(name, pdata);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeBankMember(String name, UUID uuid) {
        Object object = this.getBankLock(name);
        synchronized (object) {
            YamlConfiguration pdata = this.loadBankData(name);
            if (pdata == null) {
                return false;
            }
            List members = pdata.getStringList("banks." + name + ".members");
            if (!members.contains(uuid.toString())) {
                return false;
            }
            members.remove(uuid.toString());
            pdata.set("banks." + name + ".members", (Object)members);
            this.saveBankData(name, pdata);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<UUID> getBankMembers(String name) {
        Object object = this.getBankLock(name);
        synchronized (object) {
            YamlConfiguration pdata = this.loadBankData(name);
            HashSet<UUID> set = new HashSet<UUID>();
            if (pdata == null) {
                return set;
            }
            List members = pdata.getStringList("banks." + name + ".members");
            for (String s : members) {
                try {
                    set.add(UUID.fromString(s));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logTransaction(Transaction transaction) {
        UUID uuid = transaction.getUuid();
        String currency = transaction.getCurrency();
        Object object = this.getPlayerLock(uuid);
        synchronized (object) {
            try {
                YamlConfiguration pdata = this.loadPlayerData(uuid);
                ArrayList txList = pdata.getList("transactions." + currency);
                if (txList == null) {
                    txList = new ArrayList();
                }
                HashMap<String, Object> txMap = new HashMap<String, Object>();
                txMap.put("uuid", transaction.getUuid().toString());
                txMap.put("currency", transaction.getCurrency());
                txMap.put("amount", transaction.getAmount());
                txMap.put("timestamp", transaction.getTimestamp());
                txList.add(txMap);
                pdata.set("transactions." + currency, txList);
                this.savePlayerData(uuid, pdata);
            }
            catch (Exception e) {
                System.err.println("[EzEconomy] Failed to log transaction for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Transaction> getTransactions(UUID uuid, String currency) {
        Object object = this.getPlayerLock(uuid);
        synchronized (object) {
            ArrayList<Transaction> result = new ArrayList<Transaction>();
            try {
                YamlConfiguration pdata = this.loadPlayerData(uuid);
                List txList = pdata.getList("transactions." + currency);
                if (txList != null) {
                    for (Object obj : txList) {
                        if (!(obj instanceof Map)) continue;
                        Map txMap = (Map)obj;
                        try {
                            UUID txUuid = UUID.fromString(String.valueOf(txMap.get("uuid")));
                            String txCurrency = String.valueOf(txMap.get("currency"));
                            double txAmount = Double.parseDouble(String.valueOf(txMap.get("amount")));
                            long txTimestamp = Long.parseLong(String.valueOf(txMap.get("timestamp")));
                            result.add(new Transaction(txUuid, txCurrency, txAmount, txTimestamp));
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                System.err.println("[EzEconomy] Failed to get transactions for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
            return result;
        }
    }
}

