/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.storage;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.api.storage.exceptions.StorageInitException;
import com.skyblockexp.ezeconomy.api.storage.exceptions.StorageLoadException;
import com.skyblockexp.ezeconomy.api.storage.exceptions.StorageSaveException;
import com.skyblockexp.ezeconomy.api.storage.models.Transaction;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class SQLiteStorageProvider
implements StorageProvider {
    private String fileName;
    private final EzEconomyPlugin plugin;
    private Connection connection;
    private String table;
    private String banksTable;
    private final Object lock = new Object();
    private final YamlConfiguration dbConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logTransaction(Transaction tx) {
        Object object = this.lock;
        synchronized (object) {
            try {
                String sql = "INSERT INTO transactions (uuid, currency, amount, timestamp) VALUES (?, ?, ?, ?)";
                PreparedStatement ps = this.connection.prepareStatement(sql);
                ps.setString(1, tx.getUuid().toString());
                ps.setString(2, tx.getCurrency());
                ps.setDouble(3, tx.getAmount());
                ps.setLong(4, tx.getTimestamp());
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite logTransaction failed: " + e.getMessage());
            }
        }
    }

    public SQLiteStorageProvider(EzEconomyPlugin plugin) {
        this.plugin = plugin;
        this.dbConfig = null;
        this.fileName = "economy.db";
        this.table = "balances";
        this.banksTable = "banks";
    }

    public SQLiteStorageProvider(EzEconomyPlugin plugin, YamlConfiguration dbConfig) {
        this.plugin = plugin;
        this.dbConfig = dbConfig;
        if (dbConfig == null) {
            throw new IllegalArgumentException("SQLite config is missing!");
        }
        this.fileName = dbConfig.getString("sqlite.file", "ezeconomy.db");
        this.table = dbConfig.getString("sqlite.table", "balances");
        this.banksTable = dbConfig.getString("sqlite.banksTable", "banks");
        try {
            File file = new File(plugin.getDataFolder(), this.fileName);
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + file.getAbsolutePath());
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS '" + this.table + "' (uuid TEXT, currency TEXT, balance DOUBLE, PRIMARY KEY (uuid, currency))");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS '" + this.banksTable + "' (name TEXT PRIMARY KEY, owner TEXT, members TEXT, balances TEXT)");
        }
        catch (SQLException e) {
            plugin.getLogger().severe("SQLite connection failed: " + e.getMessage());
            throw new RuntimeException("Failed to initialize SQLiteStorageProvider", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Transaction> getTransactions(UUID uuid, String currency) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        Object object = this.lock;
        synchronized (object) {
            try {
                String sql = "SELECT amount, timestamp FROM transactions WHERE uuid=? AND currency=? ORDER BY timestamp DESC";
                PreparedStatement ps = this.connection.prepareStatement(sql);
                ps.setString(1, uuid.toString());
                ps.setString(2, currency);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    double amount = rs.getDouble("amount");
                    long timestamp = rs.getLong("timestamp");
                    Transaction t = new Transaction(uuid, currency, amount, timestamp);
                    transactions.add(t);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite getTransactions failed for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
        }
        return transactions;
    }

    public void init() throws StorageInitException {
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + new File(this.plugin.getDataFolder(), this.fileName).getAbsolutePath());
            this.createTableIfNotExists();
        }
        catch (ClassNotFoundException e) {
            throw new StorageInitException("SQLite JDBC driver not found.", e);
        }
        catch (SQLException e) {
            throw new StorageInitException("Failed to connect to the database.", e);
        }
    }

    private void createTableIfNotExists() throws StorageInitException {
        String sql = "CREATE TABLE IF NOT EXISTS economy (uuid TEXT PRIMARY KEY NOT NULL,balance REAL DEFAULT 0,last_updated INTEGER);";
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            throw new StorageInitException("Failed to create table in the database.", e);
        }
    }

    public void load() throws StorageLoadException {
    }

    public void save() throws StorageSaveException {
    }

    public String toString() {
        return "SQLiteStorageProvider{fileName='" + this.fileName + "', table='" + this.table + "', banksTable='" + this.banksTable + "'}";
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to close the database connection.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getBalance(UUID uuid, String currency) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT balance FROM '" + this.table + "' WHERE uuid=? AND currency=?");
                ps.setString(1, uuid.toString());
                ps.setString(2, currency);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    return rs.getDouble(1);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite getBalance failed for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBalance(UUID uuid, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("REPLACE INTO '" + this.table + "' (uuid, currency, balance) VALUES (?, ?, ?)");
                ps.setString(1, uuid.toString());
                ps.setString(2, currency);
                ps.setDouble(3, amount);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite setBalance failed for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryWithdraw(UUID uuid, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("UPDATE '" + this.table + "' SET balance = balance - ? WHERE uuid=? AND currency=? AND balance >= ?");
                ps.setDouble(1, amount);
                ps.setString(2, uuid.toString());
                ps.setString(3, currency);
                ps.setDouble(4, amount);
                return ps.executeUpdate() > 0;
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite tryWithdraw failed for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deposit(UUID uuid, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("INSERT INTO '" + this.table + "' (uuid, currency, balance) VALUES (?, ?, ?) ON CONFLICT(uuid, currency) DO UPDATE SET balance = balance + excluded.balance");
                ps.setString(1, uuid.toString());
                ps.setString(2, currency);
                ps.setDouble(3, amount);
                ps.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite deposit failed for " + String.valueOf(uuid) + " (" + currency + "): " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<UUID, Double> getAllBalances(String currency) {
        HashMap<UUID, Double> map = new HashMap<UUID, Double>();
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT uuid, balance FROM '" + this.table + "' WHERE currency=?");
                ps.setString(1, currency);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    map.put(UUID.fromString(rs.getString(1)), rs.getDouble(2));
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite getAllBalances failed: " + e.getMessage());
            }
        }
        return map;
    }

    @Override
    public void shutdown() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createBank(String name, UUID owner) {
        Object object = this.lock;
        synchronized (object) {
            if (this.bankExists(name)) {
                return false;
            }
            try {
                String members = owner.toString();
                String balances = "{}";
                PreparedStatement ps = this.connection.prepareStatement("INSERT INTO '" + this.banksTable + "' (name, owner, members, balances) VALUES (?, ?, ?, ?)");
                ps.setString(1, name);
                ps.setString(2, owner.toString());
                ps.setString(3, members);
                ps.setString(4, balances);
                ps.executeUpdate();
                return true;
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite createBank failed: " + e.getMessage());
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteBank(String name) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("DELETE FROM '" + this.banksTable + "' WHERE name=?");
                ps.setString(1, name);
                return ps.executeUpdate() > 0;
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite deleteBank failed: " + e.getMessage());
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bankExists(String name) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT 1 FROM '" + this.banksTable + "' WHERE name=?");
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                return rs.next();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite bankExists failed: " + e.getMessage());
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getBankBalance(String name, String currency) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT balances FROM '" + this.banksTable + "' WHERE name=?");
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    String balancesJson = rs.getString(1);
                    Map<String, Double> balances = this.parseBalances(balancesJson);
                    return balances.getOrDefault(currency, 0.0);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite getBankBalance failed: " + e.getMessage());
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBankBalance(String name, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT balances FROM '" + this.banksTable + "' WHERE name=?");
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                HashMap<String, Double> balances = new HashMap<String, Double>();
                if (rs.next()) {
                    balances = this.parseBalances(rs.getString(1));
                }
                balances.put(currency, amount);
                String newJson = this.toJson(balances);
                PreparedStatement ps2 = this.connection.prepareStatement("UPDATE '" + this.banksTable + "' SET balances=? WHERE name=?");
                ps2.setString(1, newJson);
                ps2.setString(2, name);
                ps2.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite setBankBalance failed: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryWithdrawBank(String name, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT balances FROM '" + this.banksTable + "' WHERE name=?");
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) {
                    return false;
                }
                Map<String, Double> balances = this.parseBalances(rs.getString(1));
                double current = balances.getOrDefault(currency, 0.0);
                if (current < amount) {
                    return false;
                }
                balances.put(currency, current - amount);
                String newJson = this.toJson(balances);
                PreparedStatement ps2 = this.connection.prepareStatement("UPDATE '" + this.banksTable + "' SET balances=? WHERE name=?");
                ps2.setString(1, newJson);
                ps2.setString(2, name);
                ps2.executeUpdate();
                return true;
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite tryWithdrawBank failed: " + e.getMessage());
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void depositBank(String name, String currency, double amount) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT balances FROM '" + this.banksTable + "' WHERE name=?");
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) {
                    return;
                }
                Map<String, Double> balances = this.parseBalances(rs.getString(1));
                balances.put(currency, balances.getOrDefault(currency, 0.0) + amount);
                String newJson = this.toJson(balances);
                PreparedStatement ps2 = this.connection.prepareStatement("UPDATE '" + this.banksTable + "' SET balances=? WHERE name=?");
                ps2.setString(1, newJson);
                ps2.setString(2, name);
                ps2.executeUpdate();
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite depositBank failed: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getBanks() {
        HashSet<String> set = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            try {
                Statement stmt = this.connection.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT name FROM '" + this.banksTable + "'");
                while (rs.next()) {
                    set.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite getBanks failed: " + e.getMessage());
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBankOwner(String name, UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT owner FROM '" + this.banksTable + "' WHERE name=?");
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    return uuid.toString().equals(rs.getString(1));
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite isBankOwner failed: " + e.getMessage());
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBankMember(String name, UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT members FROM '" + this.banksTable + "' WHERE name=?");
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    Set<String> members = this.parseMembers(rs.getString(1));
                    return members.contains(uuid.toString());
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite isBankMember failed: " + e.getMessage());
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBankMember(String name, UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT members FROM '" + this.banksTable + "' WHERE name=?");
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                HashSet<String> members = new HashSet<String>();
                if (rs.next()) {
                    members = this.parseMembers(rs.getString(1));
                }
                if (!members.add(uuid.toString())) {
                    return false;
                }
                PreparedStatement ps2 = this.connection.prepareStatement("UPDATE '" + this.banksTable + "' SET members=? WHERE name=?");
                ps2.setString(1, this.toMemberString(members));
                ps2.setString(2, name);
                ps2.executeUpdate();
                return true;
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite addBankMember failed: " + e.getMessage());
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeBankMember(String name, UUID uuid) {
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT members FROM '" + this.banksTable + "' WHERE name=?");
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                HashSet<String> members = new HashSet();
                if (rs.next()) {
                    members = this.parseMembers(rs.getString(1));
                }
                if (!members.remove(uuid.toString())) {
                    return false;
                }
                PreparedStatement ps2 = this.connection.prepareStatement("UPDATE '" + this.banksTable + "' SET members=? WHERE name=?");
                ps2.setString(1, this.toMemberString(members));
                ps2.setString(2, name);
                ps2.executeUpdate();
                return true;
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite removeBankMember failed: " + e.getMessage());
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<UUID> getBankMembers(String name) {
        HashSet<UUID> set = new HashSet<UUID>();
        Object object = this.lock;
        synchronized (object) {
            try {
                PreparedStatement ps = this.connection.prepareStatement("SELECT members FROM '" + this.banksTable + "' WHERE name=?");
                ps.setString(1, name);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    Set<String> members = this.parseMembers(rs.getString(1));
                    for (String s : members) {
                        try {
                            set.add(UUID.fromString(s));
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().severe("[EzEconomy] SQLite getBankMembers failed: " + e.getMessage());
            }
        }
        return set;
    }

    private Map<String, Double> parseBalances(String json) {
        HashMap<String, Double> map = new HashMap<String, Double>();
        if (json == null || json.isEmpty() || json.equals("{}")) {
            return map;
        }
        if ((json = json.trim()).startsWith("{") && json.endsWith("}")) {
            String[] entries;
            json = json.substring(1, json.length() - 1);
            for (String entry : entries = json.split(",")) {
                String[] kv = entry.split(":");
                if (kv.length != 2) continue;
                String k = kv[0].replaceAll("[\"{}]", "").trim();
                try {
                    map.put(k, Double.parseDouble(kv[1]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return map;
    }

    private String toJson(Map<String, Double> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (Map.Entry<String, Double> e : map.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append("\"").append(e.getKey()).append("\":").append(e.getValue());
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }

    private Set<String> parseMembers(String s) {
        HashSet<String> set = new HashSet<String>();
        if (s == null || s.isEmpty()) {
            return set;
        }
        for (String part : s.split(",")) {
            String trimmed = part.trim();
            if (trimmed.isEmpty()) continue;
            set.add(trimmed);
        }
        return set;
    }

    private String toMemberString(Set<String> set) {
        return String.join((CharSequence)",", set);
    }
}

