/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.storage;

import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DailyRewardStorage {
    private final EzEconomyPlugin plugin;
    private final File file;
    private final FileConfiguration data;

    public DailyRewardStorage(EzEconomyPlugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "daily-rewards.yml");
        this.data = this.load();
    }

    public long getLastReward(UUID uuid) {
        return this.data.getLong(uuid.toString(), 0L);
    }

    public void setLastReward(UUID uuid, long timestamp) {
        this.data.set(uuid.toString(), (Object)timestamp);
        this.save();
    }

    public void reset(UUID uuid) {
        this.data.set(uuid.toString(), null);
        this.save();
    }

    private FileConfiguration load() {
        if (!this.file.exists()) {
            try {
                this.plugin.getDataFolder().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to create daily-rewards.yml: " + e.getMessage());
            }
        }
        return YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void save() {
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save daily rewards data: " + e.getMessage());
        }
    }
}

