/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezeconomy.placeholder;

import com.skyblockexp.ezeconomy.api.storage.StorageProvider;
import com.skyblockexp.ezeconomy.core.EzEconomyPlugin;
import com.skyblockexp.ezeconomy.core.VaultEconomyImpl;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public class EzEconomyPlaceholderExpansion
extends PlaceholderExpansion {
    private EzEconomyPlugin plugin;

    public EzEconomyPlaceholderExpansion(EzEconomyPlugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getAuthor() {
        return "Shadow48402";
    }

    @NotNull
    public String getIdentifier() {
        return "ezeconomy";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String getRequiredPlugin() {
        return "EzEconomy";
    }

    public boolean canRegister() {
        this.plugin = (EzEconomyPlugin)Bukkit.getPluginManager().getPlugin(this.getRequiredPlugin());
        return this.plugin != null;
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        block18: {
            String defaultCurrency;
            VaultEconomyImpl eco = this.plugin.getEconomy();
            FileConfiguration config = this.plugin.getConfig();
            boolean multiEnabled = config.getBoolean("multi-currency.enabled", false);
            String preferredCurrency = defaultCurrency = multiEnabled ? config.getString("multi-currency.default", "dollar") : "dollar";
            if (player != null) {
                preferredCurrency = this.plugin.getCurrencyPreferenceManager().getPreferredCurrency(player.getUniqueId());
            }
            StorageProvider storage = this.plugin.getStorageOrWarn();
            String[] split = params.toLowerCase().split("_");
            try {
                int rank;
                if (params.equalsIgnoreCase("balance")) {
                    if (player == null || storage == null) {
                        return null;
                    }
                    double bal = storage.getBalance(player.getUniqueId(), preferredCurrency);
                    return eco.format(bal);
                }
                if (split.length == 2 && split[0].equals("balance")) {
                    if (player == null || storage == null) {
                        return null;
                    }
                    String currency = split[1];
                    double bal = storage.getBalance(player.getUniqueId(), currency);
                    return eco.format(bal);
                }
                if (split.length == 2 && split[0].equals("symbol")) {
                    String currency = split[1];
                    if (multiEnabled && config.contains("multi-currency.currencies." + currency + ".symbol")) {
                        return config.getString("multi-currency.currencies." + currency + ".symbol", "$");
                    }
                    if (currency.equals("dollar")) {
                        return "$";
                    }
                    return "?";
                }
                if (split.length >= 2 && split[0].equals("bank")) {
                    String currency;
                    if (player == null || storage == null) {
                        return null;
                    }
                    String bank = split[1];
                    String string = currency = split.length == 3 ? split[2] : preferredCurrency;
                    if (storage.isBankMember(bank, player.getUniqueId())) {
                        double bal = storage.getBankBalance(bank, currency);
                        return eco.format(bal);
                    }
                    return "-";
                }
                if (split.length != 2 || !split[0].equals("top")) break block18;
                if (storage == null) {
                    return null;
                }
                try {
                    rank = Integer.parseInt(split[1]);
                }
                catch (NumberFormatException e) {
                    return null;
                }
                if (rank <= 0) {
                    return null;
                }
                Map<UUID, Double> balances = storage.getAllBalances(preferredCurrency);
                List sorted = balances.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).toList();
                if (rank > sorted.size()) {
                    return null;
                }
                Map.Entry entry = sorted.get(rank - 1);
                OfflinePlayer topPlayer = Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey()));
                return topPlayer.getName() + ": " + eco.format((Double)entry.getValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

